/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.bluelight;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.table.TableCellRenderer;

public class GraphicsUtils
extends de.javasoft.plaf.synthetica.GraphicsUtils {
    private boolean textShadowEnabled = SyntheticaLookAndFeel.getBoolean((String)"SyntheticaBlueLight.textShadowEnabled", null, (boolean)true);
    private boolean useSimpleTextShadow = SyntheticaLookAndFeel.getBoolean((String)"SyntheticaBlueLight.useSimpleTextShadow", null, (boolean)true);
    private Color optionalForeground = Color.BLACK;
    private Color optionalForeground_disabled = new Color(0x50000000, true);

    public void paintText(SynthContext sc, Graphics g, String text, int x, int y, int mnemonicIndex) {
        JTable table;
        boolean focused;
        JComponent c = sc.getComponent();
        String name = c.getName();
        Region region = sc.getRegion();
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        boolean disabled = (sc.getComponentState() & 8) > 0;
        boolean hover = (sc.getComponentState() & 2) > 0;
        boolean pressed = (sc.getComponentState() & 4) > 0;
        Container cParent = c.getParent();
        Container grandParent = cParent == null ? null : cParent.getParent();
        boolean respectFocus = SyntheticaLookAndFeel.getBoolean((String)"Synthetica.cellRenderer.respectFocus", (Component)c, (boolean)false);
        boolean bl = respectFocus ? (grandParent != null ? grandParent.hasFocus() : false) : (focused = false);
        if ("Table.cellRenderer".equals(name) && respectFocus && grandParent instanceof JTable && (table = (JTable)grandParent).getCellEditor() != null) {
            focused = true;
        }
        JComponent parent = cParent instanceof JComponent ? (JComponent)cParent : null;
        JToolBar opaqueToolBar = null;
        boolean isToolBarChild = parent instanceof JToolBar;
        Color paintColor = g.getColor();
        if (region == Region.BUTTON || region == Region.TOGGLE_BUTTON) {
            Color fg;
            if (pressed && !selected) {
                ++y;
            }
            opaqueToolBar = (JToolBar)SyntheticaLookAndFeel.findOpaqueParentOfClass(JToolBar.class, (Container)c, (boolean)false);
            if (isToolBarChild && paintColor instanceof UIResource && !"ButtonBar".equals(parent.getName()) && !hover && !pressed) {
                fg = disabled ? this.optionalForeground_disabled : this.optionalForeground;
                g.setColor(fg);
            } else if (!(((AbstractButton)c).isContentAreaFilled() && SyntheticaLookAndFeel.isOpaque((JComponent)c) || !(paintColor instanceof UIResource) || name != null && name.startsWith("XMenu"))) {
                fg = disabled ? this.optionalForeground_disabled : this.optionalForeground;
                g.setColor(fg);
            }
        } else if ((region == Region.LABEL || region == Region.CHECK_BOX) && -1 == c.getForeground().getRGB() && ("List.cellRenderer".equals(name) || "Table.cellRenderer".equals(name) || "Tree.cellRenderer".equals(name) || "JYCheckBoxTree.cellRenderer".equals(name))) {
            if (!(grandParent instanceof JTable) && !(grandParent instanceof JTree) && !(grandParent instanceof JList) || grandParent instanceof JTree && grandParent instanceof TableCellRenderer) {
                Container parent_ = grandParent;
                while (parent_ != null && !parent_.hasFocus()) {
                    parent_ = parent_.getParent();
                }
                boolean bl2 = focused = parent_ == null || parent_ instanceof JRootPane ? false : parent_.hasFocus();
            }
            if (respectFocus && !focused) {
                g.setColor(this.optionalForeground);
            }
        }
        if (this.textShadowEnabled && ((Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.textShadowEnabled", (JComponent)c, (Object)this.textShadowEnabled)).booleanValue()) {
            if (region == Region.MENU && ((JMenu)c).isTopLevelMenu()) {
                Window w = SwingUtilities.getWindowAncestor(c);
                if (w != null && w.isActive() && !(hover |= ((Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.MOUSE_OVER", (JComponent)c, (Object)false)).booleanValue()) && !selected) {
                    this.paintBrightShadow(c, g, x, y, text, mnemonicIndex);
                } else if (w != null && w.isActive() && (hover || selected) && !disabled) {
                    this.paintDarkShadow(c, g, x, y, text, mnemonicIndex);
                }
            } else if (region == Region.MENU && selected) {
                this.paintDarkShadow(c, g, x, y, text, mnemonicIndex);
            } else if (c instanceof JMenuItem && hover) {
                this.paintDarkShadow(c, g, x, y, text, mnemonicIndex);
            } else if (region == Region.LABEL && "TableHeader.renderer".equals(name)) {
                this.paintDarkShadow(c, g, x, y, text, mnemonicIndex);
            } else if (region == Region.LABEL && -1 == c.getForeground().getRGB()) {
                if (focused && ("List.cellRenderer".equals(name) || "Table.cellRenderer".equals(name) || "Tree.cellRenderer".equals(name))) {
                    this.paintDarkShadow(c, g, x, y, text, mnemonicIndex);
                } else if ("ComboBox.listRenderer".equals(name) && grandParent != null && "ComboBox.list".equals(grandParent.getName())) {
                    this.paintDarkShadow(c, g, x, y, text, mnemonicIndex);
                }
            } else if (!(region != Region.BUTTON && region != Region.TOGGLE_BUTTON || opaqueToolBar != null || disabled)) {
                if (hover && !pressed && !selected && g.getColor().equals(Color.BLACK)) {
                    this.paintBrightShadow(c, g, x, y, text, mnemonicIndex);
                } else if (g.getColor().equals(Color.WHITE)) {
                    this.paintDarkShadow(c, g, x, y, text, mnemonicIndex);
                }
            }
        }
        super.paintText(sc, g, text, x, y, mnemonicIndex);
    }

    private void paintBrightShadow(JComponent c, Graphics g, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c, g, x, y, text, false, 1, -2, 0.75f, Color.WHITE, 0, 1, mnemonicIndex);
    }

    private void paintDarkShadow(JComponent c, Graphics g, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c, g, x, y, text, false, 1, -2, 0.5f, Color.BLACK, 0, -1, mnemonicIndex);
    }

    private void paintShadow(JComponent c, Graphics g, int x, int y, String text, boolean highQuality, int size, int distance, float opacity, Color color, int xOffset, int yOffset, int mnemonicIndex) {
        size = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(size));
        distance = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(distance));
        xOffset = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(xOffset));
        yOffset = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(yOffset));
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = null;
        if (OS.getCurrentOS() == OS.Mac) {
            rh = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (this.useSimpleTextShadow) {
            FontMetrics fm = g.getFontMetrics(c.getFont());
            Color col = g.getColor();
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * opacity / 1.25f)));
            g.drawString(text, x + xOffset, y + yOffset + fm.getAscent());
            g.setColor(col);
        } else {
            this.paintTextShadow(c, g, x, y, text, highQuality, size, distance, opacity, color, xOffset, yOffset, false, mnemonicIndex);
        }
        if (OS.getCurrentOS() == OS.Mac) {
            g2.setRenderingHints(rh);
        }
    }
}

