/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.helper;

import com.macrofocus.helper.OSHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import javax.swing.JApplet;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class SwingHelper {
    public static boolean isMultipleSelectionKey(InputEvent event) {
        InputEvent inputEvent;
        if (OSHelper.isMacOSX()) {
            return event.isMetaDown();
        }
        return inputEvent.isControlDown();
    }

    public static int getMultipleSelectionKey() {
        if (OSHelper.isMacOSX()) {
            return 256;
        }
        return 128;
    }

    public static JLayeredPane getTopLayeredPane(Component c2) {
        JLayeredPane jLayeredPane = null;
        for (Component component = component.getParent(); component != null; component = component.getParent()) {
            if (component instanceof JLayeredPane) {
                jLayeredPane = (JLayeredPane)component;
                break;
            }
            if (component instanceof JRootPane) {
                if (component.getParent() instanceof JInternalFrame) continue;
                jLayeredPane = ((JRootPane)component).getLayeredPane();
                break;
            }
            if (component instanceof Window || component instanceof JApplet) break;
        }
        return jLayeredPane;
    }

    public static Point convertScreenLocationToParent(Container parent, int x, int y) {
        for (Container container = parent; container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            Point point = new Point(x, y);
            SwingUtilities.convertPointFromScreen(point, parent);
            return point;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor");
    }

    public static Rectangle getBoundsOnScreen(Component c2) {
        Component component;
        Point point = c2.getLocationOnScreen();
        return new Rectangle(point.x, point.y, c2.getWidth(), component.getHeight());
    }

    public static void setFocusable(Container parent, boolean focusable) {
        parent.setFocusable(false);
        for (int i2 = 0; i2 < parent.getComponentCount(); ++i2) {
            Component component = parent.getComponent(i2);
            if (component instanceof Container) {
                SwingHelper.setFocusable((Container)component, focusable);
                continue;
            }
            component.setFocusable(focusable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void center(Container parent, Component component) {
        if (parent != null && component != null) {
            Container container;
            void var1_1;
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = parent.getSize();
            int n = dimension2.width - dimension.width;
            int n2 = dimension2.height - dimension.height;
            var1_1.setBounds(n / 2, n2 / 2, dimension.width, dimension.height);
            container.validate();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void centerBottom(Container parent, Component component) {
        if (parent != null && component != null) {
            Container container;
            void var1_1;
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = parent.getSize();
            int n = dimension2.width - dimension.width;
            int n2 = dimension2.height - dimension.height;
            var1_1.setBounds(n / 2, n2, dimension.width, dimension.height);
            container.validate();
        }
    }

    public static boolean isDescendingFrom(Component focusOwner, Component parent) {
        while (focusOwner != null) {
            if (focusOwner instanceof JPopupMenu && (focusOwner = ((JPopupMenu)focusOwner).getInvoker()) == null) {
                return false;
            }
            if (focusOwner == parent) {
                return true;
            }
            focusOwner = focusOwner.getParent();
        }
        return false;
    }
}

