/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.jide.logging;

import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.macrofocus.util.logging.SwingLoggingOutput;
import java.awt.Component;
import java.awt.HeadlessException;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class JideLoggingOutput
implements SwingLoggingOutput {
    private final Component parentComponent;

    public JideLoggingOutput(Component parentComponent) {
        this.parentComponent = parentComponent;
        LookAndFeelFactory.UIDefaultsCustomizer uiDefaultsCustomizer = new LookAndFeelFactory.UIDefaultsCustomizer(){

            public void customize(UIDefaults defaults) {
                ThemePainter painter = (ThemePainter)UIDefaultsLookup.get((Object)"Theme.painter");
                defaults.put("OptionPaneUI", "com.jidesoft.plaf.basic.BasicJideOptionPaneUI");
                defaults.put("OptionPane.showBanner", Boolean.TRUE);
                defaults.put("OptionPane.bannerFontSize", (Object)13);
                defaults.put("OptionPane.bannerFontStyle", (Object)1);
                defaults.put("OptionPane.bannerMaxCharsPerLine", (Object)60);
                defaults.put("OptionPane.bannerForeground", painter != null ? painter.getOptionPaneBannerForeground() : null);
                defaults.put("OptionPane.bannerBorder", (Object)null);
                defaults.put("OptionPane.bannerBackgroundDk", painter != null ? painter.getOptionPaneBannerDk() : null);
                defaults.put("OptionPane.bannerBackgroundLt", painter != null ? painter.getOptionPaneBannerLt() : null);
                defaults.put("OptionPane.bannerBackgroundDirection", Boolean.TRUE);
                defaults.put("OptionPane.bannerBackgroundPaint", (Object)null);
                defaults.put("OptionPane.buttonAreaBorder", BorderFactory.createEmptyBorder(6, 6, 6, 6));
                defaults.put("OptionPane.buttonOrientation", (Object)4);
            }
        };
        uiDefaultsCustomizer.customize(UIManager.getDefaults());
    }

    public boolean process(Throwable t) {
        return this.process(this.parentComponent, t);
    }

    public boolean process(Component parentComponent, Throwable t) {
        t.printStackTrace();
        try {
            JideOptionPane optionPane = new JideOptionPane((Object)"Click \"Details\" button to see more information ... ", 0, 2);
            optionPane.setTitle((Object)"An exception happened during file transfers - if the title is very long, it will wrap automatically.");
            String message = t.getMessage();
            if (message != null && message.contains("\n")) {
                message = message.substring(0, message.indexOf("\n"));
            }
            optionPane.setTitle((Object)message);
            StringBuffer details = new StringBuffer();
            details.append(t.toString());
            details.append("\n");
            StackTraceElement[] trace = t.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                details.append("\tat " + trace[i] + "\n");
            }
            Throwable ourCause = t.getCause();
            if (ourCause != null) {
                this.printStackTraceAsCause(ourCause, details, trace);
            }
            optionPane.setDetails((Object)details.toString());
            try {
                JDialog dialog = optionPane.createDialog(parentComponent, "Error");
                dialog.setResizable(true);
                dialog.pack();
                dialog.setVisible(true);
            }
            catch (HeadlessException dialog) {
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            int value = (Integer)optionPane.getValue();
            return value == 2;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private void printStackTraceAsCause(Throwable t, StringBuffer details, StackTraceElement[] causedTrace) {
        Throwable ourCause;
        StackTraceElement[] trace = t.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        details.append("Caused by " + t + "\n");
        for (int i = 0; i <= m; ++i) {
            details.append("\tat " + trace[i] + "\n");
        }
        if (framesInCommon != 0) {
            details.append("\t... " + framesInCommon + " more\n");
        }
        if ((ourCause = t.getCause()) != null) {
            this.printStackTraceAsCause(ourCause, details, trace);
        }
    }
}

