/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class MultiLineHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;
    double[] xy;
    double[] z;

    public MultiLineHandler(GeometryFactory gf) {
        this.shapeType = ShapeType.ARC;
        this.geometryFactory = gf;
    }

    public MultiLineHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (!type.isLineType()) {
            throw new ShapefileException("MultiLineHandler constructor - expected type to be 3,13 or 23");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public int getLength(Object geometry) {
        int length;
        MultiLineString multi = (MultiLineString)geometry;
        int numlines = multi.getNumGeometries();
        int numpoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.ARC) {
            length = 44 + 4 * numlines + numpoints * 16;
        } else if (this.shapeType == ShapeType.ARCM) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints;
        } else if (this.shapeType == ShapeType.ARCZ) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints + 8 + 8 + 8 * numpoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + (Object)((Object)this.shapeType));
        }
        return length;
    }

    private Object createNull() {
        return this.geometryFactory.createMultiLineString(null);
    }

    @Override
    public Object read(ByteBuffer buffer, ShapeType type, boolean flatGeometry) {
        boolean isArcZWithM;
        int finish;
        int part;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        int dimensions = (this.shapeType == ShapeType.ARCZ || this.shapeType == ShapeType.ARCM) && !flatGeometry ? 3 : 2;
        ((Buffer)buffer).position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        int start = 0;
        int length = 0;
        boolean clonePoint = false;
        DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
        for (part = 0; part < numParts; ++part) {
            int measure;
            start = partOffsets[part];
            finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int xyLength = length = finish - start;
            if (length == 1) {
                length = 2;
                clonePoint = true;
            } else {
                clonePoint = false;
            }
            int n = measure = flatGeometry ? 0 : 1;
            CoordinateSequence cs = this.shapeType == ShapeType.ARCM ? JTS.createCS((CoordinateSequenceFactory)this.geometryFactory.getCoordinateSequenceFactory(), (int)length, (int)(dimensions + measure), (int)measure) : (this.shapeType == ShapeType.ARCZ ? JTS.createCS((CoordinateSequenceFactory)this.geometryFactory.getCoordinateSequenceFactory(), (int)length, (int)(dimensions + measure), (int)measure) : JTS.createCS((CoordinateSequenceFactory)this.geometryFactory.getCoordinateSequenceFactory(), (int)length, (int)dimensions));
            double[] xy = new double[xyLength * 2];
            doubleBuffer.get(xy);
            for (int i = 0; i < xyLength; ++i) {
                cs.setOrdinate(i, 0, xy[i * 2]);
                cs.setOrdinate(i, 1, xy[i * 2 + 1]);
            }
            if (clonePoint) {
                cs.setOrdinate(1, 0, cs.getOrdinate(0, 0));
                cs.setOrdinate(1, 1, cs.getOrdinate(0, 1));
            }
            lines[part] = cs;
        }
        if (this.shapeType == ShapeType.ARCZ && !flatGeometry) {
            ((Buffer)doubleBuffer).position(doubleBuffer.position() + 2);
            for (part = 0; part < numParts; ++part) {
                finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - (start = partOffsets[part]);
                if (length == 1) {
                    length = 2;
                    clonePoint = true;
                } else {
                    clonePoint = false;
                }
                double[] z = new double[length];
                doubleBuffer.get(z);
                for (int i = 0; i < length; ++i) {
                    lines[part].setOrdinate(i, 2, z[i]);
                }
            }
        }
        boolean bl = isArcZWithM = doubleBuffer.hasRemaining() && this.shapeType == ShapeType.ARCZ;
        if ((isArcZWithM || this.shapeType == ShapeType.ARCM) && !flatGeometry) {
            ((Buffer)doubleBuffer).position(doubleBuffer.position() + 2);
            for (int part2 = 0; part2 < numParts; ++part2) {
                finish = part2 == numParts - 1 ? numPoints : partOffsets[part2 + 1];
                length = finish - (start = partOffsets[part2]);
                if (length == 1) {
                    length = 2;
                    clonePoint = true;
                } else {
                    clonePoint = false;
                }
                double[] m = new double[length];
                doubleBuffer.get(m);
                for (int i = 0; i < length; ++i) {
                    lines[part2].setOrdinate(i, 3, m[i]);
                }
            }
        }
        LineString[] lineStrings = new LineString[numParts];
        for (int part3 = 0; part3 < numParts; ++part3) {
            lineStrings[part3] = this.geometryFactory.createLineString(lines[part3]);
        }
        return this.geometryFactory.createMultiLineString(lineStrings);
    }

    @Override
    public void write(ByteBuffer buffer, Object geometry) {
        int ncoords;
        MultiLineString multi = (MultiLineString)geometry;
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        int numParts = multi.getNumGeometries();
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        double[] zExtreame = new double[]{Double.NaN, Double.NaN};
        int npoints = multi.getNumPoints();
        buffer.putInt(numParts);
        buffer.putInt(npoints);
        int idx = 0;
        for (int i = 0; i < numParts; ++i) {
            lines[i] = ((LineString)multi.getGeometryN(i)).getCoordinateSequence();
            buffer.putInt(idx);
            idx += lines[i].size();
        }
        for (CoordinateSequence coords : lines) {
            if (this.shapeType == ShapeType.ARCZ) {
                JTSUtilities.zMinMax(coords, zExtreame);
            }
            ncoords = coords.size();
            for (int t = 0; t < ncoords; ++t) {
                buffer.putDouble(coords.getX(t));
                buffer.putDouble(coords.getY(t));
            }
        }
        if (this.shapeType == ShapeType.ARCZ) {
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (CoordinateSequence coords : lines) {
                ncoords = coords.size();
                for (int t = 0; t < ncoords; ++t) {
                    double z = coords.getOrdinate(t, 2);
                    if (Double.isNaN(z)) {
                        buffer.putDouble(0.0);
                        continue;
                    }
                    buffer.putDouble(z);
                }
            }
        }
        if (this.shapeType == ShapeType.ARCZ || this.shapeType == ShapeType.ARCM) {
            ArrayList<Double> mvalues = new ArrayList<Double>();
            int tt = multi.getNumGeometries();
            for (int t = 0; t < tt; ++t) {
                LineString line = (LineString)multi.getGeometryN(t);
                CoordinateSequence seq = line.getCoordinateSequence();
                for (int i = 0; i < seq.size(); ++i) {
                    mvalues.add(line.getCoordinateSequence().getM(i));
                }
            }
            buffer.putDouble((Double)mvalues.stream().min(Double::compare).get());
            buffer.putDouble((Double)mvalues.stream().max(Double::compare).get());
            mvalues.forEach(x -> buffer.putDouble((double)x));
        }
    }
}

