/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe.java;

import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.molap.dataframe.AbstractDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.MultiKey;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.AbstractSeries;
import com.macrofocus.molap.series.Series;

public class ColumnModelDataFrame
extends AbstractDataFrame<Integer, String, Object>
implements MutableDataFrame<Integer, String, Object> {
    private final String columnName;
    private final ColumnModel tableModel;
    private UniqueIndex<Integer> rowIndex = null;
    private UniqueIndex<String> columnIndex = null;

    public ColumnModelDataFrame(String columnName, ColumnModel tableModel) {
        this.columnName = columnName;
        this.tableModel = tableModel;
    }

    public Class getRowClass(Integer row) {
        return Object.class;
    }

    public Class getColumnClass(String column) {
        return this.tableModel.getMembership();
    }

    public Object getValueAt(Integer row, String column) {
        return this.tableModel.getObject(row.intValue());
    }

    public void setValueAt(Integer row, String column, Object value) {
    }

    public Series<String, ?> getRow(Integer row) {
        return null;
    }

    public Series<Integer, Object> getColumn(String column) {
        return new ColumnSeries(column);
    }

    public Iterable<Integer> rows() {
        return this.getRowIndex().keys();
    }

    public Iterable<String> columns() {
        return this.getColumnIndex().keys();
    }

    public Integer getRowKey(int index) {
        return (Integer)this.getRowIndex().getKey(index);
    }

    public String getColumnKey(int index) {
        return (String)this.getColumnIndex().getKey(index);
    }

    public int getRowAddress(Integer row) {
        return this.getRowIndex().getAddress((Object)row);
    }

    public int getColumnAddress(String column) {
        return this.getColumnIndex().getAddress((Object)column);
    }

    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.getColumnIndex().getSize();
    }

    public MutableDataFrame<MultiKey, String, Object> reindexRowsUsingColumns(String ... rows) {
        return null;
    }

    public DataFrame join(Series series, String[] columns) {
        return null;
    }

    public UniqueIndex<Integer> getRowIndex() {
        if (this.rowIndex == null) {
            this.rowIndex = new IntegerRangeUniqueIndex(0, this.tableModel.getRowCount() - 1);
        }
        return this.rowIndex;
    }

    public UniqueIndex<String> getColumnIndex() {
        if (this.columnIndex == null) {
            Object[] names = new String[]{this.columnName};
            this.columnIndex = new DefaultUniqueIndex(names);
        }
        return this.columnIndex;
    }

    private class ColumnSeries
    extends AbstractSeries<Integer, Object> {
        private final String column;

        private ColumnSeries(String column) {
            assert (column != null);
            this.column = column;
        }

        public Object getName() {
            return this.column;
        }

        public Class getType() {
            return ColumnModelDataFrame.this.getColumnClass(this.column);
        }

        public Object get(Integer key) {
            return ColumnModelDataFrame.this.getValueAt(key, this.column);
        }

        public Integer getKey(int i) {
            return ColumnModelDataFrame.this.getRowKey(i);
        }

        public int size() {
            return ColumnModelDataFrame.this.getRowCount();
        }

        public int getAddress(Integer key) {
            return ColumnModelDataFrame.this.getRowAddress(key);
        }

        public Iterable<Integer> keys() {
            return ColumnModelDataFrame.this.rows();
        }

        public <L> Series<L, Object> reindex(L ... keys) {
            return null;
        }

        public Series<Integer, Object> head(int count) {
            return null;
        }

        public Series<Integer, Object> tail(int count) {
            return null;
        }
    }
}

