/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe.java;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.db.DatabaseDriver;
import com.macrofocus.data.db.MySQLDatabaseDriver;
import com.macrofocus.data.db.OracleDatabaseDriver;
import com.macrofocus.data.db.PostGISDatabaseDriver;
import com.macrofocus.data.db.PostgreSQLDatabaseDriver;
import com.macrofocus.data.db.SQLServerDatabaseDriver;
import com.macrofocus.data.serial.MacrofocusObjectInputStream;
import com.macrofocus.data.source.CommaDelimitedDataSource;
import com.macrofocus.data.source.ExcelDataSource;
import com.macrofocus.data.source.JDBCDataSource;
import com.macrofocus.data.source.JSONDataSource;
import com.macrofocus.data.source.TabDelimitedDataSource;
import com.macrofocus.data.table.TableHelper;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.HeadDataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.java.CPDataFrameFactory;
import com.macrofocus.molap.dataframe.rowmajor.AccessorRowMajorDataFrame;
import com.macrofocus.molap.dataframe.rowmajor.RowMajorDataFrame;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.table.TableModel;

public class JavaDataFrameFactory
extends CPDataFrameFactory {
    private static final JavaDataFrameFactory ourInstance = new JavaDataFrameFactory();

    public static JavaDataFrameFactory getInstance() {
        return ourInstance;
    }

    @Override
    public MutableDataFrame<Integer, String, Object> fromJSON(URL url) throws IOException {
        try {
            return new JSONDataSource(url).loadDataFrame(null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <V> MutableDataFrame<Integer, String, V> fromTableModel(TableModel tableModel) {
        return new DefaultDataFrame(tableModel);
    }

    public static MutableDataFrame<Integer, String, Object> fromSerialize(URL url) throws IOException {
        long start = System.currentTimeMillis();
        TableModel tableModel = TableHelper.read((URL)url, null);
        System.out.println("Loaded " + tableModel.getRowCount() + "x" + tableModel.getColumnCount() + " dataFrame in " + (System.currentTimeMillis() - start) + " ms");
        for (int c = 0; c < tableModel.getColumnCount(); ++c) {
            System.out.println(tableModel.getColumnName(c) + ": " + tableModel.getColumnClass(c));
        }
        return new DefaultDataFrame(tableModel);
    }

    public static MutableDataFrame<Integer, String, Object> fromCSV(URL url) throws IOException {
        return JavaDataFrameFactory.fromCSV(url, "UTF-8");
    }

    public static MutableDataFrame<Integer, String, Object> fromCSV(URL url, String defaultCharset) throws IOException {
        try {
            return new CommaDelimitedDataSource(url, defaultCharset).loadDataFrame(null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MutableDataFrame<Integer, String, Object> fromTSV(URL url, TypemapModel.Builder ... builders) throws IOException {
        try {
            return new TabDelimitedDataSource(url, "UTF-8", builders).loadDataFrame(null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MutableDataFrame<Integer, String, Object> fromExcel(URL url) throws IOException {
        try {
            return new ExcelDataSource(url).loadDataFrame(null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MutableDataFrame<Integer, String, Object> fromExcel(URL url, String sheetName) throws IOException {
        try {
            return new ExcelDataSource(url, sheetName).loadDataFrame(null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DataFrame<Integer, String, Object> fromMySQL(String url, String username, String password, String query) throws IOException, SQLException {
        return new JDBCDataSource((DatabaseDriver)new MySQLDatabaseDriver(), url, username, password, query).loadDataFrame(null);
    }

    public static DataFrame<Integer, String, Object> fromPostgreSQL(String url, String username, String password, String query) throws IOException, SQLException {
        return new JDBCDataSource((DatabaseDriver)new PostgreSQLDatabaseDriver(), url, username, password, query).loadDataFrame(null);
    }

    public static DataFrame<Integer, String, Object> fromPostGIS(String url, String username, String password, String query) throws IOException, SQLException {
        return new JDBCDataSource((DatabaseDriver)new PostGISDatabaseDriver(), url, username, password, query).loadDataFrame(null);
    }

    public static DataFrame<Integer, String, Object> fromOracle(String url, String username, String password, String query) throws IOException, SQLException {
        return new JDBCDataSource((DatabaseDriver)new OracleDatabaseDriver(), url, username, password, query).loadDataFrame(null);
    }

    public static DataFrame<Integer, String, Object> fromSQLServer(String url, String username, String password, String query) throws IOException, SQLException {
        return new JDBCDataSource((DatabaseDriver)new SQLServerDatabaseDriver(), url, username, password, query).loadDataFrame(null);
    }

    public static DefaultDataFrame<Object> fromBinary(File file, Component parentComponent) throws IOException {
        boolean convertUsingTableModel = false;
        FileInputStream fis = new FileInputStream(file);
        ProgressMonitorInputStream monitorInputStream = new ProgressMonitorInputStream(parentComponent, "Reading " + file.getName(), new BufferedInputStream(fis, 65536));
        ProgressMonitor pm = monitorInputStream.getProgressMonitor();
        pm.setMillisToDecideToPopup(500);
        pm.setMillisToPopup(500);
        return JavaDataFrameFactory.fromBinary(monitorInputStream);
    }

    public static DefaultDataFrame<Object> fromBinary(File file) throws IOException {
        boolean convertUsingTableModel = false;
        FileInputStream fis = new FileInputStream(file);
        return JavaDataFrameFactory.fromBinary(fis);
    }

    public static DefaultDataFrame<Object> fromBinary(InputStream is) throws IOException {
        BufferedInputStream buffer = new BufferedInputStream(new GZIPInputStream(is, 65536), 65536);
        try {
            MacrofocusObjectInputStream input = new MacrofocusObjectInputStream(buffer){

                protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                    ObjectStreamClass osc = super.readClassDescriptor();
                    if ("com.macrofocus.data.table.SimpleTableModel".equals(osc.getName())) {
                        return ObjectStreamClass.lookup(DefaultDataFrame.class);
                    }
                    return osc;
                }
            };
            DefaultDataFrame defaultDataFrame = (DefaultDataFrame)input.readObject();
            return defaultDataFrame;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            is.close();
        }
    }

    public static DefaultDataFrame<Object> fromBinary(URL url) throws IOException {
        boolean convertUsingTableModel = false;
        InputStream fis = url.openStream();
        return JavaDataFrameFactory.fromBinary(fis);
    }

    public static DataFrame<ApacheAccessLog, AccessLogColumn, Object> fromAccessLog(File file) throws IOException {
        return JavaDataFrameFactory.fromAccessLog(new FileInputStream(file));
    }

    public static DataFrame<ApacheAccessLog, AccessLogColumn, Object> fromAccessLog(URL url) throws IOException {
        return JavaDataFrameFactory.fromAccessLog(url.openStream());
    }

    public static DataFrame<ApacheAccessLog, AccessLogColumn, Object> fromAccessLog(InputStream is) throws IOException {
        AccessorRowMajorDataFrame dataFrame = new AccessorRowMajorDataFrame((RowMajorDataFrame.Column[])AccessLogColumn.values());
        try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(is));){
            String line = lineNumberReader.readLine();
            while (line != null) {
                ApacheAccessLog entry = ApacheAccessLog.parseFromLogLine(line);
                if (entry != null) {
                    dataFrame.addRow((Object)entry);
                }
                line = lineNumberReader.readLine();
            }
        }
        return dataFrame;
    }

    public static void main(String[] args) {
        try {
            long now;
            String contents = new String(Files.readAllBytes(Paths.get("/Users/luc/macrofocus/dataset/high-d/wrl_ppl_poc_p_unhcr.json", new String[0])));
            JavaDataFrameFactory dataFrameFactory = JavaDataFrameFactory.getInstance();
            URL url = new URL("https://geoservice.unhcr.org/arcgis/rest/services/wrl_services/wrl_ppl_poc_p_unhcr/FeatureServer/0/query?where=&objectIds=&time=&geometry=&geometryType=esriGeometryMultipoint&inSR=&spatialRel=esriSpatialRelIntersects&relationParam=&outFields=pcode%2Ciso3%2Cname%2C+name_alt+%2Cloc_type%2Cloc_subtype%2Ccreatedate%2Ccreateby%2Cclosedate%2Cupdatedate%2Cupdateby%2Csource%2Cunhcr_assist%2Cfootnote%2Ccomments%2Cstatus&returnGeometry=true&maxAllowableOffset=&geometryPrecision=&outSR=&gdbVersion=&returnDistinctValues=false&returnIdsOnly=false&returnCountOnly=false&orderByFields=&groupByFieldsForStatistics=&outStatistics=&returnZ=false&returnM=false&f=pjson");
            System.out.println(URLEncoder.encode(url.toExternalForm(), "UTF-8"));
            MutableDataFrame<Integer, String, Object> dataFrame = dataFrameFactory.fromJSON(url);
            new HeadDataFrame(dataFrame, 10).print();
            long start = System.currentTimeMillis();
            int count = 0;
            do {
                for (Integer row : dataFrame.rows()) {
                    for (String column : dataFrame.columns()) {
                        Object object = dataFrame.getValueAt((Object)row, (Object)column);
                    }
                }
                ++count;
            } while ((now = System.currentTimeMillis()) - start < 10000L);
            System.out.println(count);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ApacheAccessLog
    implements Serializable {
        private String ipAddress;
        private String clientIdentd;
        private String userID;
        private String dateTimeString;
        private String method;
        private String endpoint;
        private String protocol;
        private int responseCode;
        private Long contentSize;
        private String referer;
        private String userAgent;
        private static final String LOG_ENTRY_PATTERN = "^(\\S+) (\\S+)\\s+(\\S+)\\s+\\[([\\w:/]+\\s[+\\-]\\d{4})\\] \"(\\S+) (\\S+) (\\S+)\" (\\d{3}) (\\S+) \"(.+)\" \"(.+)\"";
        private static final Pattern PATTERN = Pattern.compile("^(\\S+) (\\S+)\\s+(\\S+)\\s+\\[([\\w:/]+\\s[+\\-]\\d{4})\\] \"(\\S+) (\\S+) (\\S+)\" (\\d{3}) (\\S+) \"(.+)\" \"(.+)\"");

        private ApacheAccessLog(String ipAddress, String clientIdentd, String userID, String dateTime, String method, String endpoint, String protocol, String responseCode, String contentSize, String referer, String userAgent) {
            this.ipAddress = ipAddress;
            this.clientIdentd = clientIdentd;
            this.userID = userID;
            this.dateTimeString = dateTime;
            this.method = method;
            this.endpoint = endpoint;
            this.protocol = protocol;
            this.responseCode = Integer.parseInt(responseCode);
            this.contentSize = "-".equals(contentSize) ? null : Long.valueOf(Long.parseLong(contentSize));
            this.referer = referer;
            this.userAgent = userAgent;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getClientIdentd() {
            return this.clientIdentd;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getDateTimeString() {
            return this.dateTimeString;
        }

        public String getMethod() {
            return this.method;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public Long getContentSize() {
            return this.contentSize;
        }

        public String getReferer() {
            return this.referer;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public void setClientIdentd(String clientIdentd) {
            this.clientIdentd = clientIdentd;
        }

        public void setUserID(String userID) {
            this.userID = userID;
        }

        public void setDateTimeString(String dateTimeString) {
            this.dateTimeString = dateTimeString;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }

        public void setContentSize(long contentSize) {
            this.contentSize = contentSize;
        }

        public static ApacheAccessLog parseFromLogLine(String logline) {
            Matcher m = PATTERN.matcher(logline);
            if (!m.find()) {
                System.err.println("Error parsing logline " + logline);
                return null;
            }
            String size = m.group(9);
            return new ApacheAccessLog(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5), m.group(6), m.group(7), m.group(8), size, m.group(10), m.group(11));
        }

        public String toString() {
            return String.format("%s %s %s [%s] \"%s %s %s\" %s %s \"%s\" \"%s\"", this.ipAddress, this.clientIdentd, this.userID, this.dateTimeString, this.method, this.endpoint, this.protocol, this.responseCode, this.contentSize, this.referer, this.userAgent);
        }
    }

    public static enum AccessLogColumn implements RowMajorDataFrame.Column<ApacheAccessLog, Object>
    {
        IP_ADDRESS{

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getIpAddress();
            }

            public String toString() {
                return "ipAddress";
            }
        }
        ,
        CLIENT_IDENTD{

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getClientIdentd();
            }

            public String toString() {
                return "clientIdentd";
            }
        }
        ,
        USER_ID{

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getUserID();
            }

            public String toString() {
                return "userID";
            }
        }
        ,
        DATE_TIME_STRING{

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getDateTimeString();
            }

            public String toString() {
                return "DATE_TIME_STRING";
            }
        }
        ,
        DATE{
            SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.US);

            public Class getType() {
                return Date.class;
            }

            public Object getValue(ApacheAccessLog row) {
                try {
                    Date date = this.df.parse(row.getDateTimeString());
                    date.setHours(0);
                    date.setMinutes(0);
                    date.setSeconds(0);
                    return date;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public String toString() {
                return "date";
            }
        }
        ,
        TIME{
            SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.US);
            SimpleDateFormat outputDf = new SimpleDateFormat("HH:mm:ss Z", Locale.US);

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                try {
                    Date date = this.df.parse(row.getDateTimeString());
                    return this.outputDf.format(date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public String toString() {
                return "time";
            }
        }
        ,
        METHOD{

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getMethod();
            }

            public String toString() {
                return "method";
            }
        }
        ,
        ENDPOINT{

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getEndpoint();
            }

            public String toString() {
                return "endpoint";
            }
        }
        ,
        PROTOCOL{

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getProtocol();
            }

            public String toString() {
                return "protocol";
            }
        }
        ,
        RESPONSE_CODE{

            public Class getType() {
                return Integer.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getResponseCode();
            }

            public String toString() {
                return "responseCode";
            }
        }
        ,
        CONTENT_SIZE{

            public Class getType() {
                return Long.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getContentSize();
            }

            public String toString() {
                return "contentSize";
            }
        }
        ,
        REFERER{

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getReferer();
            }

            public String toString() {
                return "referer";
            }
        }
        ,
        USER_AGENT{

            public Class getType() {
                return String.class;
            }

            public Object getValue(ApacheAccessLog row) {
                return row.getUserAgent();
            }

            public String toString() {
                return "userAgent";
            }
        };

    }
}

