/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.java;

import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.java.AbstractDataFrameWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;

public class DelimitedStreamDataFrameWriter
extends AbstractDataFrameWriter {
    private TypemapModel typemapModel = new DefaultTypemapModel();
    private final OutputStreamWriter writer;
    private int columnCount;
    private String delimiter;
    private String newLine;
    private int row = 0;
    private int column = 0;

    public DelimitedStreamDataFrameWriter(OutputStreamWriter writer, int columnCount, String delimiter, String newLine) {
        this.writer = writer;
        this.columnCount = columnCount;
        this.delimiter = delimiter;
        this.newLine = newLine;
    }

    public void writeColumnName(String value, boolean hasMore) throws IOException {
        if (value != null) {
            if (value.contains(this.delimiter) || value.contains("\"") || value.contains("\n") || value.contains(";")) {
                value = "\"" + value.replaceAll("\"", "\"\"") + "\"";
            }
            this.writer.write(value);
        }
        this.nextColumn(hasMore);
    }

    public boolean includeType() {
        return false;
    }

    public void writeType(Class cl, boolean hasMore) throws IOException {
        String value = this.typemapModel.getType(cl);
        if (value != null) {
            if (value.contains(this.delimiter) || value.contains("\"") || value.contains("\n") || value.contains(";")) {
                value = "\"" + value.replaceAll("\"", "\"\"") + "\"";
            }
            this.writer.write(value);
        }
        this.nextColumn(hasMore);
    }

    public void writeCell(Object value, DataFrame dataFrame, Object rowKey, Object columnKey) throws IOException {
        if (value != null) {
            String str;
            if (value instanceof String[]) {
                String[] array = (String[])value;
                str = "";
                for (int i = 0; i < array.length; ++i) {
                    String s = array[i];
                    str = str + s;
                    if (i >= array.length - 1) continue;
                    str = str + ".";
                }
            } else {
                str = value instanceof java.sql.Date ? value.toString() : (value instanceof Date ? this.dateToString(dataFrame, columnKey, (Date)value) : (value instanceof Number ? DelimitedStreamDataFrameWriter.numberToString((Number)value) : value.toString()));
                if (str.contains(this.delimiter) || str.contains("\"") || str.contains("\n") || str.contains(";")) {
                    str = "\"" + str.replaceAll("\"", "\"\"") + "\"";
                }
            }
            this.writer.write(str);
        }
    }

    public void nextColumn(boolean hasMore) throws IOException {
        ++this.column;
        if (hasMore) {
            this.writer.write(this.delimiter);
        }
    }

    public void nextRow() throws IOException {
        this.column = 0;
        ++this.row;
        this.writer.write(this.newLine);
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

