/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.parquet;

import com.macrofocus.molap.dataframe.DataFrame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class DataFrameSchemaConverter {
    private static final boolean ADD_LIST_ELEMENT_RECORDS_DEFAULT = true;

    public DataFrameSchemaConverter() {
    }

    public DataFrameSchemaConverter(Configuration conf) {
    }

    public <R, C, V> MessageType convert(DataFrame<R, C, V> dataFrame) {
        return new MessageType(dataFrame.toString(), this.convertFields(dataFrame));
    }

    private <R, C, V> List<Type> convertFields(DataFrame<R, C, V> dataFrame) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Object field : dataFrame.columns()) {
            types.add(this.convertField(dataFrame, field));
        }
        return types;
    }

    private <R, C, V> Type convertField(String fieldName, DataFrame<R, C, V> dataFrame, C column) {
        return this.convertField(fieldName, dataFrame, column, Type.Repetition.OPTIONAL);
    }

    private <R, C, V> Type convertField(String fieldName, DataFrame<R, C, V> dataFrame, C column, Type.Repetition repetition) {
        Types.PrimitiveBuilder builder;
        Class type = dataFrame.getColumnClass(column);
        if (type.equals(Boolean.class)) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition);
        } else if (type.equals(Integer.class)) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition);
        } else if (type.equals(Long.class)) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition);
        } else if (type.equals(Float.class)) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition);
        } else if (type.equals(Double.class)) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition);
        } else if (type.equals(byte[].class)) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
        } else if (type.equals(String.class)) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        } else if (type.equals(Enum.class)) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType());
        } else if (type.equals(URL.class)) {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        } else {
            throw new UnsupportedOperationException("Cannot convert type " + type);
        }
        return (Type)builder.named(fieldName);
    }

    private <R, C, V> Type convertField(DataFrame<R, C, V> dataFrame, C field) {
        return this.convertField(dataFrame.getColumnName(field), dataFrame, field);
    }

    private boolean isElementType(Type repeatedType, String parentName) {
        return repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1 || repeatedType.asGroupType().getType(0).isRepetition(Type.Repetition.REPEATED) || repeatedType.getName().equals("array") || repeatedType.getName().equals(parentName + "_tuple");
    }
}

