/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.axis;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.AbstractAxisModel;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameHelper;
import com.macrofocus.molap.series.Series;
import com.macrofocus.molap.subset.OrdinalDimension;
import com.macrofocus.molap.subset.SubsetDataFrame;
import java.util.Date;
import java.util.Iterator;

public class DateAxisModel<Row, C>
extends AbstractAxisModel<Row, C> {
    protected final DataFrame<Row, C, ?> dataFrame;
    protected final C column;
    protected final Series[] series;
    protected final OrdinalDimension dimension;
    private final SingleSelection<Row> probing;
    private final Selection<Row> selection;
    private final MutableFilter<Row> filter;
    private MutableBoundedInterval interval;
    private final MutableProperty<Boolean> buttonModel = new SimpleProperty((Object)Boolean.FALSE);
    private double min = Double.MAX_VALUE;
    private double max = -1.7976931348623157E308;
    private double mean;
    private double stdDev;
    private MutableProperty<Integer> binCount = new SimpleProperty((Object)0);
    private MutableProperty<AxisModel.BinType> binType = new SimpleProperty((Object)AxisModel.BinType.Fixed);

    /*
     * WARNING - void declaration
     */
    public DateAxisModel(CPFactory factory, DataFrame<Row, C, ?> dataFrame, DataFrame<?, C, ?> annotationDataFrame, SubsetDataFrame<Row, C, ?> subsetDataFrame, C column, SingleSelection<Row> probing, Selection<Row> selection, MutableFilter<Row> filter) {
        void var1_1;
        void var3_4;
        Iterator iterator;
        this.dataFrame = dataFrame;
        this.column = column;
        this.dimension = subsetDataFrame != null ? subsetDataFrame.getOrdinalDimension(column) : null;
        this.series = new Series[2];
        this.series[0] = dataFrame.getColumn(column);
        Series series = this.series[1] = annotationDataFrame != null ? annotationDataFrame.getColumn(column) : null;
        assert (this.series[0] != null) : "Column " + column + " could not be found";
        assert (annotationDataFrame == null || this.series[1] != null) : "Annotated column " + column + " could not be found";
        this.probing = probing;
        this.selection = selection;
        this.filter = filter;
        boolean dateTime = false;
        for (Object row : dataFrame.rows()) {
            Date date;
            Object value = this.series[0].get(row);
            if (value == null || ((date = value instanceof Date ? (Date)value : (value instanceof Number ? new Date(((Number)value).longValue()) : null)) == null || date.getHours() == 0) && date.getMinutes() == 0 && date.getSeconds() == 0) continue;
            dateTime = true;
            break;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double sum = 0.0;
        int count = 0;
        double uncorrectedSumOfSquares = 0.0;
        for (Object r : iterator.rows()) {
            double d;
            Number value = this.getValue(r);
            if (value == null) continue;
            double v = value.doubleValue();
            if (d < min) {
                min = v;
            }
            if (v > max) {
                max = v;
            }
            sum += v;
            double d2 = v;
            uncorrectedSumOfSquares += d2 * d2;
            ++count;
        }
        this.min = min;
        this.max = max;
        this.mean = sum / (double)count;
        this.stdDev = Math.sqrt(uncorrectedSumOfSquares / (double)count - this.mean * this.mean);
        if (var3_4 != false) {
            this.setFormat(factory.getFormatFactory().createDateTimeFormat());
            return;
        }
        this.setFormat(var1_1.getFormatFactory().createDateFormat());
    }

    /*
     * WARNING - void declaration
     */
    protected MutableBoundedInterval createBoundedInterval() {
        void var1_1;
        SimpleBoundedInterval interval = new SimpleBoundedInterval(this.min, this.max - this.min, this.min, this.max);
        interval.setMinimumExtent(-(this.max - this.min));
        this.registerInterval((BoundedInterval)interval);
        return var1_1;
    }

    @Override
    public MutableProperty<Boolean> getButtonModel() {
        return this.buttonModel;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public String getName() {
        return this.dataFrame.getColumnName(this.column);
    }

    @Override
    public Class getType() {
        return this.dataFrame.getColumnClass(this.column);
    }

    @Override
    public C getColumn() {
        return this.column;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.dataFrame.rows().iterator();
    }

    @Override
    public Number getValue(Row row) {
        Object value = this.series[0].get(row);
        if (value != null) {
            if (value instanceof Date) {
                value = (Date)value;
                return ((Date)value).getTime();
            }
            if (value instanceof Number) {
                Number number;
                number = number;
                return number;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Number getValue(int layer, Row row) {
        void var2_3;
        Object value = this.series[layer].get((Object)var2_3);
        if (value != null) {
            if (value instanceof Date) {
                value = (Date)value;
                return ((Date)value).getTime();
            }
            if (value instanceof Number) {
                Number number;
                number = number;
                return number;
            }
            return null;
        }
        return null;
    }

    @Override
    public String getFormattedMinimum() {
        return this.getFormat().formatHtml((Object)this.getMinimum(), false);
    }

    @Override
    public String getFormattedMaximum() {
        return this.getFormat().formatHtml((Object)this.getMaximum(), false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedValue(Row row) {
        void var1_1;
        return this.getFormattedValue(0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedValue(int layer, Row row) {
        void var2_3;
        Object value = this.series[layer].get((Object)var2_3);
        if (value != null) {
            void var1_2;
            if (value instanceof Date) {
                if (this.getFormat() != null) {
                    return this.getFormat().formatHtml(value, true);
                }
                return value.toString();
            }
            if (value instanceof Number) {
                return this.getFormat().formatHtml((Object)new Date(((Number)value).longValue()), false);
            }
            return var1_2.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedValue(double value) {
        void var1_1;
        if (this.getFormat() != null) {
            return this.getFormat().formatHtml((Object)new Date((long)value), true);
        }
        return this.getFormat().formatHtml((Object)new Date((long)var1_1), false);
    }

    @Override
    public Object getOriginalFloorValue(double value) {
        return value;
    }

    @Override
    public Object getOriginalCeilValue(double value) {
        return value;
    }

    @Override
    public double getMinimum() {
        return this.min;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getStdDev() {
        return this.stdDev;
    }

    @Override
    public double getMaximum() {
        return this.max;
    }

    @Override
    public boolean isDegenerate() {
        return this.max == this.min;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMinimum(double min) {
        if (this.min != min) {
            void var1_1;
            this.min = min;
            this.interval.setMinMax(min, this.max);
            this.interval.setMinimumExtent(-(this.max - var1_1));
            this.fireAxisChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaximum(double max) {
        if (this.max != max) {
            void var1_1;
            this.max = max;
            this.interval.setMinMax(this.min, max);
            this.interval.setMinimumExtent((double)(-(var1_1 - this.min)));
            this.fireAxisChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMinMax(double min, double max) {
        if (this.max != max || this.min != min) {
            void var1_1;
            void var3_2;
            this.min = min;
            this.max = max;
            this.interval.setMinMax(min, max);
            this.interval.setMinimumExtent(max >= min ? 0.0 : max - min);
            this.interval.setMaximumExtent(max >= min ? var3_2 - var1_1 : 0.0);
            this.fireAxisChanged();
        }
    }

    @Override
    public DataFrameHelper.ColumnStatistics getColumnStatistics() {
        return DataFrameHelper.getColumnStatistics(this.dataFrame, this.column);
    }

    @Override
    public int getRowCount() {
        return this.dataFrame.getRowCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Row getRow(int row) {
        void var1_1;
        return (Row)this.dataFrame.getRowKey((int)var1_1);
    }

    @Override
    public MutableBoundedInterval getInterval() {
        if (this.interval == null) {
            this.interval = this.createBoundedInterval();
            DateAxisModel dateAxisModel = this;
            dateAxisModel.addIntervalListener((BoundedInterval)dateAxisModel.interval);
        }
        return this.interval;
    }

    @Override
    public SingleSelection<Row> getProbing() {
        return this.probing;
    }

    @Override
    public Selection<Row> getSelection() {
        return this.selection;
    }

    @Override
    public MutableFilter<Row> getFilter() {
        return this.filter;
    }

    @Override
    public OrdinalDimension getDimension() {
        return this.dimension;
    }

    @Override
    public MutableProperty<Integer> getBinCount() {
        return this.binCount;
    }

    @Override
    public MutableProperty<AxisModel.BinType> getBinType() {
        return this.binType;
    }

    public String toString() {
        return this.getName();
    }
}

