/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.axis.hierarchy;

import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.hierarchy.MutableHierarchy;
import com.macrofocus.hierarchy.SimpleHierarchy;
import com.macrofocus.high_d.axis.AxisFactory;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.ClonedAxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.group.DefaultAxisGroupModel;
import com.macrofocus.high_d.axis.group.FlatAxisGroupModel;
import com.macrofocus.high_d.axis.hierarchy.AbstractAxisHierarchy;
import com.macrofocus.high_d.axis.hierarchy.MutableAxisHierarchy;
import com.macrofocus.molap.dataframe.DataFrame;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultAxisHierarchy<R, C>
extends AbstractAxisHierarchy<R, C>
implements MutableAxisHierarchy<R, C> {
    private final MutableHierarchy<AxisGroupModel<R, C>> groupHierarchy;
    private final Map<AxisModel, AxisGroupModel> axisHierarchy = new HashMap<AxisModel, AxisGroupModel>();
    private final AxisFactory<R, C> axisFactory;
    private final Map<C, AxisModel<R, C>> axisModels;
    private final AxisGroupModel<R, C> flatAxisGroupModel;

    /*
     * WARNING - void declaration
     */
    public DefaultAxisHierarchy(AxisFactory<R, C> axisFactory, Iterable<C> columns) {
        Iterator<C> iterator;
        this.groupHierarchy = new SimpleHierarchy(new DefaultAxisGroupModel("Root", new AxisModel[0]));
        this.flatAxisGroupModel = new FlatAxisGroupModel(this);
        this.axisFactory = iterator;
        this.axisModels = new HashMap<C, AxisModel<R, C>>();
        if (columns != null) {
            for (C column : columns) {
                void var2_2;
                this.getAxisModel(var2_2);
            }
        }
    }

    public DefaultAxisHierarchy(AxisFactory<R, C> axisFactory, CPFactory factory, DataFrame<R, C, ?> dataFrame, boolean numerical, int maxVisible) {
        this(axisFactory, null);
        Iterator iterator;
        AxisGroupModel root = (AxisGroupModel)this.getAxisGroupHierarchy().getRoot();
        int count = 0;
        for (Object column : iterator.columns()) {
            AxisModel axisModel = this.getAxisModel(column);
            if (count < maxVisible && axisModel != null) {
                if (numerical && factory.isNumericType(axisModel.getType()) && !axisModel.getInterval().isDegenerate()) {
                    ++count;
                    continue;
                }
                if (!numerical && factory.isAssignableFrom(String.class, axisModel.getType())) {
                    ++count;
                    continue;
                }
                if (numerical && factory.isAssignableFrom(Date.class, axisModel.getType()) && !axisModel.getInterval().isDegenerate()) {
                    ++count;
                    continue;
                }
                root.getAxisOrder().setVisible((Object)axisModel, false);
                continue;
            }
            root.getAxisOrder().setVisible((Object)axisModel, false);
        }
    }

    public DefaultAxisHierarchy(AxisFactory<R, C> axisFactory, CPFactory factory, DataFrame<R, C, ?> dataFrame, boolean numerical, boolean categorical, int maxVisible) {
        this(axisFactory, null);
        Iterator iterator;
        AxisGroupModel root = (AxisGroupModel)this.getAxisGroupHierarchy().getRoot();
        int count = 0;
        for (Object column : iterator.columns()) {
            AxisModel axisModel = this.getAxisModel(column);
            if (count < maxVisible && axisModel != null) {
                if (numerical && factory.isNumericType(axisModel.getType()) && !axisModel.getInterval().isDegenerate()) {
                    ++count;
                    continue;
                }
                if (categorical && factory.isAssignableFrom(String.class, axisModel.getType())) {
                    ++count;
                    continue;
                }
                if (numerical && factory.isAssignableFrom(Date.class, axisModel.getType()) && !axisModel.getInterval().isDegenerate()) {
                    ++count;
                    continue;
                }
                root.getAxisOrder().setVisible((Object)axisModel, false);
                continue;
            }
            root.getAxisOrder().setVisible((Object)axisModel, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AxisModel<R, C> createClonedAxisModel(C c) {
        void var1_1;
        return new ClonedAxisModel(this.axisFactory.getAxisModel(var1_1));
    }

    @Override
    public AxisFactory<R, C> getAxisFactory() {
        return this.axisFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AxisModel getAxisModel(C c) {
        void var1_1;
        if (!this.axisModels.containsKey(c)) {
            AxisModel axisModel = this.axisFactory.getAxisModel(c);
            if (axisModel != null) {
                void var2_2;
                this.axisModels.put(c, axisModel);
                this.axisHierarchy.put(axisModel, (AxisGroupModel)this.getAxisGroupHierarchy().getRoot());
                ((AxisGroupModel)this.getAxisGroupHierarchy().getRoot()).add(axisModel);
                return var2_2;
            }
            return null;
        }
        return this.axisModels.get(var1_1);
    }

    public AxisGroupModel<R, C> getRoot() {
        return (AxisGroupModel)this.groupHierarchy.getRoot();
    }

    @Override
    public AxisGroupModel<R, C> getFlat() {
        return this.flatAxisGroupModel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(AxisModel axisModel, AxisGroupModel group) {
        void var2_2;
        void var1_1;
        this.axisHierarchy.put((AxisModel)var1_1, (AxisGroupModel)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addToGroup(AxisGroupModel axisGroup, AxisModel content) {
        void var1_1;
        void var2_2;
        axisGroup.add(content);
        this.axisHierarchy.put((AxisModel)var2_2, (AxisGroupModel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void moveToGroup(AxisGroupModel from, AxisGroupModel to, AxisModel content) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.removeFromGroup((AxisGroupModel)var1_1, content);
        this.addToGroup((AxisGroupModel)var2_2, (AxisModel)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeFromGroup(AxisGroupModel axisGroup, AxisModel content) {
        void var2_2;
        axisGroup.remove(content);
        this.axisHierarchy.remove(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AxisGroupModel getAxisGroup(AxisModel axisModel) {
        void var1_1;
        return this.axisHierarchy.get(var1_1);
    }

    @Override
    public Hierarchy<AxisGroupModel<R, C>> getAxisGroupHierarchy() {
        return this.groupHierarchy;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AxisGroupModel createGroup(AxisGroupModel parent, String name, AxisModel ... axisModels) {
        void var2_2;
        DefaultAxisGroupModel defaultAxisGroupModel;
        DefaultAxisHierarchy defaultAxisHierarchy;
        DefaultAxisGroupModel axisGroup = new DefaultAxisGroupModel(name, new AxisModel[0]);
        axisGroup.addAxisListener(new AxisListener(this, axisGroup, parent){
            private /* synthetic */ AxisGroupModel val$axisGroup;
            private /* synthetic */ AxisGroupModel val$parent;
            private /* synthetic */ DefaultAxisHierarchy this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$axisGroup = axisGroupModel;
                this.val$parent = axisGroupModel2;
            }

            @Override
            public final void axisChanged() {
                this.this$0.groupHierarchy.notifyHierarchyNodeChanged((Object)this.val$axisGroup, (Object)this.val$parent, this.this$0.groupHierarchy.getIndexOfChild((Object)this.val$parent, (Object)this.val$parent), false);
            }
        });
        this.groupHierarchy.addChild((Object)defaultAxisHierarchy, axisGroup);
        void var4_4 = defaultAxisGroupModel;
        defaultAxisGroupModel = axisGroup;
        defaultAxisHierarchy = this;
        for (void var7_7 : var4_4) {
            defaultAxisHierarchy.addToGroup((AxisGroupModel)defaultAxisGroupModel, (AxisModel)var7_7);
        }
        return var2_2;
    }
}

