/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.a03;

import a03.swing.plaf.A03ListUI;
import com.jidesoft.list.GroupList;
import com.jidesoft.list.GroupListModel;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.UIAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;

public class A03GroupListUI
extends A03ListUI {
    private int listHeight;
    private int listWidth;
    protected Map<Integer, Rectangle> _headerBounds;
    private int layoutOrientation;
    private int columnCount;
    private boolean isLeftToRight = true;
    private Dimension _preferredSize;
    private List<RowInfo> _rowInfos;
    private List<GroupInfo> _groupInfos;
    private int _columnIndex;
    private boolean _ignoreResetColumnIndex;
    private static final int layoutOrientationChanged = 128;
    private static final int heightChanged = 256;
    private static final int widthChanged = 512;
    private static final int componentOrientationChanged = 1024;
    private static final int CHANGE_LEAD = 0;
    private static final int CHANGE_SELECTION = 1;
    private static final int EXTEND_SELECTION = 2;

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("selectPreviousColumn"));
        lazyActionMap.put(new Actions("selectPreviousColumnExtendSelection"));
        lazyActionMap.put(new Actions("selectPreviousColumnChangeLead"));
        lazyActionMap.put(new Actions("selectNextColumn"));
        lazyActionMap.put(new Actions("selectNextColumnExtendSelection"));
        lazyActionMap.put(new Actions("selectNextColumnChangeLead"));
        lazyActionMap.put(new Actions("selectPreviousRow"));
        lazyActionMap.put(new Actions("selectPreviousRowExtendSelection"));
        lazyActionMap.put(new Actions("selectPreviousRowChangeLead"));
        lazyActionMap.put(new Actions("selectNextRow"));
        lazyActionMap.put(new Actions("selectNextRowExtendSelection"));
        lazyActionMap.put(new Actions("selectNextRowChangeLead"));
        lazyActionMap.put(new Actions("selectPreviousGroup"));
        lazyActionMap.put(new Actions("selectPreviousGroupExtendSelection"));
        lazyActionMap.put(new Actions("selectPreviousGroupChangeLead"));
        lazyActionMap.put(new Actions("selectNextGroup"));
        lazyActionMap.put(new Actions("selectNextGroupExtendSelection"));
        lazyActionMap.put(new Actions("selectNextGroupChangeLead"));
        lazyActionMap.put(new Actions("selectFirstRow"));
        lazyActionMap.put(new Actions("selectFirstRowExtendSelection"));
        lazyActionMap.put(new Actions("selectFirstRowChangeLead"));
        lazyActionMap.put(new Actions("selectLastRow"));
        lazyActionMap.put(new Actions("selectLastRowExtendSelection"));
        lazyActionMap.put(new Actions("selectLastRowChangeLead"));
        lazyActionMap.put(new Actions("scrollUp"));
        lazyActionMap.put(new Actions("scrollUpExtendSelection"));
        lazyActionMap.put(new Actions("scrollUpChangeLead"));
        lazyActionMap.put(new Actions("scrollDown"));
        lazyActionMap.put(new Actions("scrollDownExtendSelection"));
        lazyActionMap.put(new Actions("scrollDownChangeLead"));
        lazyActionMap.put(new Actions("selectAll"));
        lazyActionMap.put(new Actions("clearSelection"));
        lazyActionMap.put(new Actions("addToSelection"));
        lazyActionMap.put(new Actions("toggleAndAnchor"));
        lazyActionMap.put(new Actions("extendTo"));
        lazyActionMap.put(new Actions("moveSelectionTo"));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.listHeight = -1;
        this.listWidth = -1;
        this._rowInfos = null;
        this._groupInfos = null;
    }

    protected void installDefaults() {
        super.installDefaults();
        GroupList groupList = (GroupList)this.list;
        if (groupList.getGroupCellRenderer() == null) {
            ListCellRenderer listCellRenderer = groupList.getCellRenderer();
            if (listCellRenderer == null) {
                groupList.setGroupCellRenderer((ListCellRenderer)UIManager.get("GroupableList.cellRenderer"));
            } else {
                groupList.setGroupCellRenderer((ListCellRenderer)new BasicHeaderRenderer(listCellRenderer));
            }
        }
        this.layoutOrientation = groupList.getLayoutOrientation();
        this.isLeftToRight = groupList.getComponentOrientation().isLeftToRight();
    }

    protected void uninstallDefaults() {
        GroupList groupList = (GroupList)this.list;
        if (groupList.getGroupCellRenderer() instanceof UIResource) {
            groupList.setGroupCellRenderer(null);
        }
        super.uninstallDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        this.list.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
        this.propertyChangeListener = new PropertyChangeHandler();
        this.listSelectionListener = new ListSelectionHandler();
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        this.list.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        switch (this.layoutOrientation) {
            case 1: {
                if (this.list.getHeight() == this.listHeight) break;
                this.updateLayoutStateNeeded |= 0x100;
                this.redrawList();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.listWidth) break;
                this.updateLayoutStateNeeded |= 0x200;
                this.redrawList();
                break;
            }
        }
        this.maybeUpdateLayoutState();
        GroupList groupList = (GroupList)this.list;
        ListCellRenderer listCellRenderer = groupList.getCellRenderer();
        ListCellRenderer listCellRenderer2 = groupList.getGroupCellRenderer();
        GroupListModel groupListModel = groupList.getModel();
        ListSelectionModel listSelectionModel = groupList.getSelectionModel();
        int n = groupList.getLeadSelectionIndex();
        int n2 = groupListModel.getSize();
        for (int i = 0; i < n2; ++i) {
            ListCellRenderer listCellRenderer3;
            Rectangle rectangle = this.getCellBounds((JList)groupList, i);
            ListCellRenderer listCellRenderer4 = listCellRenderer3 = groupListModel.isGroupRow(i) ? listCellRenderer2 : listCellRenderer;
            if (listCellRenderer3 == null) continue;
            this.paintCell(graphics, i, rectangle, listCellRenderer3, (ListModel)groupListModel, listSelectionModel, n);
        }
    }

    protected void originalPaintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object e = listModel.getElementAt(n);
        boolean bl = this.list.hasFocus() && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, e, n, bl2, bl);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        this.rendererPane.paintComponent(graphics, component, this.list, n3, n4, n5, n6, true);
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        if (listModel instanceof GroupListModel && ((GroupListModel)listModel).isGroupRow(n)) {
            this.originalPaintCell(graphics, n, rectangle, listCellRenderer, listModel, listSelectionModel, n2);
        } else {
            super.paintCell(graphics, n, rectangle, listCellRenderer, listModel, listSelectionModel, n2);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.maybeUpdateLayoutState();
        return this._preferredSize;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new A03GroupListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertLocationToModel(point.x, point.y);
    }

    public int locationToRow(JList jList, Point point) {
        return this.convertModelToRow(this.locationToIndex(jList, point));
    }

    public Point indexToLocation(JList jList, int n) {
        this.maybeUpdateLayoutState();
        Rectangle rectangle = this.getCellBounds(jList, n);
        if (rectangle != null) {
            return new Point(rectangle.x, rectangle.y);
        }
        return null;
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        int n3 = Math.min(jList.getModel().getSize() - 1, Math.min(n, n2));
        int n4 = Math.min(jList.getModel().getSize() - 1, Math.max(n, n2));
        if (n3 >= jList.getModel().getSize()) {
            return null;
        }
        Rectangle rectangle = this.getCellBounds(jList, n3);
        if (rectangle == null) {
            return null;
        }
        if (n3 == n4) {
            return rectangle;
        }
        Rectangle rectangle2 = this.getCellBounds(jList, n4);
        if (rectangle2 != null) {
            if (this.layoutOrientation == 2 || this.layoutOrientation == 3) {
                int n5;
                int n6 = this.convertModelToRow(n3);
                if (n6 != (n5 = this.convertModelToRow(n4))) {
                    rectangle.x = 0;
                    rectangle.width = jList.getWidth();
                }
            } else if (this.layoutOrientation == 1) {
                rectangle.setBounds(0, 0, jList.getWidth(), jList.getHeight());
            } else if (rectangle.x != rectangle2.x) {
                rectangle.y = 0;
                rectangle.height = jList.getHeight();
            }
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    public Rectangle getCellBounds(JList jList, int n) {
        this.maybeUpdateLayoutState();
        Rectangle rectangle = new Rectangle();
        if (n == -1) {
            return new Rectangle();
        }
        Insets insets = jList.getInsets();
        GroupListModel groupListModel = ((GroupList)jList).getModel();
        if (groupListModel.isGroupRow(n)) {
            rectangle.setBounds(this._headerBounds.get(n));
            rectangle.x = insets.left;
            rectangle.width = jList.getWidth() - insets.left - insets.right;
            return rectangle;
        }
        int n2 = groupListModel.getGroupRowIndex(n);
        assert (n2 == -1 || groupListModel.isGroupRow(n2));
        Rectangle rectangle2 = this._headerBounds.get(n2);
        if (rectangle2 == null) {
            assert (n2 == -1);
            rectangle2 = new Rectangle();
        }
        rectangle.y = rectangle2.y + rectangle2.height;
        ++n2;
        switch (this.layoutOrientation) {
            case 0: {
                for (int i = n2; i < n; ++i) {
                    rectangle.y = rectangle.y + (this.cellHeights != null ? this.cellHeights[i] : this.cellHeight);
                }
                rectangle.y += insets.top;
                rectangle.x = insets.left;
                rectangle.width = jList.getWidth() - insets.left - insets.right;
                rectangle.height = this.cellHeights != null ? this.cellHeights[n] : this.cellHeight;
                break;
            }
            case 1: 
            case 2: {
                int n3;
                int n4 = n - n2;
                int n5 = 0;
                if (this.layoutOrientation == 1) {
                    n3 = groupListModel.getNextGroupRowIndex(n) - n2;
                    n5 = (n3 + this.columnCount - 1) / this.columnCount;
                }
                n3 = this.layoutOrientation == 1 ? n4 / n5 : n4 % this.columnCount;
                int n6 = this.layoutOrientation == 1 ? n4 % n5 : n4 / this.columnCount;
                rectangle.x = this.isLeftToRight ? insets.left : jList.getWidth() - insets.right - this.cellWidth;
                rectangle.y += insets.top;
                rectangle.x = this.isLeftToRight ? (rectangle.x += n3 * this.cellWidth) : (rectangle.x -= n3 * this.cellWidth);
                rectangle.y += n6 * this.cellHeight;
                rectangle.width = this.cellWidth;
                rectangle.height = this.cellHeight;
                break;
            }
            case 3: {
                int n7 = n - n2;
                rectangle.x = this.isLeftToRight ? insets.left : jList.getWidth() - insets.right - this.cellWidth;
                rectangle.y += insets.top;
                rectangle.x = this.isLeftToRight ? (rectangle.x += n7 * this.cellWidth) : (rectangle.x -= n7 * this.cellWidth);
                rectangle.width = this.cellWidth;
                rectangle.height = this.cellHeight;
            }
        }
        return rectangle;
    }

    private int convertLocationToRow(int n, int n2, boolean bl) {
        Insets insets = this.list.getInsets();
        for (int i = this._rowInfos.size() - 1; i >= 0; --i) {
            int n3;
            RowInfo rowInfo = this._rowInfos.get(i);
            int n4 = rowInfo.point.y + insets.top;
            int n5 = n3 = this.cellHeights != null ? this.cellHeights[rowInfo.index] : this.cellHeight;
            if (n2 < n4) continue;
            if (bl || n2 < n4 + n3) {
                return i;
            }
            return -1;
        }
        return bl ? 0 : -1;
    }

    private int convertLocationToColumnInRow(int n, int n2) {
        Insets insets = this.list.getInsets();
        if (n2 >= 0 && n2 < this._rowInfos.size()) {
            RowInfo rowInfo = this._rowInfos.get(n2);
            for (int i = rowInfo.size - 1; i >= 0; --i) {
                if (!(this.isLeftToRight ? n >= insets.left + i * this.cellWidth : n <= this.list.getWidth() - insets.right - i * this.cellWidth)) continue;
                return i;
            }
            return 0;
        }
        return -1;
    }

    private int convertLocationToModel(int n, int n2) {
        int n3 = this.convertLocationToRow(n, n2, true);
        int n4 = this.convertLocationToColumnInRow(n, n3);
        if (n3 >= 0 && n4 >= 0) {
            return this.getModelIndex(n4, n3);
        }
        return -1;
    }

    public int getRowCount() {
        if (this.layoutOrientation == 0) {
            return this.list.getModel().getSize();
        }
        return this._rowInfos != null ? this._rowInfos.size() : 0;
    }

    public int getColumnCount(int n) {
        if (this.layoutOrientation == 0) {
            return 1;
        }
        return this._rowInfos != null ? this._rowInfos.get((int)n).size : 0;
    }

    private int getModelIndex(int n, int n2) {
        switch (this.layoutOrientation) {
            case 1: {
                RowInfo rowInfo = this._rowInfos.get(n2);
                int n3 = rowInfo.index;
                GroupListModel groupListModel = (GroupListModel)this.list.getModel();
                if (groupListModel.isGroupRow(n3)) {
                    assert (n == 0);
                    return n3;
                }
                int n4 = groupListModel.getGroupRowIndex(n3);
                int n5 = groupListModel.getNextGroupRowIndex(n3) - n4;
                int n6 = n5 - 1;
                int n7 = (n6 + this.columnCount - 1) / this.columnCount;
                return n3 + n7 * n;
            }
            case 2: 
            case 3: {
                RowInfo rowInfo = this._rowInfos.get(n2);
                return rowInfo.index + Math.min(n, rowInfo.size - 1);
            }
        }
        return n2;
    }

    private int convertModelToRow(int n) {
        GroupListModel groupListModel = (GroupListModel)this.list.getModel();
        int n2 = groupListModel.getSize();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.layoutOrientation == 2 || this.layoutOrientation == 3) {
            for (int i = this._rowInfos.size() - 1; i >= 0; --i) {
                if (this._rowInfos.get((int)i).index > n) continue;
                return i;
            }
        } else if (this.layoutOrientation == 1) {
            int n3;
            int n4 = groupListModel.getGroupRowIndex(n);
            int n5 = -1;
            for (n3 = 0; n3 < this._rowInfos.size(); ++n3) {
                RowInfo rowInfo = this._rowInfos.get(n3);
                if (rowInfo.index != n4) continue;
                assert (rowInfo.size == 1);
                n5 = n3;
                break;
            }
            assert (n5 != -1);
            n3 = n - (n4 + 1);
            int n6 = groupListModel.getNextGroupRowIndex(n) - (n4 + 1);
            int n7 = (n6 + this.columnCount - 1) / this.columnCount;
            return n5 + 1 + n3 % n7;
        }
        return n;
    }

    private int convertModelToColumn(int n) {
        GroupListModel groupListModel = (GroupListModel)this.list.getModel();
        int n2 = groupListModel.getSize();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.layoutOrientation == 2 || this.layoutOrientation == 3) {
            for (int i = this._rowInfos.size() - 1; i >= 0; --i) {
                int n3 = this._rowInfos.get((int)i).index;
                if (n3 > n) continue;
                return n - n3;
            }
        } else if (this.layoutOrientation == 1) {
            int n4 = groupListModel.getGroupRowIndex(n);
            int n5 = n - (n4 + 1);
            int n6 = groupListModel.getNextGroupRowIndex(n) - (n4 + 1);
            int n7 = (n6 + this.columnCount - 1) / this.columnCount;
            return n5 / n7;
        }
        return 0;
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void updateLayoutState() {
        int n = this.list.getFixedCellHeight();
        int n2 = this.list.getFixedCellWidth();
        int n3 = this.cellWidth = n2 != -1 ? n2 : -1;
        if (n != -1) {
            this.cellHeight = n;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            this.cellHeights = new int[this.list.getModel().getSize()];
        }
        if (n2 == -1 || n == -1) {
            GroupListModel groupListModel = (GroupListModel)this.list.getModel();
            int n4 = groupListModel.getSize();
            ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
            ListCellRenderer listCellRenderer2 = ((GroupList)this.list).getGroupCellRenderer();
            for (int i = 0; i < n4; ++i) {
                Object object = groupListModel.getElementAt(i);
                Component component = new JPanel();
                if (!groupListModel.isGroupRow(i)) {
                    component = listCellRenderer.getListCellRendererComponent(this.list, object, i, false, false);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n == -1) {
                        this.cellHeights[i] = dimension.height;
                    }
                } else {
                    component = listCellRenderer2.getListCellRendererComponent(this.list, object, i, false, false);
                }
                this.rendererPane.add(component);
            }
        }
        this.updateCellLayoutState(n2, n);
        this.updateGroupLayoutState(n2, n);
        this._columnIndex = this.convertModelToColumn(this.list.getSelectedIndex());
    }

    protected void updateGroupLayoutState(int n, int n2) {
        Object object;
        this.reset();
        ListCellRenderer listCellRenderer = ((GroupList)this.list).getGroupCellRenderer();
        int n3 = 0;
        int n4 = 0;
        GroupListModel groupListModel = ((GroupList)this.list).getModel();
        int n5 = groupListModel.getSize();
        while (n4 < n5) {
            Object object2;
            if (groupListModel.isGroupRow(n4)) {
                object = new RowInfo(n4);
                ((RowInfo)object).point = new Point(0, n3);
                this._rowInfos.add((RowInfo)object);
                this._groupInfos.add((GroupInfo)object);
                object2 = listCellRenderer.getListCellRendererComponent(this.list, groupListModel.getElementAt(n4), n4, false, false);
                Dimension dimension = ((Component)object2).getPreferredSize();
                Rectangle rectangle = new Rectangle(0, n3, dimension.width, dimension.height);
                this._headerBounds.put(n4, rectangle);
                n3 += dimension.height;
                this._preferredSize.width = Math.max(this._preferredSize.width, dimension.width);
                this._preferredSize.height += dimension.height;
            }
            ++n4;
            switch (this.layoutOrientation) {
                case 0: {
                    int n6 = 0;
                    while (n4 < n5 && !groupListModel.isGroupRow(n4)) {
                        object2 = new RowInfo(n4);
                        ((RowInfo)object2).point = new Point(0, n3 + n6);
                        this._rowInfos.add((RowInfo)object2);
                        n6 += this.cellHeights != null ? this.cellHeights[n4] : this.cellHeight;
                        ++n4;
                    }
                    n3 += n6;
                    this._preferredSize.height += n6;
                    break;
                }
                case 1: 
                case 2: {
                    int n7;
                    int n8;
                    int n9 = 0;
                    int n10 = n4;
                    while (n4 < n5 && !groupListModel.isGroupRow(n4)) {
                        ++n4;
                    }
                    int n11 = n4 - n10;
                    int n12 = (n11 + this.columnCount - 1) / this.columnCount;
                    if (this.layoutOrientation == 2) {
                        RowInfo rowInfo;
                        n8 = 0;
                        n7 = n10;
                        while (n7 + this.columnCount < n4) {
                            rowInfo = new RowInfo(n7, this.columnCount);
                            rowInfo.point = new Point(0, n3 + n8 * this.cellHeight);
                            this._rowInfos.add(rowInfo);
                            n7 += this.columnCount;
                            ++n8;
                        }
                        rowInfo = new RowInfo(n7, n4 - n7);
                        assert (n8 == n12 - 1);
                        rowInfo.point = new Point(0, n3 + n8 * this.cellHeight);
                        this._rowInfos.add(rowInfo);
                    } else {
                        assert (this.layoutOrientation == 1);
                        n7 = n11 % n12;
                        n8 = (n11 + n12 - 1) / n12;
                        for (int i = 0; i < n12; ++i) {
                            int n13 = n7 == 0 || i < n7 ? n8 : n8 - 1;
                            RowInfo rowInfo = new RowInfo(n10 + i, n13);
                            rowInfo.point = new Point(0, n3 + i * this.cellHeight);
                            this._rowInfos.add(rowInfo);
                        }
                    }
                    n3 += (n9 += n12 * this.cellHeight);
                    this._preferredSize.height += n9;
                    this._preferredSize.width = Math.max(this._preferredSize.width, this.columnCount * this.cellWidth);
                    break;
                }
                case 3: {
                    int n14 = 0;
                    int n15 = n4;
                    while (n4 < n5 && !groupListModel.isGroupRow(n4)) {
                        ++n4;
                    }
                    int n16 = n4 - n15;
                    int n17 = 1;
                    RowInfo rowInfo = new RowInfo(n15, n16);
                    rowInfo.point = new Point(0, n3);
                    this._rowInfos.add(rowInfo);
                    n14 = n17 * this.cellHeight;
                    n3 += n14;
                    this._preferredSize.height += n14;
                    this._preferredSize.width = Math.max(this._preferredSize.width, n16 * this.cellWidth);
                }
            }
        }
        object = this.list.getInsets();
        this._preferredSize.width += ((Insets)object).left + ((Insets)object).right;
        this._preferredSize.height += ((Insets)object).top + ((Insets)object).bottom;
    }

    protected void updateCellLayoutState(int n, int n2) {
        GroupListModel groupListModel = (GroupListModel)this.list.getModel();
        int n3 = groupListModel.getSize();
        this.listHeight = this.list.getHeight();
        this.listWidth = this.list.getWidth();
        if (n3 == 0) {
            this.columnCount = 0;
            return;
        }
        if (this.layoutOrientation != 0) {
            if (n2 > 0) {
                this.cellHeight = n2;
            } else {
                this.cellHeight = 0;
                for (int i = 0; i < this.cellHeights.length; ++i) {
                    this.cellHeight = Math.max(this.cellHeight, this.cellHeights[i]);
                }
                this.cellHeights = null;
            }
        }
        switch (this.layoutOrientation) {
            case 0: {
                this.columnCount = 1;
                break;
            }
            case 1: 
            case 2: {
                this.columnCount = ((GroupList)this.list).getPreferredColumnCount();
                break;
            }
            case 3: {
                this.columnCount = Integer.MAX_VALUE;
            }
        }
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    private void reset() {
        if (this._preferredSize == null) {
            this._preferredSize = new Dimension();
        } else {
            this._preferredSize.setSize(0, 0);
        }
        if (this._headerBounds == null) {
            this._headerBounds = new LinkedHashMap<Integer, Rectangle>();
        } else {
            this._headerBounds.clear();
        }
        if (this._rowInfos == null) {
            this._rowInfos = new ArrayList<RowInfo>();
        } else {
            this._rowInfos.clear();
        }
        if (this._groupInfos == null) {
            this._groupInfos = new ArrayList<GroupInfo>();
        } else {
            this._groupInfos.clear();
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.list, 0, inputMap);
        InputMap inputMap2 = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.list, 1, inputMap2);
        LazyActionMap.installLazyActionMap(this.list, A03GroupListUI.class, "GroupList.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("GroupList.ancestorInputMap");
            if (inputMap2 == null) {
                inputMap2 = new InputMap();
            }
            inputMap2.setParent((InputMap)UIManager.get("List.focusInputMap"));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                return inputMap2;
            }
            InputMap inputMap3 = (InputMap)UIManager.get("GroupList.ancestorInputMap.RightToLeft");
            if (inputMap3 == null) {
                inputMap3 = new InputMap();
            }
            if ((inputMap = (InputMap)UIManager.get("List.focusInputMap.RightToLeft")) == null) {
                inputMap = new InputMap();
            }
            inputMap3.setParent(inputMap);
            inputMap.setParent(inputMap2);
            return inputMap3;
        }
        if (n == 0) {
            InputMap inputMap;
            InputMap inputMap4 = (InputMap)UIManager.get("List.focusInputMap");
            if (this.isLeftToRight || (inputMap = (InputMap)UIManager.get("List.focusInputMap.RightToLeft")) == null) {
                return inputMap4;
            }
            inputMap.setParent(inputMap4);
            return inputMap;
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.list, null);
        SwingUtilities.replaceUIInputMap(this.list, 0, null);
        SwingUtilities.replaceUIInputMap(this.list, 1, null);
    }

    static {
        UIManager.put("GroupableList.headerRenderer", new BasicHeaderRenderer());
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT_PREVIOUS_COLUMN = "selectPreviousColumn";
        private static final String SELECT_PREVIOUS_COLUMN_EXTEND = "selectPreviousColumnExtendSelection";
        private static final String SELECT_PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        private static final String SELECT_NEXT_COLUMN = "selectNextColumn";
        private static final String SELECT_NEXT_COLUMN_EXTEND = "selectNextColumnExtendSelection";
        private static final String SELECT_NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        private static final String SELECT_PREVIOUS_ROW = "selectPreviousRow";
        private static final String SELECT_PREVIOUS_ROW_EXTEND = "selectPreviousRowExtendSelection";
        private static final String SELECT_PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        private static final String SELECT_NEXT_ROW = "selectNextRow";
        private static final String SELECT_NEXT_ROW_EXTEND = "selectNextRowExtendSelection";
        private static final String SELECT_NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        private static final String SELECT_FIRST_ROW = "selectFirstRow";
        private static final String SELECT_FIRST_ROW_EXTEND = "selectFirstRowExtendSelection";
        private static final String SELECT_FIRST_ROW_CHANGE_LEAD = "selectFirstRowChangeLead";
        private static final String SELECT_LAST_ROW = "selectLastRow";
        private static final String SELECT_LAST_ROW_EXTEND = "selectLastRowExtendSelection";
        private static final String SELECT_LAST_ROW_CHANGE_LEAD = "selectLastRowChangeLead";
        private static final String SELECT_PREVIOUS_GROUP = "selectPreviousGroup";
        private static final String SELECT_PREVIOUS_GROUP_EXTEND = "selectPreviousGroupExtendSelection";
        private static final String SELECT_PREVIOUS_GROUP_CHANGE_LEAD = "selectPreviousGroupChangeLead";
        private static final String SELECT_NEXT_GROUP = "selectNextGroup";
        private static final String SELECT_NEXT_GROUP_EXTEND = "selectNextGroupExtendSelection";
        private static final String SELECT_NEXT_GROUP_CHANGE_LEAD = "selectNextGroupChangeLead";
        private static final String SCROLL_UP = "scrollUp";
        private static final String SCROLL_UP_EXTEND = "scrollUpExtendSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_DOWN = "scrollDown";
        private static final String SCROLL_DOWN_EXTEND = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            GroupList groupList = (GroupList)actionEvent.getSource();
            A03GroupListUI a03GroupListUI = (A03GroupListUI)((Object)groupList.getUI());
            if (string == SELECT_PREVIOUS_COLUMN) {
                this.changeSelection((JList)groupList, 1, this.getNextColumnIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_PREVIOUS_COLUMN_EXTEND) {
                this.changeSelection((JList)groupList, 2, this.getNextColumnIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_PREVIOUS_COLUMN_CHANGE_LEAD) {
                this.changeSelection((JList)groupList, 0, this.getNextColumnIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_NEXT_COLUMN) {
                this.changeSelection((JList)groupList, 1, this.getNextColumnIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_NEXT_COLUMN_EXTEND) {
                this.changeSelection((JList)groupList, 2, this.getNextColumnIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_NEXT_COLUMN_CHANGE_LEAD) {
                this.changeSelection((JList)groupList, 0, this.getNextColumnIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_PREVIOUS_ROW) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 1, this.getNextIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_PREVIOUS_ROW_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 2, this.getNextIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_PREVIOUS_ROW_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 0, this.getNextIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_NEXT_ROW) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 1, this.getNextIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_NEXT_ROW_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 2, this.getNextIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_NEXT_ROW_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 0, this.getNextIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_FIRST_ROW) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 1, 0, true);
            } else if (string == SELECT_FIRST_ROW_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 2, 0, true);
            } else if (string == SELECT_FIRST_ROW_CHANGE_LEAD) {
                this.changeSelection((JList)groupList, 0, 0, true);
            } else if (string == SELECT_LAST_ROW) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 1, groupList.getModel().getSize() - 1, true);
            } else if (string == SELECT_LAST_ROW_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 2, groupList.getModel().getSize() - 1, true);
            } else if (string == SELECT_LAST_ROW_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection((JList)groupList, 0, groupList.getModel().getSize() - 1, true);
            } else if (string == SELECT_PREVIOUS_GROUP) {
                this.changeSelection((JList)groupList, 1, this.getNextGroupIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_NEXT_GROUP) {
                this.changeSelection((JList)groupList, 1, this.getNextGroupIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SCROLL_UP) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 1, true);
            } else if (string == SCROLL_UP_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 2, true);
            } else if (string == SCROLL_UP_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 0, true);
            } else if (string == SCROLL_DOWN) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 1, false);
            } else if (string == SCROLL_DOWN_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 2, false);
            } else if (string == SCROLL_DOWN_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 0, false);
            } else if (string == SELECT_ALL) {
                this.selectAll((JList)groupList);
            } else if (string == CLEAR_SELECTION) {
                this.clearSelection((JList)groupList);
            } else if (string == ADD_TO_SELECTION) {
                int n = groupList.getSelectionModel().getLeadSelectionIndex();
                if (!groupList.isSelectedIndex(n)) {
                    int n2 = groupList.getSelectionModel().getAnchorSelectionIndex();
                    groupList.setValueIsAdjusting(true);
                    groupList.addSelectionInterval(n, n);
                    groupList.getSelectionModel().setAnchorSelectionIndex(n2);
                    groupList.setValueIsAdjusting(false);
                }
            } else if (string == TOGGLE_AND_ANCHOR) {
                int n = groupList.getSelectionModel().getLeadSelectionIndex();
                if (groupList.isSelectedIndex(n)) {
                    groupList.removeSelectionInterval(n, n);
                } else {
                    groupList.addSelectionInterval(n, n);
                }
            } else if (string == EXTEND_TO) {
                this.changeSelection((JList)groupList, 2, groupList.getSelectionModel().getLeadSelectionIndex(), false);
            } else if (string == MOVE_SELECTION_TO) {
                this.changeSelection((JList)groupList, 1, groupList.getSelectionModel().getLeadSelectionIndex(), false);
            }
            a03GroupListUI._ignoreResetColumnIndex = false;
        }

        public boolean isEnabled(Object object) {
            String string = this.getName();
            if (string == SELECT_PREVIOUS_COLUMN_CHANGE_LEAD || string == SELECT_NEXT_COLUMN_CHANGE_LEAD || string == SELECT_PREVIOUS_ROW_CHANGE_LEAD || string == SELECT_NEXT_ROW_CHANGE_LEAD || string == SELECT_FIRST_ROW_CHANGE_LEAD || string == SELECT_LAST_ROW_CHANGE_LEAD || string == SCROLL_UP_CHANGE_LEAD || string == SCROLL_DOWN_CHANGE_LEAD) {
                return object != null && ((JList)object).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            return true;
        }

        private void clearSelection(JList jList) {
            jList.clearSelection();
        }

        private void selectAll(JList jList) {
            int n = jList.getModel().getSize();
            if (n > 0) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (listSelectionModel.getSelectionMode() == 0) {
                    int n2 = jList.getLeadSelectionIndex();
                    if (n2 != -1) {
                        jList.setSelectionInterval(n2, n2);
                    } else if (jList.getMinSelectionIndex() == -1) {
                        jList.setSelectionInterval(0, 0);
                        jList.ensureIndexIsVisible(0);
                    }
                } else {
                    jList.setValueIsAdjusting(true);
                    int n3 = listSelectionModel.getAnchorSelectionIndex();
                    int n4 = listSelectionModel.getLeadSelectionIndex();
                    jList.setSelectionInterval(0, n - 1);
                    jList.addSelectionInterval(n3, n4);
                    jList.setValueIsAdjusting(false);
                }
            }
        }

        private void scroll(GroupList groupList, int n, boolean bl) {
            int n2 = this.getNextPageIndex(groupList, bl);
            if (n2 != -1) {
                this.changeSelection((JList)groupList, n, n2, true);
            }
        }

        private int getValidPageIndex(GroupList groupList, int n, int n2) {
            A03GroupListUI a03GroupListUI = (A03GroupListUI)((Object)groupList.getUI());
            GroupListModel groupListModel = groupList.getModel();
            int n3 = n2 - n > 0 ? 1 : -1;
            int n4 = a03GroupListUI.convertModelToRow(n);
            int n5 = a03GroupListUI.convertModelToRow(n2);
            int n6 = n2;
            switch (groupList.getLayoutOrientation()) {
                default: 
            }
            int n7 = a03GroupListUI.convertModelToRow(n6);
            if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n6)) {
                n7 -= n3;
            }
            if (0 <= n7 && n7 < a03GroupListUI._rowInfos.size()) {
                RowInfo rowInfo = (RowInfo)a03GroupListUI._rowInfos.get(n7);
                n6 = a03GroupListUI.getModelIndex(Math.min(rowInfo.size - 1, a03GroupListUI._columnIndex), n7);
                if (n4 <= n7 && n7 <= n5 || n5 <= n7 && n7 <= n4) {
                    return n6;
                }
            }
            n6 = n2;
            n7 = groupListModel.getSize();
            switch (groupList.getLayoutOrientation()) {
                default: 
            }
            int n8 = a03GroupListUI.convertModelToRow(n6);
            if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n6)) {
                n8 += n3;
            }
            if (0 <= n8 && n8 < a03GroupListUI._rowInfos.size()) {
                RowInfo rowInfo = (RowInfo)a03GroupListUI._rowInfos.get(n4);
                n6 = a03GroupListUI.getModelIndex(Math.min(rowInfo.size - 1, a03GroupListUI._columnIndex), n4);
                if (0 <= n8 && n8 <= n5 || n5 <= n8 && n8 < a03GroupListUI._rowInfos.size()) {
                    return n6;
                }
            }
            return n2;
        }

        private int getNextPageIndex(GroupList groupList, boolean bl) {
            A03GroupListUI a03GroupListUI = (A03GroupListUI)((Object)groupList.getUI());
            if (bl) {
                int n = groupList.getFirstVisibleIndex();
                int n2 = a03GroupListUI.convertModelToRow(n);
                ListSelectionModel listSelectionModel = groupList.getSelectionModel();
                int n3 = listSelectionModel.getLeadSelectionIndex();
                int n4 = a03GroupListUI.convertModelToRow(n3);
                if (n4 == n2) {
                    Rectangle rectangle = groupList.getVisibleRect();
                    rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                    int n5 = groupList.locationToIndex(rectangle.getLocation());
                    n = this.getValidPageIndex(groupList, n, n5);
                } else {
                    n = this.getValidPageIndex(groupList, n3, n);
                }
                return n;
            }
            int n = groupList.getLastVisibleIndex();
            ListSelectionModel listSelectionModel = groupList.getSelectionModel();
            if (n == -1) {
                n = groupList.getModel().getSize() - 1;
            }
            int n6 = a03GroupListUI.convertModelToRow(n);
            int n7 = listSelectionModel.getLeadSelectionIndex();
            int n8 = a03GroupListUI.convertModelToRow(n7);
            if (n8 == n6) {
                Rectangle rectangle = groupList.getVisibleRect();
                rectangle.y += rectangle.height + rectangle.height - 1;
                int n9 = groupList.locationToIndex(rectangle.getLocation());
                if (n9 == -1) {
                    n9 = groupList.getModel().getSize() - 1;
                }
                n = this.getValidPageIndex(groupList, n, n9);
            } else {
                n = this.getValidPageIndex(groupList, n7, n);
            }
            return n;
        }

        private void changeSelection(JList jList, int n, int n2, boolean bl) {
            if (n2 >= 0 && n2 < jList.getModel().getSize()) {
                int n3;
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (n == 0 && jList.getSelectionMode() != 2) {
                    n = 1;
                }
                if (n == 2) {
                    int n4 = jList.getSelectedIndex();
                    int n5 = listSelectionModel.getAnchorSelectionIndex();
                    if (n5 == -1) {
                        n5 = n2;
                    }
                    jList.setSelectionInterval(n5, n2);
                    n3 = this.getVisibleRect(jList, n4, n2);
                } else if (n == 1) {
                    int n6 = jList.getSelectedIndex();
                    jList.setSelectedIndex(n2);
                    n3 = this.getVisibleRect(jList, n6, n2);
                } else {
                    int n7 = jList.getSelectedIndex();
                    ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(n2);
                    n3 = this.getVisibleRect(jList, n7, n2);
                }
                if (bl) {
                    jList.ensureIndexIsVisible(n3);
                }
            }
        }

        private int getNextColumnIndex(GroupList groupList, A03GroupListUI a03GroupListUI, int n) {
            int n2;
            int n3 = groupList.getLeadSelectionIndex();
            GroupListModel groupListModel = groupList.getModel();
            int n4 = groupListModel.getSize();
            int n5 = a03GroupListUI._rowInfos.size();
            int n6 = n2 = n > 0 ? 1 : -1;
            if (a03GroupListUI == null || n4 == 0) {
                return -1;
            }
            if (n4 == 1) {
                return 0;
            }
            if (n3 == -1) {
                return 0;
            }
            int n7 = a03GroupListUI.convertModelToColumn(n3);
            int n8 = a03GroupListUI.convertModelToRow(n3);
            RowInfo rowInfo = (RowInfo)a03GroupListUI._rowInfos.get(n8);
            int n9 = -2;
            while (n != 0) {
                RowInfo rowInfo2 = rowInfo;
                int n10 = n7 + n;
                if (0 <= n10 && n10 < rowInfo2.size) {
                    n7 = n10;
                    n3 = a03GroupListUI.getModelIndex(n7, n8);
                    break;
                }
                if (0 > (n8 += n2) || n8 >= n5) break;
                rowInfo = (RowInfo)a03GroupListUI._rowInfos.get(n8);
                int n11 = n7;
                n7 = n2 > 0 ? 0 : rowInfo.size - 1;
                n9 = a03GroupListUI.getModelIndex(n7, n8);
                if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n9)) continue;
                assert (n9 != -2);
                n3 = n9;
                if (n2 > 0) {
                    n -= rowInfo2.size - n11;
                    continue;
                }
                n += n11 + 1;
            }
            return n3;
        }

        private int getNextIndex(GroupList groupList, A03GroupListUI a03GroupListUI, int n) {
            int n2;
            block3: {
                int n3;
                int n4;
                GroupListModel groupListModel;
                block5: {
                    int n5;
                    block4: {
                        groupListModel = groupList.getModel();
                        n4 = groupListModel.getSize();
                        n3 = n > 0 ? 1 : -1;
                        n5 = groupList.getLayoutOrientation();
                        if (n2 != -1) break block4;
                        if (n4 <= 0 || groupList.isGroupCellSelectable()) break block3;
                        for (n2 = groupList.getLeadSelectionIndex(); 0 <= n2 && n2 < n4 && groupListModel.isGroupRow(n2); n2 += n3) {
                        }
                        if (n2 < n4) break block3;
                        n2 = -1;
                        break block3;
                    }
                    if (n5 != 2 && n5 != 3) break block5;
                    if (a03GroupListUI == null) break block3;
                    int n6 = a03GroupListUI.convertModelToRow(n2);
                    int n7 = a03GroupListUI._rowInfos.size();
                    while (0 <= (n6 += n3) && n6 < n7) {
                        int n8 = ((RowInfo)((A03GroupListUI)a03GroupListUI)._rowInfos.get((int)n6)).size;
                        int n9 = Math.min(a03GroupListUI._columnIndex, n8 - 1);
                        int n10 = a03GroupListUI.getModelIndex(n9, n6);
                        if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n10)) continue;
                        n2 = n10;
                        if ((n -= n3) != 0) continue;
                        break block3;
                    }
                    break block3;
                }
                int n11 = n2;
                while (0 <= (n11 += n3) && n11 < n4) {
                    if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n11)) continue;
                    n2 = n11;
                    if ((n -= n3) != 0) continue;
                    break;
                }
            }
            return n2;
        }

        private int getNextGroupIndex(GroupList groupList, A03GroupListUI a03GroupListUI, int n) {
            int n2;
            int n3 = groupList.getLeadSelectionIndex();
            GroupListModel groupListModel = groupList.getModel();
            int n4 = groupListModel.getSize();
            boolean bl = groupList.isGroupCellSelectable();
            int n5 = n2 = n > 0 ? 1 : -1;
            while (n != 0) {
                int n6;
                int n7 = n6 = n2 > 0 ? groupListModel.getNextGroupRowIndex(n3) : groupListModel.getGroupRowIndex(n3);
                boolean bl2 = false;
                if (n2 > 0 && n7 == n4 || n2 < 0 && n7 == 0) {
                    bl2 = true;
                }
                if (!bl) {
                    int n8;
                    int n9 = n8 = n2 > 0 ? n4 - 1 : n3;
                    while (++n7 < n8 && groupListModel.isGroupRow(n7)) {
                    }
                }
                if (bl2) {
                    n3 = n7;
                    break;
                }
                if (n3 == n7) {
                    assert (n2 == -1);
                    if (n6 > 0) {
                        n6 = groupListModel.getGroupRowIndex(n6 - 1);
                    }
                    n7 = n6;
                    if (!bl) {
                        while (++n7 < n3 && groupListModel.isGroupRow(n7)) {
                        }
                    }
                }
                n3 = n7;
                n -= n2;
            }
            return n3;
        }

        private int getVisibleRect(JList jList, int n, int n2) {
            int n3 = n2;
            if (n == n2) {
                if (jList.getLayoutOrientation() == 0) {
                    n3 = Math.max(0, n2 - 1);
                } else {
                    A03GroupListUI a03GroupListUI = (A03GroupListUI)((Object)jList.getUI());
                    int n4 = a03GroupListUI.convertModelToRow(n2);
                    if (n4 > 0) {
                        --n4;
                    }
                    n3 = a03GroupListUI.getModelIndex(0, n4);
                }
            }
            return n3;
        }
    }

    private static class GroupInfo {
        int size;
        int index;
        Point point;

        GroupInfo(int n, int n2) {
            this.index = n;
            this.size = n2;
        }

        GroupInfo(int n) {
            this(n, 1);
        }

        public String toString() {
            return String.format("%s(start: %d, size: %d)", this.getClass().getSimpleName(), this.index, this.size);
        }
    }

    private static class RowInfo
    extends GroupInfo {
        RowInfo(int n, int n2) {
            super(n, n2);
        }

        RowInfo(int n) {
            this(n, 1);
        }
    }

    private static class BasicHeaderRenderer
    implements ListCellRenderer,
    UIResource {
        private ListCellRenderer cellRenderer;

        public BasicHeaderRenderer(ListCellRenderer listCellRenderer) {
            this.cellRenderer = listCellRenderer;
        }

        public BasicHeaderRenderer() {
            this(new DefaultListCellRenderer());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = this.cellRenderer.getListCellRendererComponent(jList, object, n, true, true);
            if (object != null) {
                ((JComponent)component).setToolTipText(String.valueOf(object));
            }
            return component;
        }
    }

    public class PropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public PropertyChangeHandler() {
            super((BasicListUI)((Object)A03GroupListUI.this));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("layoutOrientation".equals(propertyChangeEvent.getPropertyName())) {
                A03GroupListUI.this.updateLayoutStateNeeded |= 128;
                A03GroupListUI.this.layoutOrientation = A03GroupListUI.this.list.getLayoutOrientation();
                A03GroupListUI.this.redrawList();
            } else if ("visibleRowCount".equals(string) || "preferredColumnCount".equals(string)) {
                if (A03GroupListUI.this.layoutOrientation != 0) {
                    A03GroupListUI.this.updateLayoutStateNeeded |= 128;
                    A03GroupListUI.this.redrawList();
                }
            } else if ("componentOrientation".equals(string)) {
                A03GroupListUI.this.updateLayoutStateNeeded |= 1024;
                A03GroupListUI.this.isLeftToRight = A03GroupListUI.this.list.getComponentOrientation().isLeftToRight();
                A03GroupListUI.this.redrawList();
                InputMap inputMap = A03GroupListUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(A03GroupListUI.this.list, 0, inputMap);
            } else if ("groupCellSelectable".equals(string)) {
                A03GroupListUI.this.redrawList();
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    public class ListSelectionHandler
    extends BasicListUI.ListSelectionHandler {
        public ListSelectionHandler() {
            super((BasicListUI)((Object)A03GroupListUI.this));
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            A03GroupListUI.this.maybeUpdateLayoutState();
            if (!A03GroupListUI.this._ignoreResetColumnIndex) {
                A03GroupListUI.this._columnIndex = A03GroupListUI.this.convertModelToColumn(A03GroupListUI.this.list.getSelectedIndex());
            }
            super.valueChanged(listSelectionEvent);
        }
    }
}

