/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.PropertySingleSelection;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.crossplatform.CPSwitch;
import com.macrofocus.format.CPFormat;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.AlgorithmFactory;
import com.treemap.LabelingFactory;
import com.treemap.NestingFactory;
import com.treemap.Ordering;
import com.treemap.OrderingFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.app.document.HorizontalAlignmentFormat;
import com.treemap.app.document.VerticalAlignmentFormat;

class GroupBySettingsPanel<Component, Color, Font> {
    private final TreeMapFieldSettings settings;
    private final CPFormPanel<Component> layout;

    public GroupBySettingsPanel(TreeMapModel treeMapModel, TreeMapField field, CPFactory<Component, Font, ?, Color> factory, AlgorithmFactory algorithmFactory) {
        this.settings = treeMapModel.getSettings().getFieldSettings(field);
        this.layout = factory.createFormPanel();
        CPSwitch overrideCommonSettings = factory.createSwitch(this.settings.getOverrideDefaultsProperty());
        CPButton reset = factory.createButton("Reset");
        reset.setCommand(new Command(){

            public void execute() {
                GroupBySettingsPanel.this.settings.reset();
            }
        });
        this.layout.add((CPComponent)factory.createLabel("Override Defaults:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{overrideCommonSettings, reset}));
        this.layout.add((CPComponent)factory.createLabel("Layout:"), (CPComponent)factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getAlgorithmProperty()), (Iterable)algorithmFactory.getAlgorithms()));
        this.layout.add((CPComponent)factory.createLabel("Nesting:"), (CPComponent)factory.createGridPanel(1, 3, new CPComponent[]{factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getNestingProperty()), (Iterable)NestingFactory.getInstance().getNestings()), factory.createDoubleSpinner(this.settings.getNestingAmountProperty()), factory.createColorPicker(this.settings.getNestingBackgroundProperty())}));
        CPComboBox ordering = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getOrderingProperty()), (Iterable)OrderingFactory.getInstance().getOrderings());
        CPComboBox orderingDirection = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getOrderingDirectionProperty()), Iterables.forArray((Object[])Ordering.SortOrder.values()));
        this.layout.add((CPComponent)factory.createLabel("Ordering:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{ordering, orderingDirection}));
        CPComboBox horizontalVanishingPoint = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getOrderingHorizontalVanishingPointProperty()), Iterables.forIntArray((int[])new int[]{2, 0, 4}));
        horizontalVanishingPoint.setFormat((CPFormat)HorizontalAlignmentFormat.getInstance());
        CPComboBox verticalVanishingPoint = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getOrderingVerticalVanishingPointProperty()), Iterables.forIntArray((int[])new int[]{1, 0, 3}));
        verticalVanishingPoint.setFormat((CPFormat)VerticalAlignmentFormat.getInstance());
        this.layout.add((CPComponent)factory.createLabel("Vanishing Point:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{horizontalVanishingPoint, verticalVanishingPoint}));
        this.layout.add((CPComponent)factory.createLabel("Header:"), (CPComponent)factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getLabelingProperty()), (Iterable)LabelingFactory.getInstance().getLabelings()));
        CPComboBox horizontalAlignment = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getHeaderHorizontalAlignmentProperty()), Iterables.forIntArray((int[])new int[]{2, 0, 4}));
        horizontalAlignment.setFormat((CPFormat)HorizontalAlignmentFormat.getInstance());
        CPComboBox verticalAlignment = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getHeaderVerticalAlignmentProperty()), Iterables.forIntArray((int[])new int[]{1, 0, 3}));
        verticalAlignment.setFormat((CPFormat)VerticalAlignmentFormat.getInstance());
        this.layout.add((CPComponent)factory.createLabel("Alignment:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{horizontalAlignment, verticalAlignment}));
        this.layout.add((CPComponent)factory.createLabel("Font:"), (CPComponent)factory.createGridPanel(1, 4, new CPComponent[]{factory.createFontPicker(this.settings.getHeaderFontProperty()), factory.createColorPicker(this.settings.getHeaderForegroundProperty()), factory.createColorPicker(this.settings.getHeaderEffectColorProperty()), factory.createColorPicker(this.settings.getHeaderBackgroundProperty())}));
        this.layout.add((CPComponent)factory.createLabel("Overflow:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getHeaderRenderingProperty()), Iterables.forArray((Object[])EnhancedLabel.Rendering.values())), factory.createIntegerSpinner(this.settings.getHeaderMinimumCharactersToDisplayProperty())}));
    }

    public CPComponent<Component> getPanel() {
        return this.layout;
    }
}

