/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document;

import com.macrofocus.common.command.Command;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.PropertySingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.crossplatform.CPSwitch;
import com.treemap.Aggregation;
import com.treemap.AggregationFactory;
import com.treemap.Scale;
import com.treemap.ScaleFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;

class SizeSettingsPanel<Component, Color, Font> {
    private final TreeMapModel treeMapModel;
    private TreeMapFieldSettings settings;
    private final CPFormPanel<Component> layout;
    private final CPSwitch<Component> overrideCommonSettings;
    private final CPComboBox<Component, Aggregation> aggregation;
    private final CPComboBox<Component, Scale> scale;

    public SizeSettingsPanel(TreeMapModel treeMapModel, CPFactory<Component, Font, ?, Color> factory) {
        this.treeMapModel = treeMapModel;
        this.layout = factory.createFormPanel();
        this.overrideCommonSettings = factory.createSwitch();
        CPButton reset = factory.createButton("Reset");
        reset.setCommand(new Command(){

            public void execute() {
                SizeSettingsPanel.this.settings.reset();
            }
        });
        this.layout.add((CPComponent)factory.createLabel("Override Defaults:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{this.overrideCommonSettings, reset}));
        this.aggregation = factory.createComboBox();
        this.layout.add((CPComponent)factory.createLabel("Aggregation:"), this.aggregation);
        this.scale = factory.createComboBox();
        this.layout.add((CPComponent)factory.createLabel("Scale:"), this.scale);
        MutableSingleSelection sizeVariableSelection = treeMapModel.getSettings().getSizeVariableSelection();
        sizeVariableSelection.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<TreeMapField>(){

            public void selectionChanged(SingleSelectionEvent<TreeMapField> event) {
                SizeSettingsPanel.this.setTreeMapFieldSettings((TreeMapField)event.getCurrentSelection());
            }
        });
        this.setTreeMapFieldSettings((TreeMapField)sizeVariableSelection.getSelected());
    }

    public void setTreeMapFieldSettings(TreeMapField field) {
        this.settings = field != null && field.isValid() ? this.treeMapModel.getSettings().getFieldSettings(field) : null;
        this.overrideCommonSettings.setProperty(this.settings != null ? this.settings.getOverrideDefaultsProperty() : null);
        this.aggregation.setModel((MutableSingleSelection)(this.settings != null ? new PropertySingleSelection(this.settings.getAggregationProperty()) : null), (Iterable)AggregationFactory.getInstance().getAggregations());
        this.scale.setModel((MutableSingleSelection)(this.settings != null ? new PropertySingleSelection(this.settings.getScaleProperty()) : null), (Iterable)ScaleFactory.getInstance().getScales());
    }

    public CPComponent<Component> getPanel() {
        return this.layout;
    }
}

