/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class DrillDownAction<N, Row, Column>
extends AbstractAction {
    private final TreeMapView<JComponent, N, Row, Column, Color, Font> _view;

    public DrillDownAction(TreeMapView<JComponent, N, Row, Column, Color, Font> view) {
        super("Drill Down");
        this._view = view;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeMapModel model = this._view.getModel();
        Object root = model.getCurrentRoot();
        model.getProbing().clearSelection();
        java.awt.Point location = ((JComponent)this._view.getNativeComponent()).getMousePosition();
        if (location != null) {
            ArrayList v = new ArrayList();
            for (Object treeMapNode : model.breadthFirstIterator(root)) {
                if (!this._view.contains(new Point(location.x, location.y), this._view.getRenderedShape(treeMapNode))) continue;
                if (model.hasNoChildren(treeMapNode)) {
                    Rectangle2D world = this._view.getWorld();
                    this._view.zoom(false, world.getMinX(), world.getMaxX(), world.getMinY(), world.getMaxY());
                    model.setCurrentRoot(model.getRoot());
                    break;
                }
                v.add(treeMapNode);
                if (v.size() <= 1) continue;
                Rectangle2D world = this._view.getWorld();
                this._view.zoom(false, world.getMinX(), world.getMaxX(), world.getMinY(), world.getMaxY());
                model.setCurrentRoot(v.get(1));
                break;
            }
        }
    }
}

