/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.originalconvexhull;

import com.treemap.swing.fastvoronoi.originalconvexhull.Site;
import com.treemap.swing.fastvoronoi.originalconvexhull.Vertex;
import com.treemap.swing.fastvoronoi.originalconvexhull.iSite;
import com.treemap.swing.fastvoronoi.polygon.Point2D;
import com.treemap.swing.fastvoronoi.polygon.PolygonSimple;
import java.util.ArrayList;

public class ASite
extends Vertex
implements Comparable<Site>,
iSite {
    protected static final double nearlyZero = 1.0E-10;
    protected double weight = 1.0E-10;
    protected double percentage = 1.0E-10;
    protected PolygonSimple polygon;
    public PolygonSimple nonClippedPolyon;
    protected ArrayList<Site> neighbours;

    private static double projectZ(double x, double y, double weight) {
        return x * x + y * y - weight;
    }

    @Override
    public PolygonSimple getPolygon() {
        return this.polygon;
    }

    @Override
    public String toString() {
        return "(" + this.getX() + "\t," + this.getY() + "," + this.weight + "," + this.percentage + ")+z: " + this.z;
    }

    @Override
    public void setPolygon(PolygonSimple poly) {
        this.polygon = poly;
    }

    @Override
    public void setNeighbours(ArrayList<Site> list) {
        this.neighbours = list;
    }

    @Override
    public ArrayList<Site> getNeighbours() {
        return this.neighbours;
    }

    public ASite(double x, double y) {
        super(x, y, ASite.projectZ(x, y, 1.0E-10));
        this.weight = 1.0E-10;
    }

    public ASite(double x, double y, double weight) {
        super(x, y, ASite.projectZ(x, y, weight));
        this.weight = weight;
    }

    public ASite(double x, double y, double weight, double percentage) {
        super(x, y, ASite.projectZ(x, y, weight));
        this.weight = weight;
        this.percentage = percentage;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
        this.z = ASite.projectZ(this.getX(), this.getY(), weight);
    }

    @Override
    public void setXY(double x, double y) {
        this.x = x;
        this.y = y;
        this.project();
    }

    @Override
    public void setXYW(double x, double y, double weight) {
        this.x = x;
        this.y = y;
        this.weight = weight;
        this.z = ASite.projectZ(x, y, weight);
    }

    private void project() {
        this.z = ASite.projectZ(this.x, this.y, this.weight);
    }

    @Override
    public void setX(double x) {
        this.x = x;
        this.project();
    }

    @Override
    public void setY(double y) {
        this.y = y;
        this.project();
    }

    @Override
    public int compareTo(Site b) {
        if (this.x < b.x) {
            return -1;
        }
        if (this.x > b.x) {
            return 1;
        }
        if (this.x == b.x) {
            if (this.y < b.y) {
                return -1;
            }
            if (this.y > b.y) {
                return 1;
            }
            if (this.y == b.y) {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    @Override
    public double getPercentage() {
        return this.percentage;
    }

    @Override
    public Point2D getPoint() {
        return new Point2D(this.getX(), this.getY());
    }

    public double distance(Site point) {
        double dx = this.x - point.getX();
        double dy = this.y - point.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distanceCircles(Site point) {
        double dx = this.x - point.getX();
        double dy = this.y - point.getY();
        double radius1 = Math.sqrt(this.weight);
        double radius2 = Math.sqrt(point.weight);
        return Math.sqrt(dx * dx + dy * dy) - radius1 - radius2;
    }
}

