/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.polygon;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.swing.fastvoronoi.polygon.ConvexClip;
import com.treemap.swing.fastvoronoi.polygon.Point2D;
import com.treemap.swing.fastvoronoi.polygon.cVertex;
import com.treemap.swing.fastvoronoi.polygon.cVertexList;
import java.util.Arrays;
import java.util.Random;

public class PolygonSimple
implements Shape,
Cloneable {
    protected Random seed = new Random(5L);
    protected Point2D centroid;
    protected double area = -1.0;
    protected Rectangle2D.Double bounds;
    protected PolygonSimple oldPolygon;
    protected double[] x;
    protected double[] y;
    public int length = 0;

    public PolygonSimple() {
        this.x = new double[16];
        this.y = new double[16];
    }

    public PolygonSimple(int numberPoints) {
        if (numberPoints > 2) {
            this.x = new double[numberPoints];
            this.y = new double[numberPoints];
        } else {
            this.x = new double[16];
            this.y = new double[16];
        }
    }

    public PolygonSimple(double[] xPoints, double[] yPoints, int length) {
        this.bounds = null;
        this.centroid = null;
        this.area = -1.0;
        this.x = Arrays.copyOf(xPoints, length);
        this.y = Arrays.copyOf(yPoints, length);
        this.length = length;
    }

    public PolygonSimple(double[] xPoints, double[] yPoints) {
        int length = xPoints.length;
        this.bounds = null;
        this.centroid = null;
        this.area = -1.0;
        this.x = Arrays.copyOf(xPoints, length);
        this.y = Arrays.copyOf(yPoints, length);
        this.length = length;
    }

    public static double crossProduct(Point2D p1, Point2D p2) {
        return p1.getX() * p2.getY() - p1.getY() * p2.getX();
    }

    public static double distancePointToSegment(double x1, double y1, double x2, double y2, double x3, double y3) {
        double px = x2 - x1;
        double py = y2 - y1;
        double d = Math.sqrt(px * px + py * py);
        double u = ((x3 - x1) * (x2 - x1) + (y3 - y1) * (y2 - y1)) / (d * d);
        double kx = x1 + u * (x2 - x1);
        double ky = y1 + u * (y2 - y1);
        double dkx = x3 - kx;
        double dky = y3 - ky;
        return Math.sqrt(dkx * dkx + dky * dky);
    }

    public void PolygonSimple(PolygonSimple simple) {
        this.bounds = null;
        this.centroid = null;
        this.area = -1.0;
        this.x = simple.x;
        this.y = simple.y;
        this.length = simple.length;
    }

    public boolean contains(double inX, double inY) {
        boolean contains = false;
        if (this.bounds == null) {
            this.getBounds();
        }
        if (!this.bounds.contains(inX, inY)) {
            return false;
        }
        int i = 0;
        int j = this.length - 1;
        while (i < this.length) {
            if ((this.y[i] <= inY && inY < this.y[j] || this.y[j] <= inY && inY < this.y[i]) && inX < (this.x[j] - this.x[i]) * (inY - this.y[i]) / (this.y[j] - this.y[i]) + this.x[i]) {
                contains = !contains;
            }
            j = i++;
        }
        return contains;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(double x, double y, double w, double h) {
        if (this.bounds == null) {
            this.getBounds2D();
        }
        if (this.bounds.contains(x, y, w, h)) {
            return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
        }
        return false;
    }

    public Rectangle2D getBounds2D() {
        if (this.bounds == null) {
            this.getBounds();
        }
        return this.bounds;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PolygonPathIterator(this, at);
    }

    public boolean contains(com.macrofocus.geom.Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    public PathIterator getFlattenPathIterator(double flatness) {
        return this.getPathIterator(null, flatness);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public boolean intersects(Rectangle2D r) {
        if (this.bounds == null) {
            this.getBounds();
        }
        return this.bounds.intersects(r);
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            double xmin = Double.MAX_VALUE;
            double ymin = Double.MAX_VALUE;
            double xmax = Double.MIN_VALUE;
            double ymax = Double.MIN_VALUE;
            for (int i = 0; i < this.length; ++i) {
                double x = this.x[i];
                double y = this.y[i];
                if (x < xmin) {
                    xmin = x;
                }
                if (x > xmax) {
                    xmax = x;
                }
                if (y < ymin) {
                    ymin = y;
                }
                if (!(y > ymax)) continue;
                ymax = y;
            }
            this.bounds = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        Rectangle2D b = this.bounds.getBounds2D();
        return new Rectangle((int)b.getX(), (int)b.getY(), (int)b.getWidth(), (int)b.getHeight());
    }

    public int getNumPoints() {
        return this.length;
    }

    public void add(double x, double y) {
        if (this.x.length <= this.length) {
            double[] newX = new double[this.x.length * 2];
            double[] newY = new double[this.x.length * 2];
            System.arraycopy(this.x, 0, newX, 0, this.length);
            System.arraycopy(this.y, 0, newY, 0, this.length);
            this.x = newX;
            this.y = newY;
        }
        this.x[this.length] = x;
        this.y[this.length] = y;
        ++this.length;
    }

    public void scale(double scalingFactor) {
        for (int i = 0; i < this.length; ++i) {
            this.x[i] = this.x[i] * scalingFactor;
            this.y[i] = this.y[i] * scalingFactor;
        }
    }

    public void translate(double tx, double ty) {
        for (int i = 0; i < this.length; ++i) {
            this.x[i] = this.x[i] + tx;
            this.y[i] = this.y[i] + ty;
        }
    }

    public void add(Point2D p) {
        this.add(p.x, p.y);
    }

    public PolygonSimple convexClip(PolygonSimple poly) {
        if (!this.getBounds2D().intersects(poly.getBounds2D())) {
            return null;
        }
        Rectangle2D b = poly.getBounds2D();
        if (this.contains(b.getX(), b.getY(), b.getWidth(), b.getHeight())) {
            return poly;
        }
        cVertexList list1 = this.getVertexList();
        cVertexList list2 = poly.getVertexList();
        ConvexClip clipper = new ConvexClip();
        clipper.Start(list1, list2);
        PolygonSimple res = new PolygonSimple();
        if (clipper.inters != null && clipper.inters.n > 0) {
            cVertex node = clipper.inters.head;
            double firstX = node.v.x;
            double firstY = node.v.y;
            res.add(node.v.x, node.v.y);
            double lastX = node.v.x;
            double lastY = node.v.y;
            for (int i = 1; i < clipper.inters.n; ++i) {
                node = node.next;
                if (lastX == node.v.x && lastY == node.v.y || i == clipper.inters.n - 1 && node.v.x == firstX && node.v.y == firstY) continue;
                res.add(node.v.x, node.v.y);
            }
            return res;
        }
        return poly;
    }

    private cVertexList getVertexList() {
        cVertexList list = new cVertexList();
        for (int i = this.length - 1; i >= 0; --i) {
            cVertex vertex = new cVertex(this.x[i], this.y[i]);
            list.InsertBeforeHead(vertex);
        }
        return list;
    }

    public double getArea() {
        if (this.area > 0.0) {
            return this.area;
        }
        double area = 0.0;
        int size = this.length - 1;
        for (int i = 0; i < size; ++i) {
            area += this.x[i] * this.y[i + 1] - this.x[i + 1] * this.y[i];
        }
        this.area = Math.abs(area += this.x[size] * this.y[0] - this.x[0] * this.y[size]) * 0.5;
        return this.area;
    }

    public double getMinDistanceToBorder(double x, double y) {
        double result = PolygonSimple.distancePointToSegment(this.x[this.length - 1], this.y[this.length - 1], this.x[0], this.y[0], x, y);
        for (int i = 0; i < this.length - 1; ++i) {
            double distance = PolygonSimple.distancePointToSegment(this.x[i], this.y[i], this.x[i + 1], this.y[i + 1], x, y);
            if (!(distance < result)) continue;
            result = distance;
        }
        return result;
    }

    public Point2D getCentroid() {
        if (this.centroid == null) {
            double xv = 0.0;
            double yv = 0.0;
            double areaQuotient = this.getArea() * 6.0;
            for (int i = 0; i < this.length; ++i) {
                double temp = this.x[i] * this.y[(i + 1) % this.length] - this.x[(i + 1) % this.length] * this.y[i];
                xv += (this.x[i] + this.x[(i + 1) % this.length]) * temp;
                yv += (this.y[i] + this.y[(i + 1) % this.length]) * temp;
            }
            xv = Math.abs(xv / areaQuotient);
            yv = Math.abs(yv / areaQuotient);
            this.centroid = new Point2D(xv, yv);
        }
        return this.centroid;
    }

    public PolygonSimple clone() {
        PolygonSimple p = new PolygonSimple(this.getXPoints(), this.getYPoints(), this.length);
        p.oldPolygon = this.oldPolygon;
        return p;
    }

    public void shrinkForBorder(double percentage) {
        this.oldPolygon = this.clone();
        this.getCentroid();
        double cx = this.centroid.getX();
        double cy = this.centroid.getY();
        for (int i = 0; i < this.length; ++i) {
            double deltaX = this.x[i] - cx;
            double deltaY = this.y[i] - cy;
            double xnew = cx + deltaX * percentage;
            double ynew = cy + deltaY * percentage;
            this.x[i] = xnew;
            this.y[i] = ynew;
        }
    }

    public Point2D getRelativePosition(Point2D vector) {
        double endPointY2;
        this.getCentroid();
        double endPointX = this.centroid.getX() + vector.getX();
        double endPointY = this.centroid.getY() + vector.getY();
        Point2D endPoint = new Point2D(endPointX, endPointY);
        if (this.contains(endPointX, endPointY)) {
            return new Point2D(endPointX, endPointY);
        }
        double endPointX2 = this.centroid.getX() + vector.getX() * 0.85;
        if (this.contains(endPointX2, endPointY2 = this.centroid.getY() + vector.getY() * 0.85)) {
            return new Point2D(endPointX2, endPointY2);
        }
        Point2D p1 = null;
        Point2D p2 = new Point2D(this.x[0], this.y[0]);
        Point2D result = null;
        for (int i = 1; i <= this.length; ++i) {
            p1 = p2;
            Point2D intersection = this.getIntersection(p1, p2 = i == this.length ? new Point2D(0.0, 0.0) : new Point2D(this.x[i], this.y[i]), this.centroid, endPoint);
            if (intersection == null) continue;
            double deltaX = intersection.getX() - this.centroid.getX();
            double deltaY = intersection.getY() - this.centroid.getY();
            double e = intersection.distance(this.centroid);
            double minimalDistanceToBorder = 10.0;
            double alpha = (e - minimalDistanceToBorder) / e;
            result = this.contains(this.centroid) ? new Point2D(this.centroid.getX() + deltaX * 0.8, this.centroid.getY() + deltaY * 0.8) : new Point2D(this.centroid.getX() + deltaX * 1.1, this.centroid.getY() + deltaY * (1.0 - alpha + 1.0));
            if (!this.contains(result)) continue;
            return result;
        }
        if (result != null && this.contains(result)) {
            return result;
        }
        return this.getInnerPoint();
    }

    private final Point2D getRelativePosition(Point2D vector, double alphaLine) {
        double dx = vector.getX();
        double dy = vector.getY();
        this.getCentroid();
        double centroidX = this.centroid.getX();
        double centroidY = this.centroid.getY();
        double endPointX = centroidX + dx;
        double endPointY = centroidY + dy;
        Point2D endPoint = new Point2D(endPointX, endPointY);
        Point2D p1 = null;
        Point2D p2 = new Point2D(this.x[0], this.y[0]);
        Object result = null;
        for (int i = 1; i <= this.length; ++i) {
            p1 = p2;
            Point2D intersection = PolygonSimple.getIntersectionOfSegmentAndLine(p1, p2 = new Point2D(this.x[i], this.y[i]), this.centroid, endPoint);
            if (intersection == null) continue;
            double deltaX = intersection.getX() - centroidX;
            double deltaY = intersection.getY() - centroidY;
            double e = intersection.distance(this.centroid);
            double nX = centroidX + deltaX * alphaLine;
            double nY = centroidY + deltaY * alphaLine;
            return new Point2D(nX, nY);
        }
        System.out.println("Problem, relative Placement did not go right.");
        return null;
    }

    public Point2D getInnerPoint() {
        Rectangle b = this.getBounds();
        double x = -1.0;
        double y = -1.0;
        while (!this.contains(x = b.getMinX() + (double)this.seed.nextInt(b.width), y = b.getMinY() + (double)this.seed.nextInt(b.height))) {
        }
        return new Point2D(x, y);
    }

    public Point2D getIntersectionWithPolygon(Double inx, Double iny, Double outx, Double outy) {
        Point2D[] intersections = new Point2D[4];
        int k = 0;
        int i = 0;
        int j = this.length - 1;
        while (i < this.length) {
            double denum = (this.x[i] - this.x[j]) * (iny - outy) - (inx - outx) * (this.y[i] - this.y[j]);
            if (denum != 0.0) {
                double t = (outx * (this.y[i] - this.y[j]) - outy * (this.x[i] - this.x[j]) + this.y[j] * (this.x[i] - this.x[j]) - this.x[j] * (this.y[i] - this.y[j])) / denum;
                double s = (outy * (inx - outx) + this.x[j] * (iny - outy) - outx * (iny - outy) - this.y[j] * (inx - outx)) / -denum;
                if (t > 0.0 && t <= 1.0 && s > 0.0 && s <= 1.0) {
                    intersections[k++] = new Point2D(outx + t * (inx - outx), outy + t * (iny - outy));
                }
            }
            j = i++;
        }
        if (k > 1) {
            return null;
        }
        return intersections[0];
    }

    private Point2D getIntersection(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        double x1 = 0.0;
        double x2 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double x3 = 0.0;
        double x4 = 0.0;
        double y3 = 0.0;
        double y4 = 0.0;
        if (p1.getX() < p2.getX()) {
            x1 = p1.getX();
            x2 = p2.getX();
        } else {
            x1 = p2.getX();
            x2 = p1.getX();
        }
        if (p1.getY() < p2.getY()) {
            y1 = p1.getY();
            y2 = p2.getY();
        } else {
            y1 = p2.getY();
            y2 = p1.getY();
        }
        if (p3.getX() < p4.getX()) {
            x3 = p3.getX();
            x4 = p4.getX();
        } else {
            x3 = p4.getX();
            x4 = p3.getX();
        }
        if (p3.getY() < p4.getY()) {
            y3 = p3.getY();
            y4 = p4.getY();
        } else {
            y3 = p4.getY();
            y4 = p3.getY();
        }
        if (!(x2 >= x2 && x4 >= x1 && y2 >= y3 && y4 >= y1)) {
            return null;
        }
        Point2D n1 = new Point2D(p3.getX() - p1.getX(), p3.getY() - p1.getY());
        Point2D n2 = new Point2D(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        Point2D n3 = new Point2D(p4.getX() - p1.getX(), p4.getY() - p1.getY());
        Point2D n4 = new Point2D(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        if (PolygonSimple.crossProduct(n1, n2) * PolygonSimple.crossProduct(n3, n4) >= 0.0) {
            return null;
        }
        double denominator = (p4.getY() - p3.getY()) * (p2.getX() - p1.getX()) - (p4.getX() - p3.getX()) * (p2.getY() - p1.getY());
        if (denominator == 0.0) {
            throw new RuntimeException("Lines are parallel");
        }
        double ua = (p4.getX() - p3.getX()) * (p1.getY() - p3.getY()) - (p4.getY() - p3.getY()) * (p1.getX() - p3.getX());
        double ub = (p2.getX() - p1.getX()) * (p1.getY() - p3.getY()) - (p2.getY() - p1.getY()) * (p1.getX() - p3.getX());
        ua /= denominator;
        ub /= denominator;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
            return new Point2D(p1.getX() + ua * (p2.getX() - p1.getX()), p1.getY() + ua * (p2.getY() - p1.getY()));
        }
        return null;
    }

    private static Point2D getIntersectionOfSegmentAndLine(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        double denominator = (p4.getY() - p3.getY()) * (p2.getX() - p1.getX()) - (p4.getX() - p3.getX()) * (p2.getY() - p1.getY());
        if (denominator == 0.0) {
            throw new RuntimeException("Lines are parallel");
        }
        double ua = (p4.getX() - p3.getX()) * (p1.getY() - p3.getY()) - (p4.getY() - p3.getY()) * (p1.getX() - p3.getX());
        double ub = (p2.getX() - p1.getX()) * (p1.getY() - p3.getY()) - (p2.getY() - p1.getY()) * (p1.getX() - p3.getX());
        ua /= denominator;
        ub /= denominator;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 1.0) {
            return new Point2D(p1.getX() + ua * (p2.getX() - p1.getX()), p1.getY() + ua * (p2.getY() - p1.getY()));
        }
        return null;
    }

    public double[] getXPoints() {
        return this.x;
    }

    public double[] getYPoints() {
        return this.y;
    }

    public PolygonSimple getOriginalPolygon() {
        return this.oldPolygon;
    }

    class PolygonPathIterator
    implements PathIterator {
        PolygonSimple poly;
        AffineTransform transform;
        int index;

        public PolygonPathIterator(PolygonSimple pg, AffineTransform at) {
            this.poly = pg;
            this.transform = at;
            if (pg.getNumPoints() == 0) {
                this.index = 1;
            }
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.index > this.poly.getNumPoints();
        }

        public void next() {
            ++this.index;
        }

        public int currentSegment(float[] coords) {
            if (this.index >= this.poly.getNumPoints()) {
                return 4;
            }
            coords[0] = (float)this.poly.x[this.index];
            coords[1] = (float)this.poly.y[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            if (this.index >= this.poly.length) {
                return 4;
            }
            coords[0] = this.poly.x[this.index];
            coords[1] = this.poly.y[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

