/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi;

import com.treemap.swing.originalfastvoronoi.datastructure.OpenList;
import com.treemap.swing.originalfastvoronoi.j2d.Point2D;
import com.treemap.swing.originalfastvoronoi.j2d.PolygonSimple;
import com.treemap.swing.originalfastvoronoi.j2d.Site;
import com.treemap.swing.originalfastvoronoi.pd.PowerDiagram;
import java.util.Random;

public class VoronoiCore {
    private final boolean firstIteration = true;
    private static final double nearlyOne = 0.99;
    private double preflowPercentage = 0.08;
    private double preflowIncrease = 1.5;
    private boolean useNegativeWeights = true;
    private boolean useExtrapolation = false;
    protected boolean cancelOnAreaErrorThreshold = false;
    protected boolean cancelOnMaxIterat = true;
    protected double errorAreaThreshold = 0.05;
    protected PolygonSimple clipPolygon;
    private boolean guaranteeInvariant = false;
    protected OpenList sites;
    private int numberMaxIterations;
    protected double completeArea = 1.0;
    protected boolean preflowFinished = false;
    double maxDelta = 0.0;
    protected PowerDiagram diagram;
    private double currentMaxError;
    protected double currentAreaError = 0.0;
    protected double currentEuclidChange = 0.0;
    public double lastAreaError = 1.0;
    public double lastAVGError = 1.0;
    public double lastMaxError = 1.0;
    public double lastSumErrorChange = 1.0;
    protected double lastEuclidChange = 0.0;
    private double currentMaxNegativeWeight;
    private boolean aggressiveMode = false;

    public void setClipPolygon(PolygonSimple polygon) {
        this.clipPolygon = polygon;
        this.maxDelta = Math.max(this.clipPolygon.getBounds2D().getWidth(), this.clipPolygon.getBounds2D().getHeight());
        if (this.diagram != null) {
            this.diagram.setClipPoly(polygon);
        }
    }

    private void init() {
        this.diagram = new PowerDiagram();
        if (this.clipPolygon != null) {
            this.maxDelta = Math.max(this.clipPolygon.getBounds2D().getWidth(), this.clipPolygon.getBounds2D().getHeight());
        }
    }

    public VoronoiCore() {
        this.sites = new OpenList();
        this.init();
    }

    public VoronoiCore(PolygonSimple clipPolygon) {
        this.sites = new OpenList();
        this.clipPolygon = clipPolygon;
        this.init();
        this.diagram.setClipPoly(clipPolygon);
    }

    public VoronoiCore(OpenList sites, PolygonSimple clipPolygon) {
        this.sites = sites;
        this.clipPolygon = clipPolygon;
        this.init();
    }

    public void addSite(Site site) {
        this.sites.add(site);
    }

    public void iterate() {
        int z;
        double percentage;
        int z2;
        int size;
        Site[] array;
        this.currentMaxNegativeWeight = 0.0;
        this.currentEuclidChange = 0.0;
        this.currentAreaError = 0.0;
        this.currentMaxError = 0.0;
        this.completeArea = this.clipPolygon.getArea();
        double errorArea = 0.0;
        int amount = 0;
        if (this.isUseExtrapolation() && !this.preflowFinished) {
            array = this.sites.array;
            size = this.sites.size;
            for (z2 = 0; z2 < size; ++z2) {
                Site site = array[z2];
                PolygonSimple poly = site.getPolygon();
                double percentage2 = site.getPercentage();
                double wantedArea = this.completeArea * percentage2;
                double currentArea = poly.getArea();
                double increase = wantedArea / currentArea;
                if (!(percentage2 >= this.getPreflowPercentage()) || !(increase >= this.getPreflowIncrease())) continue;
                ++amount;
                double radiusIncrease = Math.sqrt(increase);
                double radiusCurrent = Math.sqrt(site.getWeight());
                double deltaRadius = radiusCurrent * radiusIncrease - radiusCurrent;
                for (int y = 0; y < size; ++y) {
                    Site other = array[y];
                    if (other == site || !(other.getPercentage() < this.getPreflowPercentage())) continue;
                    Point2D vector = new Point2D();
                    vector.x = other.getX() - site.getX();
                    vector.y = other.getY() - site.getY();
                    double length = vector.length();
                    double linearDistanceScaledDeltaRadius = deltaRadius * (1.0 - (length - radiusCurrent) / this.maxDelta);
                    double scale = linearDistanceScaledDeltaRadius / length;
                    vector.scale(scale);
                    other.preflowVector.x += vector.x;
                    other.preflowVector.y += vector.y;
                }
            }
        }
        if (amount == 0) {
            this.preflowFinished = true;
        }
        array = this.sites.array;
        size = this.sites.size;
        for (z2 = 0; z2 < size; ++z2) {
            Site point = array[z2];
            double error = 0.0;
            percentage = point.getPercentage();
            PolygonSimple poly = point.getPolygon();
            if (poly != null) {
                Point2D centroid = poly.getCentroid();
                double centroidX = centroid.getX();
                double centroidY = centroid.getY();
                double dx = centroidX - point.getX();
                double dy = centroidY - point.getY();
                this.currentEuclidChange += dx * dx + dy * dy;
                double currentArea = poly.getArea();
                double wantedArea = this.completeArea * point.getPercentage();
                double increase = wantedArea / currentArea;
                error = Math.abs(wantedArea - currentArea);
                double minDistanceClipped = poly.getMinDistanceToBorder(centroidX, centroidY);
                minDistanceClipped *= 0.99;
                double rootBorder = this.clipPolygon.getMinDistanceToBorder(point.getX(), point.getY());
                if (this.isUseExtrapolation() && !this.preflowFinished && point.preflowVector.length() != 0.0) {
                    point.preflowVector.scale(minDistanceClipped / point.preflowVector.length());
                    if (point.preflowVector.length() > 5.0) {
                        centroidX += point.preflowVector.x;
                        centroidY += point.preflowVector.y;
                    }
                    point.preflowVector.x = 0.0;
                    point.preflowVector.y = 0.0;
                }
                double minDistance = point.nonClippedPolyon.getMinDistanceToBorder(centroidX, centroidY);
                double weight = Math.min(point.getWeight(), minDistance * minDistance);
                if (weight < 1.0E-8) {
                    weight = 1.0E-8;
                }
                System.err.println(z2 + ": centroid=" + centroid + ", distanceToBorder=" + minDistance + ",weight=" + weight);
                point.setXYW(centroidX, centroidY, weight);
            }
            errorArea += (error /= this.completeArea * 2.0);
        }
        this.currentAreaError += errorArea;
        this.voroDiagram();
        OpenList sitesCopy = null;
        if (this.guaranteeInvariant) {
            sitesCopy = this.sites.cloneWithZeroWeights();
            this.diagram.setSites(sitesCopy);
            this.diagram.setClipPoly(this.clipPolygon);
            this.diagram.computeDiagram();
        }
        for (z = 0; z < size; ++z) {
            Site point = array[z];
            PolygonSimple poly = point.getPolygon();
            double completeArea = this.clipPolygon.getArea();
            double currentArea = poly.getArea();
            double wantedArea = completeArea * point.getPercentage();
            double currentRadius = Math.sqrt(currentArea / Math.PI);
            double wantedRadius = Math.sqrt(wantedArea / Math.PI);
            double deltaCircle = currentRadius - wantedRadius;
            double increase = wantedArea / currentArea;
            if (!this.getAggressiveMode()) {
                increase = Math.sqrt(increase);
            }
            double minDistance = 0.0;
            if (this.guaranteeInvariant) {
                Site pointOrdinary = sitesCopy.array[z];
                minDistance = this.getMinNeighbourDistance(pointOrdinary);
            } else {
                minDistance = this.getMinNeighbourDistance(point);
            }
            minDistance *= 0.99;
            double radiusOld = Math.sqrt(point.getWeight());
            double radiusNew = radiusOld * increase;
            double deltaRadius = radiusNew - radiusOld;
            if (radiusNew > minDistance) {
                radiusNew = minDistance;
            }
            double finalWeight = radiusNew * radiusNew;
            if (this.useNegativeWeights) {
                double radiusNew2;
                Point2D center = poly.getCentroid();
                double distanceBorder = poly.getMinDistanceToBorder(center.x, center.y);
                double maxDelta = Math.min(distanceBorder, deltaCircle);
                if (finalWeight < 1.0E-4 && (radiusNew2 = radiusNew - maxDelta) < 0.0 && (finalWeight = -(radiusNew2 * radiusNew2)) < this.currentMaxNegativeWeight) {
                    this.currentMaxNegativeWeight = finalWeight;
                }
            }
            point.setWeight(finalWeight);
        }
        if (this.useNegativeWeights && this.currentMaxNegativeWeight < 0.0) {
            this.currentMaxNegativeWeight += 0.010000000000000009;
            this.currentMaxNegativeWeight = -this.currentMaxNegativeWeight;
            for (z = 0; z < size; ++z) {
                Site s = array[z];
                double w = s.getWeight();
                s.setWeight(w += this.currentMaxNegativeWeight);
            }
        }
        this.voroDiagram();
        this.currentMaxError = 0.0;
        array = this.sites.array;
        size = this.sites.size;
        for (z = 0; z < size; ++z) {
            Site site = array[z];
            PolygonSimple poly = site.getPolygon();
            percentage = site.getPercentage();
            double wantedArea = this.completeArea * percentage;
            double currentArea = poly.getArea();
            double singleError = Math.abs(1.0 - currentArea / wantedArea);
            if (!(singleError > this.currentMaxError)) continue;
            this.currentMaxError = singleError;
        }
        this.lastEuclidChange = this.currentEuclidChange / (double)size;
        this.lastSumErrorChange = Math.abs(this.lastAreaError - this.currentAreaError);
        this.lastAreaError = this.currentAreaError;
        this.lastMaxError = this.currentMaxError;
        this.lastAVGError = this.currentAreaError / (double)size;
    }

    private double getMinNeighbourDistance(Site point) {
        double minDistance = Double.MAX_VALUE;
        for (Site neighbour : point.getNeighbours()) {
            double distance = neighbour.distance(point);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
        }
        return minDistance;
    }

    public synchronized void voroDiagram() {
        this.diagram.setSites(this.sites);
        this.diagram.setClipPoly(this.clipPolygon);
        try {
            this.diagram.computeDiagram();
        }
        catch (Exception e) {
            System.out.println("Error on computing power diagram");
            e.printStackTrace();
        }
    }

    public void doIterate() {
        this.doIterate(this.numberMaxIterations);
    }

    public void doIterate(int iterationAmount) {
        if (this.sites.size == 1) {
            PolygonSimple p = this.clipPolygon.clone();
            Site site = this.sites.get(0);
            site.setPolygon(p);
            return;
        }
        this.voroDiagram();
        for (int i = 0; i < iterationAmount; ++i) {
            this.iterate();
            if (this.isCancelOnAreaErrorThreshold() && this.lastMaxError < this.errorAreaThreshold) break;
        }
        Site[] array = this.sites.array;
        int size = this.sites.size;
        for (int z = 0; z < size; ++z) {
            Site site = array[z];
            PolygonSimple poly = site.getPolygon();
            if (site.cellObject == null) continue;
            site.cellObject.setVoroPolygon(poly);
            site.cellObject.doFinalWork();
        }
    }

    public void setCancelOnAreaErrorThreshold(boolean cancelOnThreshold) {
        this.cancelOnAreaErrorThreshold = cancelOnThreshold;
    }

    public boolean isCancelOnAreaErrorThreshold() {
        return this.cancelOnAreaErrorThreshold;
    }

    public void setCancelOnMaxIterat(boolean cancelOnMaxIterat) {
        this.cancelOnMaxIterat = cancelOnMaxIterat;
    }

    public void setErrorAreaThreshold(double errorAreaThreshold) {
        this.errorAreaThreshold = errorAreaThreshold;
    }

    public void setSites(OpenList sites) {
        this.sites = sites;
    }

    public OpenList getSites() {
        return this.sites;
    }

    private static void normalizeSites(OpenList sites) {
        Site s;
        int z;
        double sum = 0.0;
        Site[] array = sites.array;
        int size = sites.size;
        for (z = 0; z < size; ++z) {
            s = array[z];
            sum += s.getPercentage();
        }
        for (z = 0; z < size; ++z) {
            s = array[z];
            s.setPercentage(s.getPercentage() / sum);
        }
    }

    public void setUseExtrapolation(boolean useExtrapolation) {
        this.useExtrapolation = useExtrapolation;
    }

    public boolean isUseExtrapolation() {
        return this.useExtrapolation;
    }

    public double getPreflowPercentage() {
        return this.preflowPercentage;
    }

    public void setPreflowIncrease(double preflowIncrease) {
        this.preflowIncrease = preflowIncrease;
    }

    private double getPreflowIncrease() {
        return this.preflowIncrease;
    }

    public void setGuaranteeValidCells(boolean guaranteeInvariant) {
        this.guaranteeInvariant = guaranteeInvariant;
    }

    public void setNumberMaxIterations(int numberMaxIterations) {
        this.numberMaxIterations = numberMaxIterations;
    }

    public void setPreflowPercentage(double preflowPercentage) {
        this.preflowPercentage = preflowPercentage;
    }

    public void setUseNegativeWeights(boolean useNegativeWeights) {
        this.useNegativeWeights = useNegativeWeights;
    }

    public void setAggressiveMode(boolean aggressiveMode) {
        this.aggressiveMode = aggressiveMode;
    }

    public boolean getAggressiveMode() {
        return this.aggressiveMode;
    }

    public static void main(String[] args) {
        VoronoiCore core = new VoronoiCore();
        OpenList sites = new OpenList();
        Random rand = new Random(100L);
        int amount = 200;
        PolygonSimple rootPolygon = new PolygonSimple();
        int width = 500;
        int height = 500;
        rootPolygon.add(0.0, 0.0);
        rootPolygon.add(width, 0.0);
        rootPolygon.add(width, height);
        rootPolygon.add(0.0, height);
        for (int i = 0; i < amount; ++i) {
            Site site = new Site(rand.nextInt(width), rand.nextInt(width));
            site.setPercentage(1.0);
            sites.add(site);
        }
        sites.get(0).setPercentage(3.0);
        VoronoiCore.normalizeSites(sites);
        core.setSites(sites);
        core.setClipPolygon(rootPolygon);
        long start = System.currentTimeMillis();
        core.setUseNegativeWeights(true);
        core.setCancelOnAreaErrorThreshold(true);
        core.doIterate(5000);
        long end = System.currentTimeMillis();
        double diff = (double)(end - start) / 1000.0;
        System.out.println("NeededTime: " + diff);
    }
}

