/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.convexHull;

import com.treemap.swing.originalfastvoronoi.convexHull.JFace;
import com.treemap.swing.originalfastvoronoi.convexHull.JGraphEdge;
import com.treemap.swing.originalfastvoronoi.convexHull.JVertex;
import java.util.List;

public class JConflictList {
    private boolean face;
    protected JGraphEdge head;

    public JConflictList(boolean face) {
        this.face = face;
    }

    public void add(JGraphEdge e) {
        if (this.head == null) {
            this.head = e;
        } else if (this.face) {
            this.head.prevv = e;
            e.nextv = this.head;
            this.head = e;
        } else {
            this.head.prevf = e;
            e.nextf = this.head;
            this.head = e;
        }
    }

    public boolean empty() {
        return this.head == null;
    }

    public void fill(List<JFace> visible) {
        if (this.face) {
            System.out.println("can't fill facet");
            return;
        }
        JGraphEdge curr = this.head;
        do {
            visible.add(curr.face);
            curr.face.setMarked(true);
        } while ((curr = curr.nextf) != null);
    }

    public void removeAll() {
        if (this.face) {
            JGraphEdge curr = this.head;
            do {
                if (curr.prevf == null) {
                    if (curr.nextf == null) {
                        curr.vert.getList().head = null;
                    } else {
                        curr.nextf.prevf = null;
                        curr.vert.getList().head = curr.nextf;
                    }
                } else {
                    if (curr.nextf != null) {
                        curr.nextf.prevf = curr.prevf;
                    }
                    curr.prevf.nextf = curr.nextf;
                }
                curr = curr.nextv;
                if (curr == null) continue;
                curr.prevv = null;
            } while (curr != null);
        } else {
            JGraphEdge curr = this.head;
            do {
                if (curr.prevv == null) {
                    if (curr.nextv == null) {
                        curr.face.getList().head = null;
                    } else {
                        curr.nextv.prevv = null;
                        curr.face.getList().head = curr.nextv;
                    }
                } else {
                    if (curr.nextv != null) {
                        curr.nextv.prevv = curr.prevv;
                    }
                    curr.prevv.nextv = curr.nextv;
                }
                curr = curr.nextf;
                if (curr == null) continue;
                curr.prevf = null;
            } while (curr != null);
        }
    }

    public List<JVertex> getVertices(List<JVertex> l1) {
        JGraphEdge curr = this.head;
        while (curr != null) {
            l1.add(curr.vert);
            curr = curr.nextv;
        }
        return l1;
    }
}

