/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.plaf.basic;

import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.TreeMapRenderer;
import com.treemap.TreeMapToolTip;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import com.treemap.swing.SwingTreeMapView;
import com.treemap.swing.crossplatform.SwingImage;
import com.treemap.swing.crossplatform.SwingTGraphics;
import com.treemap.swing.plaf.TreeMapUI;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicTreeMapUI
extends TreeMapUI {
    private boolean needsProgressive = true;
    private final ExecutorService _executor = SwingFactory.getInstance().newFixedThreadPool(this.getSelf().getClass().getSimpleName(), 0, 1);
    private FutureTask _workerFuture;
    Timer _timer;
    private final boolean _useExecutor = !System.getProperty("java.version").startsWith("1.5");
    private SwingImage _img;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTreeMapUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        com.macrofocus.common.geom.Dimension tooltipDimension;
        Point tooltipPosition;
        SwingTreeMapView swingView;
        final SwingTreeMapView view = ((SwingTreeMapView.NativeComponent)c).getTreeMapView();
        long current = System.currentTimeMillis();
        Graphics2D g2 = (Graphics2D)g;
        if (view instanceof SwingTreeMapView && (swingView = view).getRenderingHints() != null) {
            g2.setRenderingHints(swingView.getRenderingHints());
        }
        SwingTGraphics tg = new SwingTGraphics(g2);
        Dimension d = ((JComponent)view.getNativeComponent()).getSize();
        for (TreeMapRenderer renderer : view.getPreRenderers()) {
            renderer.paint((TGraphics)tg, view, null);
        }
        boolean paintingForPrint = false;
        try {
            paintingForPrint = ((JComponent)view.getNativeComponent()).isPaintingForPrint();
        }
        catch (NoSuchMethodError renderer) {
            // empty catch block
        }
        if (paintingForPrint) {
            view.getModel().waitUntilReady();
        }
        if (view.getProgressive() != TreeMapView.Progressive.Disabled && !paintingForPrint && this._useExecutor && !GraphicsEnvironment.isHeadless()) {
            if (this._workerFuture != null && this._workerFuture.isDone()) {
                try {
                    this._workerFuture.get();
                }
                catch (CancellationException renderer) {
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if (this._img == null || this._img.getWidth() != d.width || this._img.getHeight() != d.height || this._img.getScaleFactor() != SwingImage.findCurrentScaleFactor(g2)) {
                this._img = new SwingImage(g2, d.width, d.height);
                view.setDirty(true);
            }
            if (view.isDirty()) {
                if (this._workerFuture != null && !this._workerFuture.isDone()) {
                    this._workerFuture.cancel(false);
                } else {
                    view.setDirty(false);
                    Iterator gp = this._img.createGraphics();
                    ((Graphics2D)((Object)gp)).setComposite(AlphaComposite.getInstance(1, 0.0f));
                    ((Graphics2D)((Object)gp)).fill(new Rectangle2D.Double(0.0, 0.0, this._img.getWidth(), this._img.getHeight()));
                    ((Graphics)((Object)gp)).dispose();
                    final SwingImage workingImage = this._img;
                    Callable<Void> worker = new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Graphics2D g = workingImage.createGraphics();
                            g.setRenderingHints(g.getRenderingHints());
                            g.setBackground(((JComponent)view.getNativeComponent()).getBackground());
                            g.setFont(((JComponent)view.getNativeComponent()).getFont());
                            g.setClip(new Rectangle(0, 0, workingImage.getWidth(), workingImage.getHeight()));
                            long start = System.currentTimeMillis();
                            SwingTGraphics tg = new SwingTGraphics(g);
                            for (TreeMapRenderer renderer : view.getProgressiveRenderers()) {
                                renderer.paint((TGraphics)tg, view, (Future)BasicTreeMapUI.this._workerFuture);
                            }
                            long end = System.currentTimeMillis();
                            BasicTreeMapUI.this.needsProgressive = end - start > 49L;
                            g.dispose();
                            BasicTreeMapUI.this._workerFuture = null;
                            ((JComponent)view.getNativeComponent()).repaint();
                            if (view.getProgressive() == TreeMapView.Progressive.Iterative && BasicTreeMapUI.this._timer != null) {
                                BasicTreeMapUI.this._timer.cancel();
                                BasicTreeMapUI.this._timer = null;
                            }
                            return null;
                        }
                    };
                    if (view.getProgressive() != TreeMapView.Progressive.Disabled && this.needsProgressive) {
                        this._workerFuture = new FutureTask<Void>(worker);
                        this._executor.submit(this._workerFuture);
                        if (view.getProgressive() == TreeMapView.Progressive.Iterative) {
                            if (this._timer != null) {
                                this._timer.cancel();
                                this._timer = null;
                            }
                            assert (this._timer == null);
                            this._timer = new Timer();
                            this._timer.scheduleAtFixedRate(new TimerTask((TreeMapView)view){
                                final /* synthetic */ TreeMapView val$view;
                                {
                                    this.val$view = treeMapView;
                                }

                                @Override
                                public void run() {
                                    ((JComponent)this.val$view.getNativeComponent()).repaint();
                                }
                            }, 50L, 50L);
                        }
                    } else {
                        try {
                            worker.call();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (this._workerFuture != null && !this._workerFuture.isDone() || view.isDirty()) {
                for (TreeMapRenderer renderer : view.getPreProgressiveRenderers()) {
                    renderer.paint((TGraphics)tg, view, null);
                }
            }
            if (this._img.getScaleFactor() > 1.0) {
                tg.save();
                tg.scale(1.0 / this._img.getScaleFactor(), 1.0 / this._img.getScaleFactor());
                tg.drawNativeImage(this._img.getImage(), 0, 0);
                tg.restore();
            } else {
                tg.drawNativeImage(this._img.getImage(), 0, 0);
            }
        } else {
            for (TreeMapRenderer renderer : view.getProgressiveRenderers()) {
                renderer.paint((TGraphics)tg, view, null);
            }
        }
        for (TreeMapRenderer renderer : view.getPostRenderers()) {
            renderer.paint((TGraphics)tg, view, null);
        }
        TreeMapToolTip toolTip = view.getToolTip();
        if (toolTip != null && (paintingForPrint || toolTip.getType() == TreeMapToolTip.ToolTipType.Painted)) {
            tooltipPosition = toolTip.getPopupLocation();
            tooltipDimension = toolTip.getPreferredSize((TGraphics)tg);
            if (tooltipPosition != null && tooltipDimension != null) {
                toolTip.setSize(tooltipDimension);
                tg.save();
                tg.translate(tooltipPosition.x, tooltipPosition.y);
                tg.clip((Shape)new Rectangle2D.Double(0.0, 0.0, tooltipDimension.getWidth(), tooltipDimension.getHeight()));
                toolTip.paintBackground((TGraphics)tg);
                toolTip.paintText((TGraphics)tg);
                tg.restore();
            }
        }
        if ((toolTip = view.getSelectionToolTip()) != null && (paintingForPrint || toolTip.getType() == TreeMapToolTip.ToolTipType.Painted)) {
            tooltipPosition = toolTip.getPreferredLocation();
            tooltipDimension = toolTip.getPreferredSize((TGraphics)tg);
            if (tooltipPosition == null || tooltipDimension != null) {
                // empty if block
            }
        }
        if (view.getRubberBand().getRubberBand().isActive()) {
            tg.save();
            tg.setStroke(SwingFactory.getInstance().getBlack());
            double[] dashPattern = new double[]{10.0, 2.0, 2.0, 2.0};
            tg.setLineWidth(1.0);
            tg.setLineDash(dashPattern);
            Rectangle2D r = view.getRubberBand().getRubberBandScreen();
            tg.stroke((Shape)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
            tg.restore();
        }
        if (view.isShowTiming()) {
            tg.setFont((Font)SwingFactory.getInstance().createFont("Menlo", 1, 16).getNativeFont());
            tg.setFill(SwingFactory.getInstance().getOrange());
            String text = System.currentTimeMillis() - current + " ms";
            tg.fillText(text, 4.0f, (float)((JComponent)view.getNativeComponent()).getSize().height - 6.0f);
            tg.setFill(SwingFactory.getInstance().getPurple());
            tg.fillText(text, 6.0f, (float)((JComponent)view.getNativeComponent()).getSize().height - 4.0f);
            tg.setFill(SwingFactory.getInstance().getRed());
            tg.fillText(text, 5.0f, (float)((JComponent)view.getNativeComponent()).getSize().height - 5.0f);
        }
    }

    private BasicTreeMapUI getSelf() {
        return this;
    }
}

