/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.tagcloud;

import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.IHeadless;
import com.macrofocus.igraphics.swing.SwingIHeadless;
import com.treemap.swing.tagcloud.SwingGeneralPath;
import com.treemap.swing.tagcloud.SwingTextShape;
import com.treemap.tagcloud.AbstractTagCloudAlgorithm;
import com.treemap.tagcloud.RectangularTextShape;
import com.treemap.tagcloud.TagCloudAlgorithm;
import com.treemap.tagcloud.TextShape;
import com.treemap.tagcloud.TextShapeFactory;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class SwingTagCloudAlgorithm
extends AbstractTagCloudAlgorithm<Font> {
    public SwingTagCloudAlgorithm() {
        super((TextShapeFactory)new SwingTextShapeFactory(), (CPFontFactory)SwingFactory.getInstance());
    }

    public SwingTagCloudAlgorithm(TagCloudAlgorithm.OrientationMode orientationMode, TagCloudAlgorithm.Spiral spiral, CPFont<Font> font) {
        super((TextShapeFactory)new SwingTextShapeFactory(), (CPFontFactory)SwingFactory.getInstance(), orientationMode, spiral, font);
    }

    private static class RectangularTextShapeFactory
    implements TextShapeFactory<Font> {
        final SwingIHeadless headless = new SwingIHeadless();

        private RectangularTextShapeFactory() {
        }

        public TextShape createTextShape(String text, CPFont<Font> font) {
            return new RectangularTextShape((IHeadless)this.headless, font, text);
        }
    }

    private static class SwingTextShapeFactory
    implements TextShapeFactory<Font> {
        private BufferedImage imageToHaveGraphics = new BufferedImage(1, 1, 10);
        private Graphics2D g = this.imageToHaveGraphics.createGraphics();

        public TextShape createTextShape(String text, CPFont<Font> font) {
            this.g.setFont(((Font)font.getNativeFont()).deriveFont(40.0f));
            FontRenderContext frc = this.g.getFontRenderContext();
            TextLayout textLayout = new TextLayout(text, (Font)font.getNativeFont(), frc);
            SwingTextShape outline = new SwingTextShape(text, new SwingGeneralPath((GeneralPath)textLayout.getOutline(null)));
            return outline;
        }
    }
}

