/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.tagcloud;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.GeneralPath;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.MutableTreeMapNode;
import com.treemap.swing.tagcloud.SwingTextShape;
import com.treemap.tagcloud.HierarchicalBoundingBoxes;
import com.treemap.tagcloud.Orientation;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.TextShape;
import com.treemap.tagcloud.Word;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;

public class SwingWord
implements Word {
    private final String text;
    private final double size;
    private final MutableTreeMapNode treeMapNode;
    private final Point2d location = new Point2d();
    private final TextShape normedAndCenteredShape;
    private HierarchicalBoundingBoxes hierarchicalBoundingBoxes;

    public SwingWord(Graphics2D g, String text, double size, MutableTreeMapNode treeMapNode, Orientation orientation, int nSubdivisions) {
        this.text = text;
        this.size = size;
        this.treeMapNode = treeMapNode;
        Font font = g.getFont().deriveFont(40.0f);
        g.setFont(font);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout textLayout = new TextLayout(text, font, frc);
        SwingTextShape outline = new SwingTextShape(text, (GeneralPath)textLayout.getOutline(null));
        Rectangle2D renderSizeBounds = outline.getBounds2D();
        SwingTextShape centeredShape = (SwingTextShape)outline.createTransformedShape(AffineTransform.getTranslateInstance((double)(-renderSizeBounds.getWidth() / 2.0), (double)(renderSizeBounds.getHeight() / 2.0)));
        SwingTextShape normedAndCenteredShape = (SwingTextShape)centeredShape.createTransformedShape(AffineTransform.getScaleInstance((double)size, (double)size));
        if (orientation == Orientation.Vertical) {
            normedAndCenteredShape = (SwingTextShape)normedAndCenteredShape.createTransformedShape(AffineTransform.getRotateInstance((double)1.5707963267948966));
        }
        this.normedAndCenteredShape = normedAndCenteredShape;
        this.hierarchicalBoundingBoxes = new HierarchicalBoundingBoxes((Shape)normedAndCenteredShape, nSubdivisions, 1.25);
    }

    public boolean intersects(Word otherWord) {
        return this.hierarchicalBoundingBoxes.intersects(((SwingWord)otherWord).hierarchicalBoundingBoxes);
    }

    public double getSize() {
        return this.size;
    }

    public String getText() {
        return this.text;
    }

    public MutableTreeMapNode getTreeMapNode() {
        return this.treeMapNode;
    }

    public int compareTo(Word anotherWord) {
        return Double.valueOf(this.size).compareTo(((SwingWord)anotherWord).getSize());
    }

    public void setLocation(double xPos, double yPos) {
        this.location.set(xPos, yPos);
        this.hierarchicalBoundingBoxes.setTranslation(xPos, yPos);
    }

    public TextShape getShapeForLayout() {
        return (TextShape)this.normedAndCenteredShape.createTransformedShape(AffineTransform.getTranslateInstance((double)this.location.x, (double)this.location.y));
    }

    public void setLocation(Point2d position) {
        this.setLocation(position.x, position.y);
    }

    public String toString() {
        return "Word{text='" + this.text + '\'' + ", size=" + this.size + ", child=" + this.treeMapNode + ", location=" + this.location + ", normedAndCenteredShape=" + this.normedAndCenteredShape + ", hierarchicalBoundingBoxes=" + this.hierarchicalBoundingBoxes + '}';
    }
}

