/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.treeplot;

import com.macrofocus.common.interval.MutableBoundedInterval;
import com.treemap.treeplot.TreePlotModel;
import com.treemap.treeplot.TreePlotView;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

class DrillUpAction<N, Row, Column>
extends AbstractAction {
    private final TreePlotView<JComponent, N, Row, Column, Color, Font> _view;

    public DrillUpAction(TreePlotView<JComponent, N, Row, Column, Color, Font> view) {
        super("Drill Up");
        this._view = view;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreePlotModel model = this._view.getModel();
        model.getProbing().clearSelection();
        if (!model.isRoot(model.getCurrentRoot())) {
            MutableBoundedInterval xRangeModel = this._view.getXRangeModel();
            MutableBoundedInterval yRangeModel = this._view.getYRangeModel();
            this._view.zoom(xRangeModel.getMinimum(), xRangeModel.getMaximum(), yRangeModel.getMinimum(), yRangeModel.getMaximum());
            Object root = model.getParent(model.getCurrentRoot());
            model.setCurrentRoot(root);
        }
    }
}

