/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.venn;

import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import com.treemap.swing.venn.Sets;
import edu.uic.ncdm.venn.VennAnalytic;
import edu.uic.ncdm.venn.VennDiagram;
import edu.uic.ncdm.venn.data.VennData;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class VennAlgorithm<N, Row, Column, Color, Font>
extends AbstractAlgorithm<N, Row, Column, Color, Font> {
    private TreeMapModel<MutableTreeMapNode, ?, ?, Color, Font> model;
    private final int maxSize;

    public VennAlgorithm() {
        this(5);
    }

    public VennAlgorithm(int maxSize) {
        this.maxSize = maxSize;
    }

    public void startLayout(com.macrofocus.geom.Rectangle2D bounds, TreeMapModel<N, Row, Column, Color, Font> model, N root, TreeMapWorker worker) {
        this.model = model;
        super.startLayout(bounds, model, root, worker);
    }

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        int i;
        int length = Math.min(this.maxSize, children.length);
        LinkedHashSet<MutableTreeMapNode> set = new LinkedHashSet<MutableTreeMapNode>();
        for (int i2 = 0; i2 < length; ++i2) {
            MutableTreeMapNode a = children[i2];
            set.add(a);
        }
        Set powerSet = Sets.powerSet(set);
        int matrixSize = powerSet.size() - 1;
        String[][] data = new String[matrixSize][1];
        double[] areas = new double[matrixSize];
        LinkedHashMap<Set<MutableTreeMapNode>, Double> intersectionArea = new LinkedHashMap<Set<MutableTreeMapNode>, Double>();
        for (Set intersection : powerSet) {
            if (intersection.isEmpty()) continue;
            System.err.println(intersection);
            intersectionArea.put(intersection, 0.0);
        }
        for (Set intersection : powerSet) {
            boolean found;
            ArrayList<MutableTreeMapNode> toRemove;
            if (intersection.isEmpty()) continue;
            HashSet<MutableTreeMapNode> industries = null;
            for (MutableTreeMapNode node : intersection) {
                if (industries != null) continue;
                industries = new HashSet<MutableTreeMapNode>();
                for (MutableTreeMapNode industry : this.model.getChildren((Object)node)) {
                    industries.add(industry);
                }
            }
            for (MutableTreeMapNode country : intersection) {
                boolean allFound = true;
                toRemove = new ArrayList<MutableTreeMapNode>();
                for (MutableTreeMapNode industry : industries) {
                    found = false;
                    for (MutableTreeMapNode child : this.model.getChildren((Object)country)) {
                        if (!child.toString().equals(industry.toString())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    toRemove.add(industry);
                }
                for (MutableTreeMapNode mutableTreeMapNode : toRemove) {
                    industries.remove(mutableTreeMapNode);
                }
            }
            for (MutableTreeMapNode country : set) {
                if (intersection.contains(country)) continue;
                boolean allFound = true;
                toRemove = new ArrayList();
                for (MutableTreeMapNode industry : industries) {
                    found = false;
                    for (MutableTreeMapNode child : this.model.getChildren((Object)country)) {
                        if (!child.toString().equals(industry.toString())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    toRemove.add(industry);
                }
                for (MutableTreeMapNode mutableTreeMapNode : toRemove) {
                    industries.remove(mutableTreeMapNode);
                }
            }
            if (industries.isEmpty()) continue;
            for (MutableTreeMapNode industry : industries) {
                this.distribute(intersectionArea, intersection, industry, 0.0);
            }
        }
        int row = 0;
        for (Set key : intersectionArea.keySet()) {
            String inter = null;
            for (MutableTreeMapNode treeMapNode : key) {
                if (inter == null) {
                    inter = treeMapNode.toString();
                    continue;
                }
                inter = inter + "&" + treeMapNode.toString();
            }
            data[row][0] = inter;
            areas[row] = (Double)intersectionArea.get(key);
            System.out.println(inter + ":  " + areas[row]);
            ++row;
        }
        VennData vennData = new VennData(data, areas, true);
        VennAnalytic vennAnalytic = new VennAnalytic();
        vennAnalytic.computeInitialConfiguration();
        VennDiagram vennDiagram = vennAnalytic.compute(vennData);
        com.macrofocus.geom.Rectangle2D bounds2D = shape.getBounds2D();
        double size = Math.min(bounds2D.getWidth(), bounds2D.getHeight()) - 1.0;
        RectangularShape bounds = null;
        for (i = 0; i < length; ++i) {
            double radius = vennDiagram.diameters[i] / 2.0;
            double x = vennDiagram.centers[i][0] - radius;
            double y = vennDiagram.centers[i][1] - radius;
            Rectangle2D.Double b = new Rectangle2D.Double(x, y, vennDiagram.diameters[i], vennDiagram.diameters[i]);
            if (bounds == null) {
                bounds = b;
                continue;
            }
            ((Rectangle2D)bounds).add(b);
        }
        for (i = 0; i < length; ++i) {
            MutableTreeMapNode child = children[i];
            double radius = vennDiagram.diameters[i] / 2.0;
            double scale = Math.max(bounds.getWidth(), bounds.getHeight());
            double x = (vennDiagram.centers[i][0] - radius - bounds.getX()) / scale;
            double y = (vennDiagram.centers[i][1] - radius - bounds.getY()) / scale;
            double scaledX = bounds2D.getX() + x * size;
            double scaledY = bounds2D.getY() + y * size;
            double width = vennDiagram.diameters[i] * size / scale;
            child.setShape((Shape)new Ellipse2D.Double(scaledX, scaledY, width, width));
        }
        System.err.println();
        System.err.println("Stress: " + new DecimalFormat("0.0000").format(vennDiagram.stress));
        return false;
    }

    private void distribute(Map<Set<MutableTreeMapNode>, Double> intersectionArea, Set<MutableTreeMapNode> intersection, MutableTreeMapNode industry, double alreadyDistributed) {
        double commonArea = 0.0;
        for (MutableTreeMapNode country : intersection) {
            MutableTreeMapNode child = VennAlgorithm.findChild(this.model, country, industry.toString());
            if (commonArea > 0.0) {
                commonArea = Math.min(commonArea, child.getSize() - alreadyDistributed);
                continue;
            }
            commonArea = child.getSize() - alreadyDistributed;
        }
        if (!intersectionArea.containsKey(intersection)) {
            throw new IllegalStateException();
        }
        intersectionArea.put(intersection, intersectionArea.get(intersection) + commonArea);
        LinkedHashSet<MutableTreeMapNode> up = new LinkedHashSet<MutableTreeMapNode>(intersection);
        for (MutableTreeMapNode country : intersection) {
            MutableTreeMapNode child = VennAlgorithm.findChild(this.model, country, industry.toString());
            if (!(child.getSize() - alreadyDistributed <= commonArea)) continue;
            up.remove(country);
        }
        if (!up.isEmpty()) {
            this.distribute(intersectionArea, up, industry, alreadyDistributed + commonArea);
        }
    }

    private static <Color, Font> MutableTreeMapNode findChild(TreeMapModel<MutableTreeMapNode, ?, ?, Color, Font> model, MutableTreeMapNode parent, String name) {
        for (MutableTreeMapNode child : model.getChildren((Object)parent)) {
            if (!child.toString().equals(name)) continue;
            return child;
        }
        return null;
    }

    public boolean isCompatible(Shape shape) {
        return true;
    }
}

