/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi;

import com.treemap.swing.voronoi.smoothing.Direction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Path {
    private static final double ADJ_LEN = Math.sqrt(2.0) / 2.0 - 1.0;
    private final Direction[] directions;
    private final List<Direction> directionList;
    private final double length;
    private final int originX;
    private final int originY;
    private final int terminalX;
    private final int terminalY;

    private Path(Path that, int deltaX, int deltaY) {
        this.directions = that.directions;
        this.directionList = that.directionList;
        this.length = that.length;
        this.originX = that.originX + deltaX;
        this.originY = that.originY + deltaY;
        this.terminalX = that.terminalX + deltaX;
        this.terminalY = that.terminalY + deltaY;
    }

    private Path(int startX, int startY, Direction[] directions) {
        this.originX = startX;
        this.originY = startY;
        this.directions = (Direction[])directions.clone();
        this.directionList = Collections.unmodifiableList(Arrays.asList(directions));
        int endX = startX;
        int endY = startY;
        int diagonals = 0;
        for (Direction direction : directions) {
            endX += direction.screenX;
            endY += direction.screenY;
            if (direction.screenX == 0 || direction.screenY == 0) continue;
            ++diagonals;
        }
        this.terminalX = endX;
        this.terminalY = endY;
        this.length = (double)directions.length + (double)diagonals * ADJ_LEN;
    }

    public Path(int startX, int startY, List<Direction> directions) {
        this(startX, startY, directions.toArray(new Direction[directions.size()]));
    }

    public List<Direction> getDirections() {
        return this.directionList;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getTerminalX() {
        return this.terminalX;
    }

    public int getTerminalY() {
        return this.terminalY;
    }

    public double getLength() {
        return this.length;
    }

    public boolean isClosed() {
        return this.originX == this.terminalX && this.originY == this.terminalY;
    }

    public Path translate(int deltaX, int deltaY) {
        return new Path(this, deltaX, deltaY);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path that = (Path)obj;
        if (this.originX != that.originX) {
            return false;
        }
        if (this.originY != that.originY) {
            return false;
        }
        if (this.terminalX != that.terminalX) {
            return false;
        }
        if (this.terminalY != that.terminalY) {
            return false;
        }
        return Arrays.equals((Object[])this.directions, (Object[])that.directions);
    }

    public int hashCode() {
        return this.originX ^ 7 * this.originY ^ this.directions.hashCode();
    }

    public String toString() {
        return "X: " + this.originX + ", Y: " + this.originY + ' ' + Arrays.toString((Object[])this.directions);
    }
}

