/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.treemap.MutableTreeMapNode;
import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.Point2i;
import com.treemap.swing.voronoi.VoronoiCell;
import com.treemap.swing.voronoi.smoothing.CellWithLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Vertex {
    private final Point2d location = new Point2d();
    private final List<Point2i> adjacentPixels = new ArrayList<Point2i>(8);
    private final List<VoronoiCell> adjacentCells = new ArrayList<VoronoiCell>(4);
    private final List<MutableTreeMapNode> adjacentParents = new ArrayList<MutableTreeMapNode>(4);
    private final boolean touchingParentSpline;
    private final boolean isRectangleCorner;
    private final int id;
    private static int instanceCounter = 0;
    private final boolean vertexOfParentSegment;

    public Vertex(double x, double y, boolean touchingParentSpline, boolean isRectangleCorner, boolean vertexOfParentSegment) {
        this.location.x = x;
        this.location.y = y;
        this.id = instanceCounter++;
        this.touchingParentSpline = touchingParentSpline;
        this.isRectangleCorner = isRectangleCorner;
        this.vertexOfParentSegment = vertexOfParentSegment;
    }

    public Vertex(double x, double y, boolean touchingParentSpline) {
        this(x, y, touchingParentSpline, false, false);
    }

    public Vertex(Vertex vertex, boolean vertexOfParentSegment) {
        this(vertex.location.x, vertex.location.y, vertexOfParentSegment, false, vertexOfParentSegment);
        this.adjacentPixels.addAll(vertex.adjacentPixels);
        this.adjacentCells.addAll(vertex.adjacentCells);
        this.adjacentParents.addAll(vertex.adjacentParents);
    }

    public void addAdjacentCellPixel(VoronoiCell cell, int x, int y) {
        this.adjacentPixels.add(new Point2i(x, y));
        this.adjacentCells.add(cell);
    }

    public void addAdjacentCellPixel(VoronoiCell cell, Point2i postion) {
        this.addAdjacentCellPixel(cell, postion.x, postion.y);
    }

    public void addAdjacentCellPixel(CellWithLocation cellWithLocation) {
        this.addAdjacentCellPixel(cellWithLocation.getCell(), cellWithLocation.getLocation());
    }

    public boolean isPixelNextToCorner(int x, int y) {
        for (Point2i adjacentPixel : this.adjacentPixels) {
            if (adjacentPixel.x != x || adjacentPixel.y != y) continue;
            return true;
        }
        return false;
    }

    public Point2d getLocation() {
        return this.location;
    }

    public List<VoronoiCell> getAdjacentCells() {
        return Collections.unmodifiableList(this.adjacentCells);
    }

    public boolean isTouchingParentSpline() {
        return this.touchingParentSpline;
    }

    public boolean isRectangleCorner() {
        return this.isRectangleCorner;
    }

    public boolean isVertexOfParentSegment() {
        return this.vertexOfParentSegment;
    }

    public String toString() {
        String str = "Vertex ID " + this.id + "{location= (" + this.location.x + "/" + this.location.y + ")" + '}';
        if (this.touchingParentSpline) {
            str = str + " (touching parent spline)";
        }
        return str;
    }

    public boolean isPixelNextToCorner(Point2d point) {
        return this.isPixelNextToCorner((int)point.x, (int)point.y);
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Vertex)) {
            return false;
        }
        Point2d otherLocation = ((Vertex)other).location;
        return this.location.equals(otherLocation);
    }
}

