/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import org.json.Kim;
import org.json.zip.JSONzip;
import org.json.zip.Keep;
import org.json.zip.PostMortem;

class TrieKeep
extends Keep {
    private int[] froms;
    private int[] thrus;
    private Node root;
    private Kim[] kims;

    public TrieKeep(int n) {
        super(n);
        this.froms = new int[this.capacity];
        this.thrus = new int[this.capacity];
        this.kims = new Kim[this.capacity];
        this.root = new Node();
    }

    public Kim kim(int n) {
        Kim kim = this.kims[n];
        int n2 = this.froms[n];
        int n3 = this.thrus[n];
        if (n2 != 0 || n3 != kim.length) {
            kim = new Kim(kim, n2, n3);
            this.froms[n] = 0;
            this.thrus[n] = kim.length;
            this.kims[n] = kim;
        }
        return kim;
    }

    public int length(int n) {
        return this.thrus[n] - this.froms[n];
    }

    public int match(Kim kim, int n, int n2) {
        Node node = this.root;
        int n3 = -1;
        for (int i = n; i < n2 && (node = node.get(kim.get(i))) != null; ++i) {
            if (node.integer != -1) {
                n3 = node.integer;
            }
            ++n;
        }
        return n3;
    }

    public boolean postMortem(PostMortem postMortem) {
        boolean bl = true;
        TrieKeep trieKeep = (TrieKeep)postMortem;
        if (this.length != trieKeep.length) {
            JSONzip.log("\nLength " + this.length + " <> " + trieKeep.length);
            return false;
        }
        if (this.capacity != trieKeep.capacity) {
            JSONzip.log("\nCapacity " + this.capacity + " <> " + trieKeep.capacity);
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            Kim kim;
            Kim kim2 = this.kim(i);
            if (kim2.equals(kim = trieKeep.kim(i))) continue;
            JSONzip.log("\n[" + i + "] " + kim2 + " <> " + kim);
            bl = false;
        }
        return bl && this.root.postMortem(trieKeep.root);
    }

    public void registerMany(Kim kim) {
        int n = kim.length;
        int n2 = this.capacity - this.length;
        if (n2 > 40) {
            n2 = 40;
        }
        int n3 = n - 2;
        for (int i = 0; i < n3; ++i) {
            int n4 = n - i;
            if (n4 > 10) {
                n4 = 10;
            }
            n4 += i;
            Node node = this.root;
            for (int j = i; j < n4; ++j) {
                Node node2 = node.vet(kim.get(j));
                if (node2.integer == -1 && j - i >= 2) {
                    node2.integer = this.length;
                    this.uses[this.length] = 1L;
                    this.kims[this.length] = kim;
                    this.froms[this.length] = i;
                    this.thrus[this.length] = j + 1;
                    ++this.length;
                    if (--n2 <= 0) {
                        return;
                    }
                }
                node = node2;
            }
        }
    }

    public void registerOne(Kim kim) {
        int n = this.registerOne(kim, 0, kim.length);
        if (n != -1) {
            this.kims[n] = kim;
        }
    }

    public int registerOne(Kim kim, int n, int n2) {
        if (this.length < this.capacity) {
            int n3;
            Node node = this.root;
            for (n3 = n; n3 < n2; ++n3) {
                node = node.vet(kim.get(n3));
            }
            if (node.integer == -1) {
                n3 = this.length++;
                node.integer = n3;
                this.uses[n3] = 1L;
                this.kims[n3] = kim;
                this.froms[n3] = n;
                this.thrus[n3] = n2;
                return n3;
            }
        }
        return -1;
    }

    public void reserve() {
        if (this.capacity - this.length < 40) {
            int n = 0;
            this.root = new Node();
            for (int i = 0; i < this.capacity; ++i) {
                if (this.uses[i] <= 1L) continue;
                Kim kim = this.kims[i];
                int n2 = this.thrus[i];
                Node node = this.root;
                for (int j = this.froms[i]; j < n2; ++j) {
                    Node node2;
                    node = node2 = node.vet(kim.get(j));
                }
                node.integer = n;
                this.uses[n] = TrieKeep.age(this.uses[i]);
                this.froms[n] = this.froms[i];
                this.thrus[n] = n2;
                this.kims[n] = kim;
                ++n;
            }
            if (this.capacity - n < 40) {
                this.power = 0;
                this.root = new Node();
                n = 0;
            }
            this.length = n;
            while (n < this.capacity) {
                this.uses[n] = 0L;
                this.kims[n] = null;
                this.froms[n] = 0;
                this.thrus[n] = 0;
                ++n;
            }
        }
    }

    public Object value(int n) {
        return this.kim(n);
    }

    class Node
    implements PostMortem {
        private int integer = -1;
        private Node[] next = null;

        public Node get(int n) {
            return this.next == null ? null : this.next[n];
        }

        public Node get(byte by) {
            return this.get(by & 0xFF);
        }

        public boolean postMortem(PostMortem postMortem) {
            Node node = (Node)postMortem;
            if (node == null) {
                JSONzip.log("\nMisalign");
                return false;
            }
            if (this.integer != node.integer) {
                JSONzip.log("\nInteger " + this.integer + " <> " + node.integer);
                return false;
            }
            if (this.next == null) {
                if (node.next == null) {
                    return true;
                }
                JSONzip.log("\nNext is null " + this.integer);
                return false;
            }
            for (int i = 0; i < 256; ++i) {
                Node node2 = this.next[i];
                if (node2 != null) {
                    if (node2.postMortem(node.next[i])) continue;
                    return false;
                }
                if (node.next[i] == null) continue;
                JSONzip.log("\nMisalign " + i);
                return false;
            }
            return true;
        }

        public void set(int n, Node node) {
            if (this.next == null) {
                this.next = new Node[256];
            }
            this.next[n] = node;
        }

        public void set(byte by, Node node) {
            this.set(by & 0xFF, node);
        }

        public Node vet(int n) {
            Node node = this.get(n);
            if (node == null) {
                node = new Node();
                this.set(n, node);
            }
            return node;
        }

        public Node vet(byte by) {
            return this.vet(by & 0xFF);
        }
    }
}

