/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.swing;

import com.macrofocus.palette.Palette;
import com.macrofocus.palette.PaletteEvent;
import com.macrofocus.palette.PaletteListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class SwingPaletteView
extends JComponent {
    private Type type = Type.Ramps;
    private Palette<Color> palette;
    protected final Border defaultBorder = BorderFactory.createEmptyBorder(1, 0, 1, 0);
    private PaletteListener listener = new PaletteListener(){

        public void paletteChanged(PaletteEvent event) {
            SwingPaletteView.this.repaint();
        }
    };

    public SwingPaletteView() {
        this.setBorder(this.defaultBorder);
        this.setPreferredSize(new Dimension(-1, 24));
    }

    public SwingPaletteView(Palette palette) {
        this();
        this.setPalette(palette);
    }

    public void setPalette(Palette palette) {
        if (this.palette != palette) {
            if (this.palette != null) {
                this.palette.removePaletteListener(this.listener);
            }
            this.palette = palette;
            if (this.palette != null) {
                this.palette.addPaletteListener(this.listener);
            }
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
        }
        if (this.palette != null) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            double width = size.width - insets.left - insets.right;
            switch (this.type) {
                case Bands: {
                    for (int i = 0; i < this.palette.getColorCount(); ++i) {
                        Color color = (Color)this.palette.getColorAt(i).getNativeColor();
                        int x1 = insets.left + (int)(width * (double)i / (double)this.palette.getColorCount());
                        int x2 = insets.left + (int)(width * (double)(i + 1) / (double)this.palette.getColorCount());
                        g.setColor(color);
                        g.fillRect(x1, insets.top, x2 - x1 + 1, size.height - insets.top - insets.bottom);
                    }
                    break;
                }
                case Ramps: {
                    int colorCount = 256;
                    for (int i = 0; i < 256; ++i) {
                        Color color = (Color)this.palette.getColor((double)i / 255.0).getNativeColor();
                        int x1 = insets.left + (int)(width * (double)i / 256.0);
                        int x2 = insets.left + (int)(width * (double)(i + 1) / 256.0);
                        g.setColor(color);
                        g.fillRect(x1, insets.top, x2 - x1 + 1, size.height - insets.top - insets.bottom);
                    }
                    break;
                }
            }
        }
    }

    public static enum Type {
        Ramps,
        Bands;

    }
}

