/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import java.awt.Color;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ColorComboBoxModel
extends DefaultComboBoxModel<Color> {
    public ColorComboBoxModel(MutableSingleSelection<CPColor<Color>> selection) {
        this.init(selection);
    }

    public ColorComboBoxModel(MutableProperty<CPColor<Color>> selection) {
        this.init(selection);
    }

    private void init(final MutableSingleSelection<CPColor<Color>> selection) {
        selection.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<CPColor<Color>>(){

            public void selectionChanged(SingleSelectionEvent<CPColor<Color>> event) {
                CPColor selected = (CPColor)event.getCurrentSelection();
                ColorComboBoxModel.this.setSelectedItem(selected != null ? selected.getNativeColor() : null);
            }
        });
        CPColor selected = (CPColor)selection.getSelected();
        this.setSelectedItem(selected != null ? selected.getNativeColor() : null);
        this.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Color selectedItem = (Color)ColorComboBoxModel.this.getSelectedItem();
                selection.setSelected((Object)(selectedItem != null ? new SwingColor(selectedItem) : null));
            }
        });
    }

    private void init(final MutableProperty<CPColor<Color>> property) {
        property.addPropertyListener((PropertyListener)new PropertyListener<CPColor<Color>>(){

            public void propertyChanged(PropertyEvent<CPColor<Color>> event) {
                CPColor selected = (CPColor)event.getNewValue();
                ColorComboBoxModel.this.setSelectedItem(selected != null ? selected.getNativeColor() : null);
            }
        });
        CPColor selected = (CPColor)property.getValue();
        this.setSelectedItem(selected != null ? selected.getNativeColor() : null);
        this.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Color selectedItem = (Color)ColorComboBoxModel.this.getSelectedItem();
                property.setValue((Object)(selectedItem != null ? new SwingColor(selectedItem) : null));
            }
        });
    }
}

