/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.common.collection.PluggableCollectionFactory;
import com.macrofocus.crossplatform.AbstractCanvas;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingCanvasHandler;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.crossplatform.swing.layer.AveragingSwingLayer;
import com.macrofocus.crossplatform.swing.layer.BufferedSwingLayer;
import com.macrofocus.crossplatform.swing.layer.DensitySwingLayer;
import com.macrofocus.crossplatform.swing.layer.DirectSwingLayer;
import com.macrofocus.crossplatform.swing.layer.SwingLayer;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.GraphicsContextDrawing;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IDrawingListener;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.pressure.Pressure;
import com.macrofocus.igraphics.swing.SwingIGraphics;
import com.macrofocus.igraphics.swing.SwingITiming;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SwingCanvas
extends AbstractCanvas<JComponent> {
    private final List<SwingLayer> layers = PluggableCollectionFactory.getInstance().copyOnWriteArrayList();
    private final Map<IDrawing, IDrawingListener> drawings = PluggableCollectionFactory.getInstance().concurrentHashMap();
    private final CanvasComponent canvas;
    private final SwingCanvasHandler handler;
    private SwingITiming prepareTiming = new SwingITiming("Prepare");
    private SwingITiming renderTiming = new SwingITiming("Render");

    protected SwingCanvas() {
        this.canvas = new CanvasComponent();
        this.handler = new SwingCanvasHandler(this.canvas);
        this.updateColorTheme();
    }

    public IGraphics getIGraphics() {
        return new SwingIGraphics((Graphics2D)this.canvas.getGraphics());
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass(this, styleClasses);
    }

    public void updateColorTheme() {
    }

    public void addLayer(GraphicsContextDrawing drawing) {
        throw new UnsupportedOperationException();
    }

    public void addDensityLayer(CPCanvas.Rendering rendering, IDrawing iDrawing, Pressure pressure, CPCanvas.PaletteProvider paletteProvider) {
        SwingLayer layer;
        switch (rendering) {
            case Density: {
                layer = new DensitySwingLayer(iDrawing, 0, 0, true, pressure, paletteProvider);
                this.layers.add(layer);
                break;
            }
            case AlphaBlended: {
                float alpha = 0.5f;
                layer = new BufferedSwingLayer(iDrawing, true, (CPColor<Color>)paletteProvider.getPalette().getColor(1.0), AlphaComposite.getInstance(3, alpha));
                this.layers.add(layer);
                break;
            }
            case Opaque: {
                layer = new BufferedSwingLayer(iDrawing, true, (CPColor<Color>)paletteProvider.getPalette().getColor(1.0), null);
                this.layers.add(layer);
                break;
            }
            case Print: {
                layer = new DirectSwingLayer(iDrawing, (CPColor<Color>)paletteProvider.getPalette().getColor(1.0));
                this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(){

            public void iDrawingChanged() {
                SwingCanvas.this.canvas.schedulePrepare(layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addAveragingLayer(CPCanvas.Rendering rendering, IDrawing iDrawing) {
        SwingLayer layer;
        switch (rendering) {
            case Density: {
                layer = new AveragingSwingLayer(iDrawing, true);
                this.layers.add(layer);
                break;
            }
            case AlphaBlended: {
                layer = new BufferedSwingLayer(iDrawing, true);
                this.layers.add(layer);
                break;
            }
            case Opaque: {
                layer = new BufferedSwingLayer(iDrawing, true);
                this.layers.add(layer);
                break;
            }
            case Print: {
                layer = new DirectSwingLayer(iDrawing);
                this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(){

            public void iDrawingChanged() {
                SwingCanvas.this.canvas.schedulePrepare(layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addLayer(IDrawing iDrawing) {
        DirectSwingLayer layer = new DirectSwingLayer(iDrawing);
        this.layers.add(layer);
        this.registerDrawing(iDrawing, new IDrawingListener(){

            public void iDrawingChanged() {
                SwingCanvas.this.canvas.scheduleRender();
            }
        });
        this.canvas.scheduleRender();
    }

    public void addBufferedLayer(IDrawing iDrawing) {
        final BufferedSwingLayer layer = new BufferedSwingLayer(iDrawing, true);
        this.layers.add(layer);
        this.registerDrawing(iDrawing, new IDrawingListener(){

            public void iDrawingChanged() {
                SwingCanvas.this.canvas.schedulePrepare(layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    private void registerDrawing(IDrawing drawing, IDrawingListener listener) {
        this.drawings.put(drawing, listener);
        drawing.addIDrawingListener(listener);
    }

    public void removeAllLayers() {
        this.layers.clear();
        for (Map.Entry<IDrawing, IDrawingListener> entry : this.drawings.entrySet()) {
            entry.getKey().removeIDrawingListener(entry.getValue());
        }
        this.drawings.clear();
    }

    public double getWidth() {
        return this.canvas.getWidth();
    }

    public double getHeight() {
        return this.canvas.getHeight();
    }

    public void refresh() {
        this.canvas.schedulePrepare();
    }

    public void repaint() {
        this.canvas.scheduleRender();
    }

    public JComponent getNativeComponent() {
        return this.canvas;
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.handler.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.handler.addMouseMotionListener(l);
    }

    public void addMouseWheelListener(CPCanvas.MouseWheelListener l) {
        this.handler.addMouseWheelListener(l);
    }

    public void addKeyListener(CPCanvas.KeyListener l) {
        this.handler.addKeyListener(l);
    }

    public void addContextMenuListener(CPCanvas.ContextMenuListener l) {
        this.handler.addContextMenuListener(l);
    }

    private class CanvasComponent
    extends JPanel {
        private final Set<SwingLayer> dirtyLayers = new HashSet<SwingLayer>();
        protected final CPTimer timer = SwingFactory.getInstance().createTimer("Canvas$Prepare", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                CanvasComponent.this.prepare();
            }
        });

        private CanvasComponent() {
            this.setOpaque(false);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingCanvas.this.notifySizeChanged(CanvasComponent.this.getWidth(), CanvasComponent.this.getHeight());
                    CanvasComponent.this.schedulePrepare();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        SwingCanvas.this.notifySizeChanged(CanvasComponent.this.getWidth(), CanvasComponent.this.getHeight());
                        CanvasComponent.this.schedulePrepare();
                    }
                }
            });
            this.updateUI();
        }

        @Override
        public void updateUI() {
            this.setBackground(null);
            super.updateUI();
            SwingCanvas.this.updateColorTheme();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void schedulePrepare(SwingLayer layer) {
            Set<SwingLayer> set = this.dirtyLayers;
            synchronized (set) {
                this.dirtyLayers.add(layer);
            }
            if (this.isShowing()) {
                this.timer.restart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void schedulePrepare() {
            for (SwingLayer layer : SwingCanvas.this.layers) {
                Set<SwingLayer> set = this.dirtyLayers;
                synchronized (set) {
                    this.dirtyLayers.add(layer);
                }
            }
            if (this.isShowing()) {
                this.timer.restart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepare() {
            ArrayList<SwingLayer> dirtyLayers;
            SwingCanvas.this.prepareTiming.start();
            int width = this.getWidth();
            int height = this.getHeight();
            Set<SwingLayer> set = this.dirtyLayers;
            synchronized (set) {
                dirtyLayers = new ArrayList<SwingLayer>(this.dirtyLayers);
                this.dirtyLayers.clear();
            }
            for (SwingLayer layer : dirtyLayers) {
                layer.prepare(width, height);
            }
            SwingCanvas.this.prepareTiming.end();
            this.scheduleRender();
        }

        public void scheduleRender() {
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            SwingCanvas.this.renderTiming.start();
            if (this.isPaintingForPrint()) {
                this.prepare();
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setFont(this.getFont());
            for (SwingLayer layer : SwingCanvas.this.layers) {
                layer.render(g2);
            }
            double width = this.getWidth();
            double height = this.getHeight();
            SwingCanvas.this.renderTiming.end();
            if (SwingCanvas.this.isShowTiming()) {
                SwingCanvas.this.prepareTiming.draw(g2, new Dimension((int)width, (int)height), 32);
                SwingCanvas.this.renderTiming.draw(g2, new Dimension((int)width, (int)height), 16);
            }
        }
    }
}

