/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.labeling;

import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.swing.SwingFont;
import com.macrofocus.labeling.EnhancedLabel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class EnhancedJLabel
extends JLabel {
    protected EnhancedLabel<Color, Font> data;
    protected boolean useSwingPaintText = false;
    private PropertiesListener propertiesListener;

    public EnhancedJLabel(String text) {
        this();
        this.setText(text);
    }

    public EnhancedJLabel(EnhancedLabel<Color, Font> data) {
        this.setUI(new EnhancedLabelUI());
        this.setData(data);
    }

    public EnhancedJLabel() {
        this((EnhancedLabel<Color, Font>)new EnhancedLabel());
        this.setUI(new EnhancedLabelUI());
    }

    public Dimension getMinimumSize(Graphics2D g2) {
        return ((EnhancedLabelUI)this.ui).getMinimumSize(g2, this);
    }

    public Dimension getPreferredSize(Graphics2D g2) {
        return ((EnhancedLabelUI)this.ui).getPreferredSize(g2, this);
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    public void setData(EnhancedLabel<Color, Font> data) {
        this.unregisterListener(this.data);
        this.data = data;
        if (data.isHTML()) {
            super.setText(this.addTag(data.getText()));
        } else {
            super.setText(data.getText());
        }
        super.setVerticalAlignment(data.getVerticalAlignment());
        super.setHorizontalAlignment(data.getHorizontalAlignment());
        if (data.getFont() != null) {
            super.setFont((Font)data.getFont().getNativeFont());
        }
        if (data.getForeground() != null) {
            super.setForeground((Color)data.getForeground().getNativeColor());
        }
        if (data.getBackground() != null) {
            super.setBackground((Color)data.getBackground().getNativeColor());
        }
        super.setBorder(BorderFactory.createEmptyBorder(data.getInsetTop(), data.getInsetLeft(), data.getInsetBottom(), data.getInsetRight()));
        this.registerListener(data);
    }

    public String addTag(String value) {
        if (value != null) {
            if (!value.startsWith("<html>")) {
                return "<html>" + value + "</html>";
            }
            return value;
        }
        return null;
    }

    protected void unregisterListener(EnhancedLabel<Color, Font> data) {
        if (this.data != null) {
            data.getProperties().removePropertiesListener(this.propertiesListener);
        }
    }

    protected void registerListener(EnhancedLabel<Color, Font> data) {
        if (this.propertiesListener == null) {
            this.propertiesListener = new PropertiesListener(){

                public void propertyChanged(Object name, PropertyEvent event) {
                    EnhancedJLabel.this.repaint();
                }
            };
        }
        data.getProperties().addWeakPropertiesListener(this.propertiesListener);
    }

    public void setEffect(EnhancedLabel.Effect effect) {
        this.data.setEffect(effect);
    }

    public float getEffectOpacity() {
        return this.data.getEffectOpacity();
    }

    public void setEffectOpacity(float effectOpacity) {
        this.data.getEffectOpacity();
    }

    public EnhancedLabel.Rendering getRendering() {
        return this.data.getRendering();
    }

    public void setRendering(EnhancedLabel.Rendering rendering) {
        this.data.setRendering(rendering);
    }

    public Integer getMinimumCharactersToDisplay() {
        return this.data.getMinimumCharactersToDisplay();
    }

    public void setMinimumCharactersToDisplay(Integer minimumCharactersToDisplay) {
        this.data.getMinimumCharactersToDisplay();
    }

    public boolean isJustified() {
        return this.data.isJustified();
    }

    public void setJustified(boolean justified) {
        this.data.setJustified(justified);
    }

    public double getAngle() {
        return this.data.getAngle();
    }

    public void setAngle(double angle) {
        this.data.setAngle(angle);
    }

    @Override
    public Font getFont() {
        if (this.data != null && this.data.getFont() != null) {
            return (Font)this.data.getFont().getNativeFont();
        }
        return super.getFont();
    }

    @Override
    public void setFont(Font font) {
        Font oldFont = this.getFont();
        if (this.data != null) {
            this.data.setFont((CPFont)new SwingFont(font));
        } else {
            super.setFont(font);
        }
        this.firePropertyChange("font", oldFont, font);
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getMaximumSize();
    }

    public Dimension getDesiredSize() {
        return new Dimension(this.data.getDesiredWidth(), this.data.getDesiredWidth());
    }

    public void setDesiredSize(Dimension desiredSize) {
        this.data.setDesiredWidth(Integer.valueOf(desiredSize.width));
        this.data.setDesiredHeight(Integer.valueOf(desiredSize.height));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("EnhancedJLabel");
        frame.setSize(new Dimension(600, 600));
        frame.getContentPane().setLayout(new BorderLayout());
        final EnhancedJLabel label = new EnhancedJLabel();
        label.setText("This is a test");
        label.setFont(label.getFont().deriveFont(72.0f));
        label.setEffect(EnhancedLabel.Effect.Shadow);
        label.setBackground(Color.yellow);
        label.setRendering(EnhancedLabel.Rendering.Truncate);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(0);
        label.setIconTextGap(0);
        frame.getContentPane().add((Component)label, "Center");
        System.err.println(label.getIconTextGap());
        frame.setVisible(true);
        Timer timer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                label.setAngle((label.getAngle() + 1.0) % 360.0);
            }
        });
        timer.start();
    }

    protected class EnhancedLabelUI
    extends BasicLabelUI {
        private final Rectangle paintIconR = new Rectangle();
        private final Rectangle paintTextR = new Rectangle();

        protected EnhancedLabelUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Graphics2D g2 = (Graphics2D)g;
            JLabel label = (JLabel)c;
            switch (EnhancedJLabel.this.getRendering()) {
                case WordWrap: {
                    int y;
                    if (label.getVerticalAlignment() != 1) {
                        Dimension d = this.getPreferredSize(g, c);
                        switch (label.getVerticalAlignment()) {
                            case 0: {
                                y = Math.max(0, (c.getHeight() - d.height) / 2);
                                break;
                            }
                            case 3: {
                                y = Math.max(0, c.getHeight() - d.height);
                                break;
                            }
                            default: {
                                y = 0;
                                break;
                            }
                        }
                    } else {
                        y = 0;
                    }
                    g2.setFont(EnhancedJLabel.this.getFont());
                    this.paintWordWrapText(label, g2, g2.getFontMetrics(), EnhancedJLabel.this.getText(), EnhancedJLabel.this.getDesiredSize().width, y, label.getForeground(), label.getBackground());
                    break;
                }
                default: {
                    Icon icon;
                    switch (label.getHorizontalAlignment()) {
                        default: {
                            break;
                        }
                        case 0: {
                        }
                        case 4: 
                        case 11: 
                    }
                    switch (label.getVerticalAlignment()) {
                        default: {
                            break;
                        }
                        case 0: {
                        }
                        case 3: 
                    }
                    String text = label.getText();
                    Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
                    if (icon == null && text == null) {
                        return;
                    }
                    FontMetrics fm = label.getFontMetrics(g2.getFont());
                    int width = c.getWidth();
                    int height = c.getHeight();
                    String clippedText = this.layout(label, fm, width, height);
                    if (EnhancedJLabel.this.getAngle() != 0.0) {
                        g2.rotate(Math.PI * EnhancedJLabel.this.getAngle() / 180.0, this.paintTextR.getCenterX(), this.paintTextR.getCenterY());
                    }
                    if (icon != null) {
                        icon.paintIcon(c, g2, this.paintIconR.x, this.paintIconR.y);
                    }
                    if (clippedText == null) break;
                    View v = (View)c.getClientProperty("html");
                    if (v != null) {
                        v.paint(g2, this.paintTextR);
                        break;
                    }
                    int textX = this.paintTextR.x;
                    int textY = this.paintTextR.y + fm.getAscent();
                    if (label.isEnabled()) {
                        this.paintEnabledText(label, g2, clippedText, textX, textY);
                        break;
                    }
                    this.paintDisabledText(label, g2, clippedText, textX, textY);
                }
            }
        }

        protected String layout(JLabel label, FontMetrics fm, int width, int height) {
            Insets insets = label.getInsets(null);
            String text = label.getText();
            Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            Rectangle paintViewR = new Rectangle();
            paintViewR.x = insets.left;
            paintViewR.y = insets.top;
            paintViewR.width = width - (insets.left + insets.right);
            paintViewR.height = height - (insets.top + insets.bottom);
            this.paintIconR.height = 0;
            this.paintIconR.width = 0;
            this.paintIconR.y = 0;
            this.paintIconR.x = 0;
            this.paintTextR.height = 0;
            this.paintTextR.width = 0;
            this.paintTextR.y = 0;
            this.paintTextR.x = 0;
            return this.layoutCL(label, fm, text, icon, paintViewR, this.paintIconR, this.paintTextR);
        }

        public Dimension getMinimumSize(Graphics g, JComponent c) {
            switch (EnhancedJLabel.this.getRendering()) {
                case WordWrap: {
                    Graphics2D g2 = (Graphics2D)g;
                    EnhancedJLabel label = (EnhancedJLabel)c;
                    g2.setFont(EnhancedJLabel.this.getFont());
                    FontMetrics fontMetrics = g2.getFontMetrics(EnhancedJLabel.this.getFont());
                    Dimension d = this.paintWordWrapText(label, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                    return new Dimension(d.width, fontMetrics.getHeight());
                }
            }
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            switch (EnhancedJLabel.this.getRendering()) {
                case WordWrap: {
                    EnhancedJLabel label = (EnhancedJLabel)c;
                    Dimension d = this.paintWordWrapText(label, null, label.getFontMetrics(label.getFont()), EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                    return new Dimension(d.width, EnhancedJLabel.this.getFontMetrics(EnhancedJLabel.this.getFont()).getHeight());
                }
            }
            return this.getPreferredSize(c);
        }

        public Dimension getPreferredSize(Graphics g, JComponent c) {
            Dimension size;
            Insets insets = EnhancedJLabel.this.getInsets();
            switch (EnhancedJLabel.this.getRendering()) {
                case WordWrap: {
                    Graphics2D g2 = (Graphics2D)g;
                    EnhancedJLabel label = (EnhancedJLabel)c;
                    g2.setFont(EnhancedJLabel.this.getFont());
                    Dimension d = this.paintWordWrapText(label, null, g2.getFontMetrics(EnhancedJLabel.this.getFont()), EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                    size = new Dimension(d.width, d.height);
                    break;
                }
                default: {
                    if (EnhancedJLabel.this.getAngle() != 0.0) {
                        Dimension d = this.getRotatedDimension(super.getPreferredSize(c));
                        size = new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
                        break;
                    }
                    size = super.getPreferredSize(c);
                }
            }
            return size;
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Dimension size;
            Insets insets = EnhancedJLabel.this.getInsets();
            switch (EnhancedJLabel.this.getRendering()) {
                case WordWrap: {
                    EnhancedJLabel label = (EnhancedJLabel)c;
                    Dimension d = this.paintWordWrapText(label, null, label.getFontMetrics(label.getFont()), EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                    size = new Dimension(d.width, d.height);
                    break;
                }
                default: {
                    if (EnhancedJLabel.this.getAngle() != 0.0) {
                        Dimension d = this.getRotatedDimension(super.getPreferredSize(c));
                        size = new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
                        break;
                    }
                    size = super.getPreferredSize(c);
                }
            }
            return size;
        }

        private Dimension getRotatedDimension(Dimension dimension) {
            AffineTransform at = this.createAffineTransform(dimension);
            Rectangle rect = at.createTransformedShape(new Rectangle(dimension)).getBounds();
            return new Dimension(rect.width, rect.height);
        }

        private AffineTransform createAffineTransform(Dimension dimension) {
            AffineTransform at = new AffineTransform();
            at.rotate(Math.PI * EnhancedJLabel.this.getAngle() / 180.0, dimension.getWidth() / 2.0, dimension.getHeight() / 2.0);
            return at;
        }

        public Dimension getUnrotatedPreferredSize(JComponent c) {
            return super.getPreferredSize(c);
        }

        @Override
        protected void paintEnabledText(JLabel label, Graphics g, String text, int x, int y) {
            this.paintText(label, g, text, x, y, label.getForeground(), label.getBackground());
        }

        @Override
        protected void paintDisabledText(JLabel label, Graphics g, String text, int x, int y) {
            this.paintText(label, g, text, x, y, label.getForeground(), label.getBackground());
        }

        @Override
        protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
            boolean orientationIsLeftToRight = true;
            int hAlign = EnhancedJLabel.this.getHorizontalAlignment();
            int hTextPos = EnhancedJLabel.this.getHorizontalTextPosition();
            if (label != null && !label.getComponentOrientation().isLeftToRight()) {
                orientationIsLeftToRight = false;
            }
            switch (hAlign) {
                case 10: {
                    hAlign = orientationIsLeftToRight ? 2 : 4;
                    break;
                }
                case 11: {
                    hAlign = orientationIsLeftToRight ? 4 : 2;
                }
            }
            switch (hTextPos) {
                case 10: {
                    hTextPos = orientationIsLeftToRight ? 2 : 4;
                    break;
                }
                case 11: {
                    hTextPos = orientationIsLeftToRight ? 4 : 2;
                }
            }
            int availableWidth = viewR.width;
            int gap = 0;
            int rsb = 0;
            int lsb = 0;
            switch (EnhancedJLabel.this.getRendering()) {
                case Truncate: {
                    if (fontMetrics.stringWidth(text) > availableWidth) {
                        String nextString;
                        int textWidth;
                        String dots;
                        String truncatedString = dots = "\u2026";
                        for (int i = 1; i <= text.length() && (textWidth = fontMetrics.stringWidth(nextString = text.substring(0, i) + dots)) <= availableWidth; ++i) {
                            truncatedString = nextString;
                        }
                        text = truncatedString;
                    }
                }
                case Clip: {
                    View v;
                    if (text == null || EnhancedJLabel.this.getMinimumCharactersToDisplay() != null && fontMetrics.stringWidth(text.substring(0, Math.min(text.length(), EnhancedJLabel.this.getMinimumCharactersToDisplay() + 1))) > availableWidth) {
                        textR.height = 0;
                        textR.width = 0;
                        text = null;
                        break;
                    }
                    View view = v = label != null ? (View)label.getClientProperty("html") : null;
                    if (v != null) {
                        textR.width = Math.min(availableWidth, (int)v.getPreferredSpan(0));
                        textR.height = (int)v.getPreferredSpan(1);
                        break;
                    }
                    textR.width = Math.min(fontMetrics.stringWidth(text), availableWidth);
                    textR.height = fontMetrics.getHeight();
                }
            }
            textR.y = EnhancedJLabel.this.getVerticalTextPosition() == 1 ? (hTextPos != 0 ? 0 : -(textR.height + gap)) : (EnhancedJLabel.this.getVerticalTextPosition() == 0 ? iconR.height / 2 - textR.height / 2 : (hTextPos != 0 ? iconR.height - textR.height : iconR.height + gap));
            textR.x = hTextPos == 2 ? -(textR.width + gap) : (hTextPos == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
            int labelR_x = Math.min(iconR.x, textR.x);
            int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
            int labelR_y = Math.min(iconR.y, textR.y);
            int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
            int dy = EnhancedJLabel.this.getVerticalAlignment() == 1 ? viewR.y - labelR_y : (EnhancedJLabel.this.getVerticalAlignment() == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
            int dx = hAlign == 2 ? viewR.x - labelR_x : (hAlign == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
            textR.x += dx;
            textR.y += dy;
            iconR.x += dx;
            iconR.y += dy;
            if (lsb < 0) {
                textR.x -= lsb;
                textR.width += lsb;
            }
            if (rsb > 0) {
                textR.width -= rsb;
            }
            return text;
        }

        private void paintText(JLabel label, Graphics g, String text, int x, int y, Color foreground, Color background) {
            g.setColor(foreground);
            if (background != null) {
                g.translate(x, y);
                switch (EnhancedJLabel.this.data.getEffect()) {
                    case Shadow: {
                        this.paintTextShadow((Graphics2D)g, text, background == null ? foreground.brighter() : background);
                        break;
                    }
                    case Glow: {
                        this.paintTextGlow((Graphics2D)g, text, background == null ? foreground.brighter() : background);
                        break;
                    }
                    case Outline: {
                        this.paintTextGlow((Graphics2D)g, text, background == null ? foreground.brighter() : background);
                        break;
                    }
                    case Emphasize: {
                        this.paintTextEmphasize((Graphics2D)g, text, background == null ? foreground.brighter() : background);
                    }
                }
                g.translate(-x, -y);
            }
            if (EnhancedJLabel.this.useSwingPaintText) {
                super.paintEnabledText(label, g, text, x, y);
            } else if (text != null) {
                g.drawString(text, x, y);
            }
        }

        private Dimension paintWordWrapText(JLabel label, Graphics2D g, FontMetrics fontMetrics, String text, int desiredWidth, int yStart, Color foreground, Color background) {
            Insets insets = EnhancedJLabel.this.getInsets();
            int width = desiredWidth + (insets.left + insets.right);
            int noBorderWidth = desiredWidth;
            float w = insets.left + insets.right;
            float x = insets.left;
            float y = yStart + insets.top;
            if (noBorderWidth > 0 && text != null && text.length() > 0) {
                if (g != null) {
                    // empty if block
                }
                AttributedString as = new AttributedString(text);
                as.addAttribute(TextAttribute.FONT, EnhancedJLabel.this.getFont());
                as.addAttribute(TextAttribute.FOREGROUND, foreground);
                AttributedCharacterIterator aci = as.getIterator();
                FontRenderContext fontRenderContext = fontMetrics.getFontRenderContext();
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                LineBreakMeasurer lbm = new LineBreakMeasurer(aci, breakIterator, fontRenderContext);
                float max = 0.0f;
                try {
                    while (lbm.getPosition() < aci.getEndIndex()) {
                        TextLayout layout = lbm.nextLayout(noBorderWidth);
                        if (g != null && EnhancedJLabel.this.isJustified() && (double)layout.getVisibleAdvance() > 0.8 * (double)noBorderWidth) {
                            layout = layout.getJustifiedLayout(noBorderWidth);
                        }
                        float ascent = layout.getAscent();
                        float visibleAdvance = layout.getVisibleAdvance();
                        if (g != null) {
                            switch (label.getHorizontalAlignment()) {
                                default: {
                                    layout.draw(g, x, y + ascent);
                                    break;
                                }
                                case 0: {
                                    float leftMargin = insets.left;
                                    float rightMargin = EnhancedJLabel.this.getWidth() - insets.right;
                                    layout.draw(g, (leftMargin + rightMargin - visibleAdvance) / 2.0f, y + ascent);
                                    break;
                                }
                                case 4: 
                                case 11: {
                                    float rightMargin = EnhancedJLabel.this.getWidth() - insets.right;
                                    layout.draw(g, rightMargin - visibleAdvance, y + ascent);
                                }
                            }
                        }
                        float leading = layout.getLeading();
                        float descent = layout.getDescent();
                        y += descent + leading + ascent;
                        max = Math.max(max, visibleAdvance);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                w += max;
            }
            Dimension dimension = new Dimension((int)Math.ceil(w), (int)Math.ceil(y) + insets.bottom);
            return dimension;
        }

        private void paintEffect(Graphics2D g, String text, Color color, double x, double y) {
            if (text != null) {
                Object oldTextAAHint = g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                Composite oldComposite = g.getComposite();
                Color oldColor = g.getColor();
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setColor(color);
                g.translate(x, y);
                int additionalOffset = g.getFontMetrics().getHeight() / 32;
                switch (EnhancedJLabel.this.data.getEffect()) {
                    case Emphasize: {
                        int size1 = 1 + additionalOffset;
                        for (int j = 0; j < size1; ++j) {
                            double distance = j * j;
                            float alpha = EnhancedJLabel.this.getEffectOpacity();
                            if (distance > 0.0) {
                                alpha = (float)(0.5 / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                            }
                            if (alpha > 1.0f) {
                                alpha = 1.0f;
                            }
                            g.setComposite(AlphaComposite.getInstance(3, alpha));
                            g.drawString(text, 0, j);
                        }
                        break;
                    }
                    case Shadow: {
                        int size = 1 + additionalOffset;
                        for (int i = 0; i < size; ++i) {
                            for (int j = 0; j < size; ++j) {
                                double distance = i * i + j * j;
                                float alpha = EnhancedJLabel.this.getEffectOpacity();
                                if (distance > 0.0) {
                                    alpha = (float)(0.5 / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                                }
                                if (alpha > 1.0f) {
                                    alpha = 1.0f;
                                }
                                g.setComposite(AlphaComposite.getInstance(3, alpha));
                                g.drawString(text, i, j);
                            }
                        }
                        break;
                    }
                    case Glow: {
                        int size3 = 1 + additionalOffset;
                        for (int i = -size3; i <= size3; ++i) {
                            for (int j = -size3; j <= size3; ++j) {
                                double distance = i * i + j * j;
                                float alpha = EnhancedJLabel.this.getEffectOpacity();
                                if (!(distance > 0.0)) continue;
                                alpha = (float)(1.0 / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                                if (alpha > 1.0f) {
                                    alpha = 1.0f;
                                }
                                g.setComposite(AlphaComposite.getInstance(3, alpha));
                                g.drawString(text, i, j);
                            }
                        }
                        break;
                    }
                    case Outline: {
                        Object oldAAHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        FontRenderContext frc = g.getFontRenderContext();
                        GlyphVector gv = EnhancedJLabel.this.getFont().createGlyphVector(frc, text);
                        g.setStroke(new BasicStroke(2 + additionalOffset));
                        g.setComposite(AlphaComposite.getInstance(3, EnhancedJLabel.this.getEffectOpacity()));
                        g.draw(gv.getOutline());
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAHint);
                    }
                }
                g.translate(-x, -y);
                g.setComposite(oldComposite);
                g.setColor(oldColor);
                if (oldTextAAHint != null) {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTextAAHint);
                }
            }
        }

        public void paintTextShadow(Graphics2D g, String s, Color c) {
            this.paintEffect(g, s, this.removeAlpha(c), 1.0, 1.0);
        }

        public void paintTextEmphasize(Graphics2D g, String s, Color c) {
            this.paintEffect(g, s, this.removeAlpha(c), 0.0, 1.0);
        }

        public void paintTextGlow(Graphics2D g, String s, Color glow) {
            this.paintEffect(g, s, this.removeAlpha(glow), 0.0, 0.0);
        }

        public Color removeAlpha(Color c) {
            if (c != null && c.getAlpha() != 100) {
                c = new Color(c.getRGB());
            }
            return c;
        }
    }
}

