/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.editor;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.editor.AbstractPredefinedColorMapEditor;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.adapter.IntervalProperty;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.PropertySingleSelection;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPCheckBox;
import com.macrofocus.crossplatform.CPColorPicker;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.crossplatform.CPSlider;
import com.macrofocus.crossplatform.CPSpinner;
import com.macrofocus.crossplatform.CPSplitMenuButton;
import com.macrofocus.format.CPFormat;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IDrawingListener;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.palette.CustomPalette;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.PaletteFactory;
import java.util.ArrayList;
import java.util.Iterator;

public class CPPredefinedColorMapEditor<Component, Color>
extends AbstractPredefinedColorMapEditor<Component, Color> {
    private final ColorMapFactory<Color> a;
    private CPFormPanel<Component> b;
    private CPSplitMenuButton c;
    private CPSpinner<Component, Double> d;
    private CPSpinner<Component, Double> e;
    private CPColorPicker<Component, Color> f;
    private CPColorPicker<Component, Color> g;
    private CPColorPicker<Component, Color> h;
    private CPComboBox<Component, MutablePalette<Color>> i;
    private CPCheckBox<Component> j;
    private CPCheckBox<Component> k;
    private CPSpinner<Component, Integer> l;
    private CPCheckBox<Component> m;
    private CPCheckBox<Component> n;
    private CPSlider<Component> o;
    private CPSlider<Component> p;

    /*
     * WARNING - void declaration
     */
    public CPPredefinedColorMapEditor(CPFactory<Component, ?, ?, Color> factory, ColorMapFactory<Color> colorMapFactory) {
        void var1_1;
        void var2_2;
        this.a = var2_2;
        this.b = factory.createFormPanel();
        this.c = factory.createSplitMenuButton();
        this.c.setStyleClass("setToFullRangeButton");
        this.c.setDefaultCommand((UICommand)new AbstractUICommand(this, "Set to Data Range"){
            private /* synthetic */ CPPredefinedColorMapEditor a;
            {
                this.a = cPPredefinedColorMapEditor;
                super(string);
            }

            public final void execute(Object source) {
                this.a.e.setValue(this.a.min != null ? Double.valueOf(this.a.min.doubleValue()) : null);
                this.a.d.setValue(this.a.max != null ? Double.valueOf(this.a.max.doubleValue()) : null);
            }
        });
        this.c.addCommand((UICommand)new AbstractUICommand(this, "Set to Data Range"){
            private /* synthetic */ CPPredefinedColorMapEditor a;
            {
                this.a = cPPredefinedColorMapEditor;
                super(string);
            }

            public final void execute(Object source) {
                this.a.e.setValue(this.a.min != null ? Double.valueOf(this.a.min.doubleValue()) : null);
                this.a.d.setValue(this.a.max != null ? Double.valueOf(this.a.max.doubleValue()) : null);
            }
        });
        this.c.addCommand((UICommand)new AbstractUICommand(this, "Set to Rounded Range"){
            private /* synthetic */ CPPredefinedColorMapEditor a;
            {
                this.a = cPPredefinedColorMapEditor;
                super(string);
            }

            public final void execute(Object source) {
                double d2 = Math.signum(this.a.min.doubleValue()) * Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.a.min.doubleValue()))));
                this.a.e.setValue(d2);
                double d3 = Math.signum(this.a.max.doubleValue()) * Math.pow(10.0, Math.ceil(Math.log10(Math.abs(this.a.max.doubleValue()))));
                this.a.d.setValue(d3);
            }
        });
        this.c.addCommand((UICommand)new AbstractUICommand(this, "Set to Symmetrical Range around 0"){
            private /* synthetic */ CPPredefinedColorMapEditor a;
            {
                this.a = cPPredefinedColorMapEditor;
                super(string);
            }

            public final void execute(Object source) {
                Double d2;
                CPSpinner cPSpinner;
                if (this.a.min.doubleValue() < 0.0 && this.a.min.doubleValue() > 0.0) {
                    double d3 = 0.0 - this.a.min.doubleValue();
                    double d4 = this.a.max.doubleValue();
                    double d5 = Math.max(d3, d4);
                    this.a.e.setValue(0.0 - d5);
                    cPSpinner = this.a.d;
                    d2 = d5;
                } else {
                    this.a.e.setValue(-this.a.max.doubleValue());
                    cPSpinner = this.a.d;
                    d2 = this.a.max != null ? Double.valueOf(this.a.max.doubleValue()) : null;
                }
                cPSpinner.setValue(d2);
            }
        });
        this.d = factory.createDoubleSpinner();
        this.d.setStyleClass("spinner", "maximumSpinner");
        this.e = factory.createDoubleSpinner();
        this.f = factory.createColorPicker();
        this.g = factory.createColorPicker();
        this.h = factory.createColorPicker();
        this.i = factory.createComboBox();
        this.i.setRenderer(new CPComboBox.ItemRenderer<Component, MutablePalette<Color>>(this, factory){
            private /* synthetic */ CPFactory a;
            {
                this.a = cPFactory;
            }

            @Override
            public final /* synthetic */ CPComponent render(Object object) {
                MutablePalette mutablePalette = (MutablePalette)object;
                object = this;
                if (mutablePalette != null) {
                    CPCanvas cPCanvas = object.a.createCanvas();
                    cPCanvas.addLayer(new IDrawing(object, mutablePalette){
                        private CustomPalette.Mode a = CustomPalette.Mode.Ramps;
                        private /* synthetic */ MutablePalette b;
                        {
                            this.b = mutablePalette;
                        }

                        @Override
                        public final boolean isActive() {
                            return true;
                        }

                        public final void draw(IGraphics g2, Point2D point, double width, double height, Rectangle clipBounds) {
                            switch (this.a) {
                                case Bands: {
                                    for (int i = 0; i < this.b.getColorCount(); ++i) {
                                        CPColor cPColor = this.b.getColorAt(i);
                                        int n = 0 + (int)(width * (double)i / (double)this.b.getColorCount());
                                        int n2 = 0 + (int)(width * (double)(i + 1) / (double)this.b.getColorCount());
                                        g2.setColor(cPColor);
                                        g2.fillRectangle2D(new Rectangle2D.Double(n, 0.0, n2 - n + 1, height));
                                    }
                                    return;
                                }
                                case Ramps: {
                                    for (int i = 0; i < 256; ++i) {
                                        CPColor cPColor = this.b.getColor((double)i / 255.0);
                                        int n = 0 + (int)(width * (double)i / 256.0);
                                        int n3 = 0 + (int)(width * (double)(i + 1) / 256.0);
                                        g2.setColor(cPColor);
                                        g2.fillRectangle2D(new Rectangle2D.Double(n, 0.0, n3 - n + 1, height));
                                    }
                                    break;
                                }
                            }
                        }

                        @Override
                        public final void addIDrawingListener(IDrawingListener listener) {
                        }

                        @Override
                        public final void removeIDrawingListener(IDrawingListener listener) {
                        }
                    });
                    return cPCanvas;
                }
                return object.a.createLabel("");
            }
        });
        factory.createOverlayPanel();
        this.j = factory.createCheckBox("Number of Steps:", null);
        this.k = factory.createCheckBox("Inverted", null);
        this.l = factory.createIntegerSpinner();
        this.m = factory.createCheckBox("Underflow Color:", null);
        this.n = factory.createCheckBox("Overflow Color:", null);
        this.o = factory.createSlider();
        this.o.setMinimum(-150.0);
        this.o.setMaximum(150.0);
        this.p = factory.createSlider();
        this.p.setMinimum(-150.0);
        this.p.setMaximum(150.0);
        factory.createFormPanel();
        this.b.add(factory.createLabel("Palette:"), this.i);
        this.b.add(factory.createLabel("Maximum:"), this.d);
        this.b.add(factory.createLabel("Minimum:"), this.e);
        this.b.add(null, this.c);
        this.b.add(this.j, this.l);
        this.b.add(this.k, null);
        this.b.add(factory.createLabel("Brightness:"), this.o);
        this.b.add(factory.createLabel("Saturation:"), this.p);
        this.b.add(this.n, this.h);
        this.b.add(this.m, this.f);
        this.b.add(var1_1.createLabel("Missing Values Color:"), this.g);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColorMap(MutableColorMap<Color> colorMap, Number min, Number max, CPFormat format) {
        void var1_1;
        Iterator<PaletteFactory.Entry> iterator;
        ArrayList arrayList;
        this.colorMap = colorMap;
        this.min = arrayList;
        this.max = iterator;
        this.format = format;
        this.d.setProperty((MutableProperty<Double>)new IntervalProperty(colorMap.getInterval(), IntervalProperty.Value.End));
        this.d.setFormat(format);
        this.e.setProperty((MutableProperty<Double>)new IntervalProperty(colorMap.getInterval(), IntervalProperty.Value.Start));
        this.e.setFormat(format);
        this.f.setProperty(colorMap.underColorProperty());
        this.g.setProperty(colorMap.nullColorProperty());
        this.h.setProperty(colorMap.overColorProperty());
        arrayList = new ArrayList();
        for (PaletteFactory.Entry entry : this.a.getPaletteFactory().getEntries()) {
            if (entry.getType() == PaletteFactory.Type.QUALITATIVE) continue;
            arrayList.add(entry.getPalette());
        }
        this.i.setModel((MutableSingleSelection<MutablePalette<Color>>)new PropertySingleSelection(colorMap.paletteProperty()), arrayList);
        this.j.setProperty(colorMap.colorCountSetProperty());
        this.l.setProperty(colorMap.colorCountProperty());
        this.k.setProperty(colorMap.invertedProperty());
        this.m.setProperty(colorMap.underColorSetProperty());
        this.n.setProperty(colorMap.overColorSetProperty());
        this.o.setProperty(colorMap.brightnessProperty());
        this.p.setProperty(var1_1.saturationProperty());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStyleClass(String ... styleClasses) {
        void var1_1;
        this.b.setStyleClass((String[])var1_1);
    }

    @Override
    public Component getNativeComponent() {
        return this.b.getNativeComponent();
    }
}

