/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.FlatteningPathIterator;
import com.macrofocus.geom.Line2D;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.geom.a;

public interface Arc2D
extends Shape {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;

    public int getArcType();

    public double getX();

    public double getY();

    public double getWidth();

    public double getHeight();

    public double getCenterX();

    public double getCenterY();

    public double getAngleStart();

    public double getAngleExtent();

    public Point2D getStartPoint();

    public Point2D getEndPoint();

    public static class Double
    implements Arc2D {
        private final double a;
        private final double b;
        private final double c;
        private final double d;
        private final double e;
        private final double f;
        private final int g;

        /*
         * WARNING - void declaration
         */
        public Double(Rectangle2D bounds, double start, double extent, int type) {
            void var2_2;
            void var1_1;
            this.a = bounds.getX();
            this.b = bounds.getY();
            this.c = bounds.getWidth();
            this.d = var1_1.getHeight();
            this.e = var2_2;
            this.f = extent;
            this.g = type;
        }

        /*
         * WARNING - void declaration
         */
        public Double(double x, double y, double width, double height, double start, double extent, int type) {
            void var3_2;
            void var1_1;
            this.a = var1_1;
            this.b = var3_2;
            this.c = width;
            this.d = height;
            this.e = start;
            this.f = extent;
            this.g = type;
        }

        /*
         * WARNING - void declaration
         */
        public static Double getArcByCenter(double x, double y, double radius, double angSt, double angExt, int closure) {
            void var2_2;
            double d2;
            return new Double(d2 - radius, (double)(var2_2 - radius), radius * 2.0, radius * 2.0, angSt, angExt, closure);
        }

        @Override
        public Rectangle2D getBounds2D() {
            double d2;
            double d3;
            double d4;
            double d5;
            if (this.isEmpty()) {
                return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            if (this.getArcType() == 2) {
                d5 = 0.0;
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
            } else {
                d3 = 1.0;
                d2 = 1.0;
                d5 = -1.0;
                d4 = -1.0;
            }
            double d6 = 0.0;
            for (int i = 0; i < 6; ++i) {
                if (i < 4) {
                    if (!this.containsAngle(d6 += 90.0)) {
                        continue;
                    }
                } else {
                    d6 = i == 4 ? this.getAngleStart() : (d6 += this.getAngleExtent());
                }
                double d7 = Math.toRadians(-d6);
                double d8 = Math.cos(d7);
                d2 = Math.min(d2, d8);
                double d9 = Math.sin(d7);
                d3 = Math.min(d3, d9);
                d4 = Math.max(d4, d8);
                d5 = Math.max(d5, d9);
            }
            double d10 = this.getWidth();
            double d11 = this.getHeight();
            d4 = (d4 - d2) * 0.5 * d10;
            d5 = (d5 - d3) * 0.5 * d11;
            d2 = this.getX() + (d2 * 0.5 + 0.5) * d10;
            d3 = this.getY() + (d3 * 0.5 + 0.5) * d11;
            return new Rectangle2D.Double(d2, d3, d4, d5);
        }

        public boolean isEmpty() {
            return this.c <= 0.0 || this.d <= 0.0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Point2D p) {
            double d2;
            double d3;
            double d4;
            boolean bl;
            double d5;
            double d6;
            double d7;
            double d8;
            void var1_1;
            double d9 = p.getX();
            double d10 = var1_1.getY();
            double d11 = this.getWidth();
            if (d8 <= 0.0) {
                return false;
            }
            double d12 = (d9 - this.getX()) / d11 - 0.5;
            double d13 = this.getHeight();
            if (d7 <= 0.0) {
                return false;
            }
            double d14 = (d10 - this.getY()) / d13 - 0.5;
            double d15 = d12;
            double d16 = d14;
            double d17 = d15 * d15 + d16 * d16;
            if (d6 >= 0.25) {
                return false;
            }
            double d18 = Math.abs(this.getAngleExtent());
            if (d5 >= 360.0) {
                return true;
            }
            boolean bl2 = this.containsAngle(-Math.toDegrees(Math.atan2(d14, d12)));
            if (this.g == 2) {
                return bl2;
            }
            if (bl2) {
                if (d18 >= 180.0) {
                    return true;
                }
            } else if (d18 <= 180.0) {
                return false;
            }
            double d19 = Math.toRadians(-this.getAngleStart());
            double d20 = Math.cos(d19);
            boolean bl3 = bl = Line2D.relativeCCW(d20, d4 = Math.sin(d19), d3 = Math.cos(d19 += Math.toRadians(-this.getAngleExtent())), d2 = Math.sin(d19), d12 * 2.0, d14 * 2.0) * Line2D.relativeCCW(d20, d4, d3, d2, 0.0, 0.0) >= 0;
            return bl2 != bl;
        }

        @Override
        public boolean intersects(Rectangle2D r) {
            Object object;
            double d2 = r.getX();
            double d3 = r.getY();
            double d4 = r.getWidth();
            double d5 = object.getHeight();
            double d6 = this.getWidth();
            double d7 = this.getHeight();
            if (d4 <= 0.0 || d5 <= 0.0 || d6 <= 0.0 || d7 <= 0.0) {
                return false;
            }
            double d8 = this.getAngleExtent();
            if (d8 == 0.0) {
                return false;
            }
            double d9 = this.getX();
            double d10 = this.getY();
            double d11 = d9 + d6;
            double d12 = d10 + d7;
            double d13 = d2 + d4;
            double d14 = d3 + d5;
            if (d2 >= d11 || d3 >= d12 || d13 <= d9 || d14 <= d10) {
                return false;
            }
            double d15 = this.getCenterX();
            double d16 = this.getCenterY();
            object = this.getStartPoint();
            Point2D point2D = this.getEndPoint();
            double d17 = object.getX();
            double d18 = object.getY();
            double d19 = point2D.getX();
            double d20 = point2D.getY();
            if (d16 >= d3 && d16 <= d14 && (d17 < d13 && d19 < d13 && d15 < d13 && d11 > d2 && this.containsAngle(0.0) || d17 > d2 && d19 > d2 && d15 > d2 && d9 < d13 && this.containsAngle(180.0))) {
                return true;
            }
            if (d15 >= d2 && d15 <= d13 && (d18 > d3 && d20 > d3 && d16 > d3 && d10 < d14 && this.containsAngle(90.0) || d18 < d14 && d20 < d14 && d16 < d14 && d12 > d3 && this.containsAngle(270.0))) {
                return true;
            }
            object = new Rectangle2D.Double(d2, d3, d4, d5);
            if (this.g == 2 || Math.abs(d8) > 180.0 ? object.intersectsLine(d15, d16, d17, d18) || object.intersectsLine(d15, d16, d19, d20) : object.intersectsLine(d17, d18, d19, d20)) {
                return true;
            }
            return this.contains(new Point2D.Double(d2, d3)) || this.contains(new Point2D.Double(d13, d3)) || this.contains(new Point2D.Double(d2, d14)) || this.contains(new Point2D.Double(d13, d14));
        }

        @Override
        public PathIterator getPathIterator() {
            return this.getPathIterator(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            void var1_1;
            return new a(this, (AffineTransform)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PathIterator getFlattenPathIterator(double flatness) {
            void var1_1;
            return new FlatteningPathIterator(this.getPathIterator(), (double)var1_1);
        }

        @Override
        public int getArcType() {
            return this.g;
        }

        @Override
        public double getX() {
            return this.a;
        }

        @Override
        public double getY() {
            return this.b;
        }

        @Override
        public double getWidth() {
            return this.c;
        }

        @Override
        public double getHeight() {
            return this.d;
        }

        @Override
        public double getCenterX() {
            return this.getX() + this.getWidth() / 2.0;
        }

        @Override
        public double getCenterY() {
            return this.getY() + this.getHeight() / 2.0;
        }

        @Override
        public double getAngleStart() {
            return this.e;
        }

        @Override
        public double getAngleExtent() {
            return this.f;
        }

        @Override
        public Point2D getStartPoint() {
            double d2 = Math.toRadians(-this.getAngleStart());
            double d3 = this.getX() + (Math.cos(d2) * 0.5 + 0.5) * this.getWidth();
            double d4 = this.getY() + (Math.sin(d2) * 0.5 + 0.5) * this.getHeight();
            return new Point2D.Double(d3, d4);
        }

        @Override
        public Point2D getEndPoint() {
            double d2 = Math.toRadians(-this.getAngleStart() - this.getAngleExtent());
            double d3 = this.getX() + (Math.cos(d2) * 0.5 + 0.5) * this.getWidth();
            double d4 = this.getY() + (Math.sin(d2) * 0.5 + 0.5) * this.getHeight();
            return new Point2D.Double(d3, d4);
        }

        /*
         * WARNING - void declaration
         */
        public boolean containsAngle(double angle) {
            void var1_1;
            double d2;
            double d3 = this.getAngleExtent();
            boolean bl = d2 < 0.0;
            if (bl) {
                d3 = -d3;
            }
            if (d3 >= 360.0) {
                return true;
            }
            angle = Double.a(angle) - Double.a(this.getAngleStart());
            if (bl) {
                angle = -angle;
            }
            if (angle < 0.0) {
                angle += 360.0;
            }
            return angle >= 0.0 && var1_1 < d3;
        }

        private static double a(double d2) {
            if (d2 > 180.0) {
                if (d2 <= 540.0) {
                    d2 -= 360.0;
                } else if ((d2 = Double.IEEEremainder(d2, 360.0)) == -180.0) {
                    d2 = 180.0;
                }
            } else if (d2 <= -180.0) {
                if (d2 > -540.0) {
                    d2 += 360.0;
                } else if ((d2 = Double.IEEEremainder(d2, 360.0)) == -180.0) {
                    d2 = 180.0;
                }
            }
            return d2;
        }

        /*
         * WARNING - void declaration
         */
        public static double IEEEremainder(double f1, double f2) {
            void var2_1;
            double d2;
            double d3 = Math.abs(f1 % f2);
            if (java.lang.Double.isNaN(d3) || d3 == f2 || d3 <= Math.abs(f2) / 2.0) {
                return d3;
            }
            return Math.signum(d2) * (d3 - var2_1);
        }
    }
}

