/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.EllipseIterator;
import com.macrofocus.geom.FlatteningPathIterator;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;

public interface Ellipse2D
extends Shape {
    public double getX();

    public double getY();

    public double getWidth();

    public double getHeight();

    public double getMinX();

    public double getMinY();

    public double getMaxX();

    public double getMaxY();

    public double getCenterX();

    public double getCenterY();

    public static class Double
    implements Ellipse2D {
        private final double a;
        private final double b;
        private final double c;
        private final double d;

        /*
         * WARNING - void declaration
         */
        public Double(double x, double y, double width, double height) {
            void var3_2;
            void var1_1;
            this.a = var1_1;
            this.b = var3_2;
            this.c = width;
            this.d = height;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.a, this.b, this.c, this.d);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Point2D point) {
            void var1_1;
            double d2 = point.getX();
            double d3 = var1_1.getY();
            double d4 = this.getX();
            double d5 = this.getY();
            return d2 >= d4 && d3 >= d5 && d2 < d4 + this.getWidth() && d3 < d5 + this.getHeight();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean intersects(Rectangle2D rect) {
            double d2;
            double d3;
            void var1_1;
            double d4 = rect.getX();
            double d5 = rect.getY();
            double d6 = rect.getWidth();
            double d7 = var1_1.getHeight();
            if (d6 <= 0.0 || d7 <= 0.0) {
                return false;
            }
            double d8 = this.getWidth();
            if (d3 <= 0.0) {
                return false;
            }
            double d9 = (d4 - this.getX()) / d8 - 0.5;
            double d10 = this.getHeight();
            if (d2 <= 0.0) {
                return false;
            }
            double d11 = (d5 - this.getY()) / d10 - 0.5;
            double d12 = d9 + d6 / d8;
            double d13 = d9 > 0.0 ? d9 : (d12 < 0.0 ? d12 : 0.0);
            double d14 = d11 + d7 / d10;
            double d15 = d11 > 0.0 ? d11 : (d14 < 0.0 ? d14 : 0.0);
            double d16 = d13;
            double d17 = d15;
            return d16 * d16 + d17 * d17 < 0.25;
        }

        @Override
        public double getX() {
            return this.a;
        }

        @Override
        public double getY() {
            return this.b;
        }

        @Override
        public double getWidth() {
            return this.c;
        }

        @Override
        public double getHeight() {
            return this.d;
        }

        @Override
        public double getMinX() {
            return this.getX();
        }

        @Override
        public double getMinY() {
            return this.getY();
        }

        @Override
        public double getMaxX() {
            return this.getX() + this.getWidth();
        }

        @Override
        public double getMaxY() {
            return this.getY() + this.getHeight();
        }

        @Override
        public double getCenterX() {
            return this.getX() + this.getWidth() / 2.0;
        }

        @Override
        public double getCenterY() {
            return this.getY() + this.getHeight() / 2.0;
        }

        @Override
        public PathIterator getPathIterator() {
            return this.getPathIterator(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            void var1_1;
            return new EllipseIterator(this, (AffineTransform)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PathIterator getFlattenPathIterator(double flatness) {
            void var1_1;
            return new FlatteningPathIterator(this.getPathIterator(), (double)var1_1);
        }

        public String toString() {
            return "Ellipse2D.Double{x=" + this.a + ", y=" + this.b + ", width=" + this.c + ", height=" + this.d + '}';
        }
    }
}

