/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.Geometry;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Segment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Path
implements Geometry {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final long serialVersionUID = 1L;
    private int a = 1;
    private List<Segment> b = new ArrayList<Segment>();

    public Path() {
    }

    /*
     * WARNING - void declaration
     */
    public Path(Segment ... segments) {
        this(1, (Segment[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Path(int windingRule, Segment ... segments) {
        this((int)var1_1);
        void var2_3;
        void var1_1;
        for (void var4_6 : var2_3) {
            this.b.add((Segment)var4_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Path(int windingRule) {
        void var1_1;
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForLine(double px, double py, double x0, double y0, double x1, double y1) {
        double d2;
        void var2_2;
        if (py < y0 && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= x1) {
            return 0;
        }
        if (px < x0 && px < x1) {
            if (y0 < y1) {
                return 1;
            }
            return -1;
        }
        double d3 = x0 + (var2_2 - y0) * (x1 - x0) / (y1 - y0);
        if (d2 >= d3) {
            return 0;
        }
        if (y0 < y1) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForQuad(double px, double py, double x0, double y0, double xc, double yc, double x1, double y1, int level) {
        void var2_2;
        double d2;
        if (py < y0 && py < yc && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= yc && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= xc && px >= x1) {
            return 0;
        }
        if (px < x0 && px < xc && px < x1) {
            if (py >= y0) {
                if (py < y1) {
                    return 1;
                }
            } else if (py >= y1) {
                return -1;
            }
            return 0;
        }
        if (level > 52) {
            return Path.pointCrossingsForLine(px, py, x0, y0, x1, y1);
        }
        double d3 = (x0 + xc) / 2.0;
        double d4 = (y0 + yc) / 2.0;
        double d5 = (xc + x1) / 2.0;
        double d6 = (yc + y1) / 2.0;
        xc = (d3 + d5) / 2.0;
        yc = (d4 + d6) / 2.0;
        if (Double.isNaN(xc) || Double.isNaN(yc)) {
            return 0;
        }
        return Path.pointCrossingsForQuad(px, py, x0, y0, d3, d4, xc, yc, level + 1) + Path.pointCrossingsForQuad(d2, (double)var2_2, xc, yc, d5, d6, x1, y1, level + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForCubic(double px, double py, double x0, double y0, double xc0, double yc0, double xc1, double yc1, double x1, double y1, int level) {
        void var2_2;
        double d2;
        if (py < y0 && py < yc0 && py < yc1 && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= yc0 && py >= yc1 && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= xc0 && px >= xc1 && px >= x1) {
            return 0;
        }
        if (px < x0 && px < xc0 && px < xc1 && px < x1) {
            if (py >= y0) {
                if (py < y1) {
                    return 1;
                }
            } else if (py >= y1) {
                return -1;
            }
            return 0;
        }
        if (level > 52) {
            return Path.pointCrossingsForLine(px, py, x0, y0, x1, y1);
        }
        double d3 = (xc0 + xc1) / 2.0;
        double d4 = (yc0 + yc1) / 2.0;
        xc0 = (x0 + xc0) / 2.0;
        yc0 = (y0 + yc0) / 2.0;
        xc1 = (xc1 + x1) / 2.0;
        yc1 = (yc1 + y1) / 2.0;
        double d5 = (xc0 + d3) / 2.0;
        double d6 = (yc0 + d4) / 2.0;
        double d7 = (d3 + xc1) / 2.0;
        double d8 = (d4 + yc1) / 2.0;
        d3 = (d5 + d7) / 2.0;
        d4 = (d6 + d8) / 2.0;
        if (Double.isNaN(d3) || Double.isNaN(d4)) {
            return 0;
        }
        return Path.pointCrossingsForCubic(px, py, x0, y0, xc0, yc0, d5, d6, d3, d4, level + 1) + Path.pointCrossingsForCubic(d2, (double)var2_2, d3, d4, d7, d8, xc1, yc1, x1, y1, level + 1);
    }

    public final Path close() {
        this.b.add(new Segment(4, new Point2D[0]));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Path cubicTo(double control1X, double control1Y, double control2X, double control2Y, double x, double y) {
        void var3_2;
        void var1_1;
        this.b.add(new Segment(3, new Point2D.Double((double)var1_1, (double)var3_2), new Point2D.Double(control2X, control2Y), new Point2D.Double(x, y)));
        return this;
    }

    public int getWindingRule() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public void setWindingRule(int windingRule) {
        void var1_1;
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Path lineTo(double x, double y) {
        void var3_2;
        void var1_1;
        this.b.add(new Segment(1, new Point2D.Double((double)var1_1, (double)var3_2)));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Path moveTo(double x, double y) {
        void var3_2;
        void var1_1;
        this.b.add(new Segment(0, new Point2D.Double((double)var1_1, (double)var3_2)));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Path quadTo(double controlX, double controlY, double x, double y) {
        void var3_2;
        void var1_1;
        this.b.add(new Segment(2, new Point2D.Double((double)var1_1, (double)var3_2), new Point2D.Double(x, y)));
        return this;
    }

    public Segment[] getSegments() {
        return this.b.toArray(new Segment[this.b.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public void setSegments(Segment[] segments) {
        void var1_1;
        this.b = Arrays.asList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Point2D point) {
        void var1_1;
        double d2;
        double d3 = point.getX();
        if (d3 * 0.0 + (d2 = var1_1.getY()) * 0.0 == 0.0) {
            Point2D point2D;
            if (this.b.size() < 2) {
                return false;
            }
            int n = this.a == 1 ? -1 : 1;
            double d4 = d2;
            double d5 = d3;
            Path path = this;
            Point2D point2D2 = point2D = path.b.get(0).getPoints()[0];
            int n2 = 0;
            int n3 = 1;
            block7: for (int i = 1; i < path.b.size(); ++i) {
                Segment segment = path.b.get(i);
                switch (segment.getType()) {
                    case 0: {
                        if (point2D2.getY() != point2D.getY()) {
                            n2 += Path.pointCrossingsForLine(d5, d4, point2D2.getX(), point2D2.getY(), point2D.getX(), point2D.getY());
                        }
                        point2D = point2D2 = segment.getPoints()[n3++];
                        continue block7;
                    }
                    case 1: {
                        double d6 = point2D2.getX();
                        double d7 = point2D2.getY();
                        point2D2 = segment.getPoints()[n3++];
                        n2 += Path.pointCrossingsForLine(d5, d4, d6, d7, point2D2.getX(), segment.getPoints()[n3].getY());
                        continue block7;
                    }
                    case 2: {
                        double d8 = point2D2.getX();
                        double d9 = point2D2.getY();
                        int n4 = n3++;
                        double d10 = segment.getPoints()[n3].getY();
                        point2D2 = segment.getPoints()[n3++];
                        n2 += Path.pointCrossingsForQuad(d5, d4, d8, d9, segment.getPoints()[n4].getX(), d10, point2D2.getX(), segment.getPoints()[n3].getY(), 0);
                        continue block7;
                    }
                    case 3: {
                        double d11 = point2D2.getX();
                        double d12 = point2D2.getY();
                        int n5 = n3++;
                        double d13 = segment.getPoints()[n3].getY();
                        int n6 = n3++;
                        double d14 = segment.getPoints()[n3].getY();
                        point2D2 = segment.getPoints()[n3++];
                        n2 += Path.pointCrossingsForCubic(d5, d4, d11, d12, segment.getPoints()[n5].getX(), d13, segment.getPoints()[n6].getX(), d14, point2D2.getX(), segment.getPoints()[n3].getY(), 0);
                        continue block7;
                    }
                    case 4: {
                        if (point2D2.getY() != point2D.getY()) {
                            n2 += Path.pointCrossingsForLine(d5, d4, point2D2.getX(), point2D2.getY(), point2D.getX(), point2D.getY());
                        }
                        point2D2 = point2D;
                    }
                }
            }
            if (point2D2.getY() != point2D.getY()) {
                n2 += Path.pointCrossingsForLine(d5, d4, point2D2.getX(), point2D2.getY(), point2D.getX(), point2D.getY());
            }
            return (n2 & n) != 0;
        }
        return false;
    }

    public String toString() {
        return "Path{windingRule=" + this.a + ", segments=" + this.b + '}';
    }
}

