/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom.curve;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.geom.curve.Geom;
import com.macrofocus.geom.curve.MultiPath;
import com.macrofocus.geom.curve.e;

public class ShapeMultiPath
extends MultiPath
implements Shape {
    /*
     * WARNING - void declaration
     */
    public ShapeMultiPath(int dimension) {
        super(dimension);
        void var1_1;
        assert (var1_1 >= 2) : "dimension >= 2 required";
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForPath(PathIterator pi, double px, double py) {
        if (pi.isDone()) {
            return 0;
        }
        double[] dArray = new double[6];
        if (pi.currentSegment(dArray) != 0) {
            throw new IllegalStateException("missing initial moveto in path definition");
        }
        pi.next();
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = d2;
        double d5 = d3;
        int n = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(dArray)) {
                case 0: {
                    if (d5 != d3) {
                        n += ShapeMultiPath.pointCrossingsForLine(px, py, d4, d5, d2, d3);
                    }
                    d2 = d4 = dArray[0];
                    d3 = d5 = dArray[1];
                    break;
                }
                case 1: {
                    double d6 = dArray[0];
                    double d7 = dArray[1];
                    n += ShapeMultiPath.pointCrossingsForLine(px, py, d4, d5, d6, d7);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 2: {
                    double d6 = dArray[2];
                    double d7 = dArray[3];
                    n += ShapeMultiPath.pointCrossingsForQuad(px, py, d4, d5, dArray[0], dArray[1], d6, d7, 0);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 3: {
                    double d6 = dArray[4];
                    double d7 = dArray[5];
                    n += ShapeMultiPath.pointCrossingsForCubic(px, py, d4, d5, dArray[0], dArray[1], dArray[2], dArray[3], d6, d7, 0);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 4: {
                    if (d5 != d3) {
                        n += ShapeMultiPath.pointCrossingsForLine(px, py, d4, d5, d2, d3);
                    }
                    d4 = d2;
                    d5 = d3;
                }
            }
            pi.next();
        }
        if (d5 != d3) {
            void var3_2;
            void var1_1;
            n += ShapeMultiPath.pointCrossingsForLine((double)var1_1, (double)var3_2, d4, d5, d2, d3);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForLine(double px, double py, double x0, double y0, double x1, double y1) {
        double d2;
        void var2_2;
        if (py < y0 && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= x1) {
            return 0;
        }
        if (px < x0 && px < x1) {
            if (y0 < y1) {
                return 1;
            }
            return -1;
        }
        double d3 = x0 + (var2_2 - y0) * (x1 - x0) / (y1 - y0);
        if (d2 >= d3) {
            return 0;
        }
        if (y0 < y1) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForQuad(double px, double py, double x0, double y0, double xc, double yc, double x1, double y1, int level) {
        void var2_2;
        double d2;
        if (py < y0 && py < yc && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= yc && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= xc && px >= x1) {
            return 0;
        }
        if (px < x0 && px < xc && px < x1) {
            if (py >= y0) {
                if (py < y1) {
                    return 1;
                }
            } else if (py >= y1) {
                return -1;
            }
            return 0;
        }
        if (level > 52) {
            return ShapeMultiPath.pointCrossingsForLine(px, py, x0, y0, x1, y1);
        }
        double d3 = (x0 + xc) / 2.0;
        double d4 = (y0 + yc) / 2.0;
        double d5 = (xc + x1) / 2.0;
        double d6 = (yc + y1) / 2.0;
        xc = (d3 + d5) / 2.0;
        yc = (d4 + d6) / 2.0;
        if (Double.isNaN(xc) || Double.isNaN(yc)) {
            return 0;
        }
        return ShapeMultiPath.pointCrossingsForQuad(px, py, x0, y0, d3, d4, xc, yc, level + 1) + ShapeMultiPath.pointCrossingsForQuad(d2, (double)var2_2, xc, yc, d5, d6, x1, y1, level + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForCubic(double px, double py, double x0, double y0, double xc0, double yc0, double xc1, double yc1, double x1, double y1, int level) {
        void var2_2;
        double d2;
        if (py < y0 && py < yc0 && py < yc1 && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= yc0 && py >= yc1 && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= xc0 && px >= xc1 && px >= x1) {
            return 0;
        }
        if (px < x0 && px < xc0 && px < xc1 && px < x1) {
            if (py >= y0) {
                if (py < y1) {
                    return 1;
                }
            } else if (py >= y1) {
                return -1;
            }
            return 0;
        }
        if (level > 52) {
            return ShapeMultiPath.pointCrossingsForLine(px, py, x0, y0, x1, y1);
        }
        double d3 = (xc0 + xc1) / 2.0;
        double d4 = (yc0 + yc1) / 2.0;
        xc0 = (x0 + xc0) / 2.0;
        yc0 = (y0 + yc0) / 2.0;
        xc1 = (xc1 + x1) / 2.0;
        yc1 = (yc1 + y1) / 2.0;
        double d5 = (xc0 + d3) / 2.0;
        double d6 = (yc0 + d4) / 2.0;
        double d7 = (d3 + xc1) / 2.0;
        double d8 = (d4 + yc1) / 2.0;
        d3 = (d5 + d7) / 2.0;
        d4 = (d6 + d8) / 2.0;
        if (Double.isNaN(d3) || Double.isNaN(d4)) {
            return 0;
        }
        return ShapeMultiPath.pointCrossingsForCubic(px, py, x0, y0, xc0, yc0, d5, d6, d3, d4, level + 1) + ShapeMultiPath.pointCrossingsForCubic(d2, (double)var2_2, d3, d4, d7, d8, xc1, yc1, x1, y1, level + 1);
    }

    public int[] getBasisVectors() {
        return new int[]{0, 1};
    }

    public int getWindingRule() {
        return 0;
    }

    @Override
    public Rectangle2D getBounds2D() {
        int n = this.getNumPoints();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.get(i);
            boolean bl2 = false;
            if (this.getType(i) != MultiPath.MOVE_TO || i < n - 1 && this.getType(i + 1) == MultiPath.a) {
                bl2 = true;
            }
            if (!bl2) continue;
            bl = true;
            if (dArray[0] < d2) {
                d2 = dArray[0];
            }
            if (dArray[1] < d3) {
                d3 = dArray[1];
            }
            if (dArray[0] > d4) {
                d4 = dArray[0];
            }
            if (!(dArray[1] > d5)) continue;
            d5 = dArray[1];
        }
        if (!bl) {
            return null;
        }
        return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Point2D p) {
        void var1_1;
        return this.contains(p.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean intersects(Rectangle2D r) {
        void var1_1;
        return this.intersects(r.getX(), r.getY(), r.getWidth(), var1_1.getHeight());
    }

    @Override
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        void var1_1;
        return new e(this, (AffineTransform)var1_1);
    }

    @Override
    public PathIterator getFlattenPathIterator(double flatness) {
        return new e(this, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(double x, double y) {
        void var3_3;
        void var1_1;
        int n = ShapeMultiPath.pointCrossingsForPath(this.getPathIterator(), (double)var1_1, (double)var3_3);
        return (n & 1) != 0;
    }

    public boolean contains(double x1, double y1, double w, double h) {
        if (!this.contains(x1, y1)) {
            return false;
        }
        double d2 = y1 + h;
        if (!this.contains(x1, d2)) {
            return false;
        }
        double d3 = x1 + w;
        if (!this.contains(d3, y1)) {
            return false;
        }
        if (!this.contains(d3, d2)) {
            return false;
        }
        int n = this.getNumPoints();
        if (n == 0) {
            return false;
        }
        double[] dArray = this.get(0);
        double d4 = dArray[0];
        double d5 = dArray[1];
        for (int i = 1; i < n; ++i) {
            dArray = this.get(i);
            double d6 = dArray[0];
            double d7 = dArray[1];
            if (this.getType(i) == MultiPath.a) {
                if (Geom.getSegSegIntersection(d6, d7, d4, d5, x1, y1, d3, y1, null) == Geom.INTERSECT) {
                    return false;
                }
                if (Geom.getSegSegIntersection(d6, d7, d4, d5, x1, y1, x1, d2, null) == Geom.INTERSECT) {
                    return false;
                }
                if (Geom.getSegSegIntersection(d6, d7, d4, d5, x1, d2, d3, d2, null) == Geom.INTERSECT) {
                    return false;
                }
                if (Geom.getSegSegIntersection(d6, d7, d4, d5, d3, y1, d3, d2, null) == Geom.INTERSECT) {
                    return false;
                }
            }
            d4 = d6;
            d5 = d7;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(Rectangle2D r) {
        void var1_1;
        return this.contains(r.getX(), r.getY(), r.getWidth(), var1_1.getHeight());
    }

    public boolean intersects(double x1, double y1, double w, double h) {
        if (this.contains(x1, y1)) {
            return true;
        }
        double d2 = y1 + h;
        if (this.contains(x1, d2)) {
            return true;
        }
        double d3 = x1 + w;
        if (this.contains(d3, y1)) {
            return true;
        }
        if (this.contains(d3, d2)) {
            return true;
        }
        int n = this.getNumPoints();
        if (n == 0) {
            return false;
        }
        double[] dArray = this.get(0);
        double d4 = dArray[0];
        double d5 = dArray[1];
        for (int i = 1; i < n; ++i) {
            dArray = this.get(i);
            double d6 = dArray[0];
            double d7 = dArray[1];
            if (this.getType(i) == MultiPath.a) {
                if (Geom.getSegSegIntersection(d6, d7, d4, d5, x1, y1, d3, y1, null) == Geom.INTERSECT) {
                    return true;
                }
                if (Geom.getSegSegIntersection(d6, d7, d4, d5, x1, y1, x1, d2, null) == Geom.INTERSECT) {
                    return true;
                }
                if (Geom.getSegSegIntersection(d6, d7, d4, d5, x1, d2, d3, d2, null) == Geom.INTERSECT) {
                    return true;
                }
                if (Geom.getSegSegIntersection(d6, d7, d4, d5, d3, y1, d3, d2, null) == Geom.INTERSECT) {
                    return true;
                }
                if (d6 >= x1 && d7 >= y1 && d6 <= d3 && d7 <= d2) {
                    return true;
                }
                if (d4 >= x1 && d5 >= y1 && d4 <= d3 && d5 <= d2) {
                    return true;
                }
            }
            d4 = d6;
            d5 = d7;
        }
        return false;
    }
}

