/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics;

import com.macrofocus.igraphics.CPColor;

public abstract class AbstractCPColor<Color>
implements CPColor<Color> {
    @Override
    public double lum() {
        int n = this.getRed();
        int n2 = this.getGreen();
        int n3 = this.getBlue();
        return 0.299 * (double)n + 0.587 * (double)n2 + 0.114 * (double)n3;
    }

    @Override
    public float luminance() {
        int n = this.getRed();
        int n2 = this.getGreen();
        int n3 = this.getBlue();
        return (0.299f * (float)n + 0.587f * (float)n2 + 0.114f * (float)n3) / 255.0f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float diff(CPColor c2) {
        void var1_1;
        int n = Math.abs(this.getRed() - c2.getRed());
        int n2 = Math.abs(this.getGreen() - c2.getGreen());
        int n3 = Math.abs(this.getBlue() - var1_1.getBlue());
        return (float)Math.max(n, Math.max(n2, n3)) / 255.0f;
    }

    @Override
    public String toHTMLColor() {
        String string;
        String string2 = Integer.toHexString(this.getRed());
        String string3 = Integer.toHexString(this.getBlue());
        String string4 = Integer.toHexString(this.getGreen());
        string = this.getAlpha() == 255 ? "" : ((string = Integer.toHexString(this.getAlpha())).length() == 1 ? "0" + string : string);
        string2 = string2.length() == 1 ? "0" + string2 : string2;
        string3 = string3.length() == 1 ? "0" + string3 : string3;
        string4 = string4.length() == 1 ? "0" + string4 : string4;
        return "#" + string + string2 + string4 + string3;
    }

    @Override
    public String toJavaScriptColor() {
        if (this.getAlpha() == 255) {
            return this.toHTMLColor();
        }
        return "rgba(" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + "," + (double)this.getAlpha() / 255.0 + ")";
    }

    @Override
    public float brightness() {
        float[] fArray = AbstractCPColor.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
        return fArray[2];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CPColor<Color> replaceBrightness(double brightness) {
        void var1_1;
        float[] fArray = AbstractCPColor.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
        CPColor<Color> cPColor = this.getHSBColor(fArray[0], fArray[1], (float)var1_1);
        return cPColor;
    }

    /*
     * WARNING - void declaration
     */
    public CPColor<Color> getHSBColor(float h, float s, float b2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.create(AbstractCPColor.HSBtoRGB((float)var1_1, (float)var2_2, (float)var3_3));
    }

    protected abstract CPColor<Color> create(int var1);

    /*
     * WARNING - void declaration
     */
    protected CPColor<Color> create(int r, int g2, int b2, int a2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.create((a2 & 0xFF) << 24 | (var1_1 & 0xFF) << 16 | (var2_2 & 0xFF) << 8 | var3_3 & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] RGBtoHSB(int r, int g2, int b2, float[] hsbvals) {
        void var3_5;
        float f2;
        int n;
        int n2;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n3 = n2 = r > g2 ? r : g2;
        if (b2 > n2) {
            n2 = b2;
        }
        int n4 = n = r < g2 ? r : g2;
        if (b2 < n) {
            n = b2;
        }
        float f3 = (float)n2 / 255.0f;
        float f4 = n2 != 0 ? (float)(n2 - n) / (float)n2 : 0.0f;
        if (f4 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f5;
            void var1_2;
            void var2_3;
            int n5;
            float f6 = (float)(n2 - n5) / (float)(n2 - n);
            float f7 = (float)(n2 - g2) / (float)(n2 - n);
            float f8 = (float)(n2 - var2_3) / (float)(n2 - n);
            f2 = n5 == n2 ? f8 - f7 : (var1_2 == n2 ? f6 + 2.0f - f8 : f7 + 4.0f - f6);
            f2 /= 6.0f;
            if (f5 < 0.0f) {
                f2 += 1.0f;
            }
        }
        hsbvals[0] = f2;
        hsbvals[1] = f4;
        hsbvals[2] = f3;
        return var3_5;
    }

    /*
     * WARNING - void declaration
     */
    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (saturation == 0.0f) {
            n2 = n3 = (int)(brightness * 255.0f + 0.5f);
            n = n3;
        } else {
            float f2;
            float f3;
            float f4 = f3;
            f3 = (f4 - (float)Math.floor(f4)) * 6.0f;
            float f5 = f3 - (float)Math.floor(f3);
            float f6 = brightness * (1.0f - saturation);
            float f7 = brightness * (1.0f - saturation * f5);
            f2 = brightness * (1.0f - f2 * (1.0f - f5));
            switch ((int)f3) {
                case 0: {
                    n = (int)(brightness * 255.0f + 0.5f);
                    n2 = (int)(f2 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n = (int)(f7 * 255.0f + 0.5f);
                    n2 = (int)(brightness * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(brightness * 255.0f + 0.5f);
                    n3 = (int)(f2 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n = (int)(f2 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    void var2_2;
                    n = (int)(var2_2 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    @Override
    public CPColor<Color> brighter() {
        int n = this.getRed();
        int n2 = this.getGreen();
        int n3 = this.getBlue();
        int n4 = this.getAlpha();
        if (n == 0 && n2 == 0 && n3 == 0) {
            return this.create(3, 3, 3, n4);
        }
        if (n > 0 && n < 3) {
            n = 3;
        }
        if (n2 > 0 && n2 < 3) {
            n2 = 3;
        }
        if (n3 > 0 && n3 < 3) {
            n3 = 3;
        }
        return this.create(Math.min((int)((double)n / 0.7), 255), Math.min((int)((double)n2 / 0.7), 255), Math.min((int)((double)n3 / 0.7), 255), n4);
    }

    @Override
    public CPColor<Color> darker() {
        AbstractCPColor abstractCPColor = this;
        return abstractCPColor.create(Math.max((int)((double)abstractCPColor.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0), this.getAlpha());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CPColor<Color> getTranslucentColor(int alpha) {
        void var1_1;
        if (alpha == 255) {
            return this;
        }
        AbstractCPColor abstractCPColor = this;
        return abstractCPColor.create(abstractCPColor.getRed(), this.getGreen(), this.getBlue(), (int)var1_1);
    }
}

