/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.labeling;

import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Properties;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;

public class EnhancedLabel<Color, Font> {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int LEADING = 10;
    public static final int TRAILING = 11;
    public static final int NEXT = 12;
    private boolean a;
    private MutableProperties<String> b = new SimpleProperties();
    private MutableProperty<Rendering> c = this.b.createProperty((Object)"rendering", (Object)Rendering.Clip);
    private MutableProperty<Boolean> d = this.b.createProperty((Object)"justified", (Object)Boolean.FALSE);
    private MutableProperty<Effect> e = this.b.createProperty((Object)"effect", (Object)Effect.Plain);
    private MutableProperty<Float> f = this.b.createProperty((Object)"effectOpacity", (Object)Float.valueOf(0.43137255f));
    private MutableProperty<Integer> g = this.b.createProperty((Object)"minimumCharactersToDisplay", null);
    private MutableProperty<Double> h = this.b.createProperty((Object)"angle", (Object)0.0);
    private MutableProperty<Integer> i = this.b.createProperty((Object)"desiredWidth", (Object)Integer.MAX_VALUE);
    private MutableProperty<Integer> j = this.b.createProperty((Object)"desiredHeight", (Object)Integer.MAX_VALUE);
    private MutableProperty<String> k = this.b.createProperty((Object)"text", null);
    private MutableProperty<Boolean> l = this.b.createProperty((Object)"html", (Object)Boolean.FALSE);
    private MutableProperty<CPFont<Font>> m = this.b.createProperty((Object)"font", null);
    private MutableProperty<Integer> n = this.b.createProperty((Object)"verticalAlignment", (Object)0);
    private MutableProperty<Integer> o = this.b.createProperty((Object)"horizontalAlignment", (Object)10);
    private MutableProperty<Integer> p = this.b.createProperty((Object)"width", null);
    private MutableProperty<Integer> q = this.b.createProperty((Object)"height", null);
    private MutableProperty<Integer> r = this.b.createProperty((Object)"insetTop", (Object)0);
    private MutableProperty<Integer> s = this.b.createProperty((Object)"insetLeft", (Object)0);
    private MutableProperty<Integer> t = this.b.createProperty((Object)"insetBottom", (Object)0);
    private MutableProperty<Integer> u = this.b.createProperty((Object)"insetRight", (Object)0);
    private MutableProperty<CPColor<Color>> v = this.b.createProperty((Object)"background", null);
    private MutableProperty<CPColor<Color>> w = this.b.createProperty((Object)"foreground", null);
    private MutableProperty<Boolean> x = this.b.createProperty((Object)"enabled", (Object)Boolean.TRUE);
    private MutableProperty<String> y = this.b.createProperty((Object)"name", null);

    /*
     * WARNING - void declaration
     */
    public void setOpaque(boolean opaque) {
        void var1_1;
        this.a = var1_1;
    }

    public boolean isOpaque() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public EnhancedLabel(String text) {
        this();
        void var1_1;
        this.setText((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.y.setValue((Object)var1_1);
    }

    public String getName() {
        return (String)this.y.getValue();
    }

    public EnhancedLabel() {
        this.setVerticalAlignment(1);
    }

    public Properties<String> getProperties() {
        return this.b;
    }

    public String getText() {
        return (String)this.k.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setText(String text) {
        void var1_1;
        this.k.setValue((Object)var1_1);
    }

    public boolean isHTML() {
        return (Boolean)this.l.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setHTML(boolean html) {
        void var1_1;
        this.l.setValue((Object)((boolean)var1_1));
    }

    public CPFont<Font> getFont() {
        return (CPFont)this.m.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setFont(CPFont<Font> font) {
        void var1_1;
        assert (font != null);
        this.m.setValue((Object)var1_1);
    }

    public int getVerticalAlignment() {
        return (Integer)this.n.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setVerticalAlignment(int verticalAlignment) {
        void var1_1;
        this.n.setValue((Object)((int)var1_1));
    }

    public int getHorizontalAlignment() {
        return (Integer)this.o.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setHorizontalAlignment(int horizontalAlignment) {
        void var1_1;
        this.o.setValue((Object)((int)var1_1));
    }

    public int getHeight() {
        return (Integer)this.q.getValue();
    }

    public int getWidth() {
        return (Integer)this.p.getValue();
    }

    public CPColor<Color> getBackground() {
        return (CPColor)this.v.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setBackground(CPColor<Color> background) {
        void var1_1;
        this.v.setValue((Object)var1_1);
    }

    public CPColor<Color> getForeground() {
        return (CPColor)this.w.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setForeground(CPColor<Color> foreground) {
        void var1_1;
        this.w.setValue((Object)var1_1);
    }

    public boolean isEnabled() {
        return (Boolean)this.x.getValue();
    }

    public Integer getInsetTop() {
        return (Integer)this.r.getValue();
    }

    public Integer getInsetLeft() {
        return (Integer)this.s.getValue();
    }

    public Integer getInsetBottom() {
        return (Integer)this.t.getValue();
    }

    public Integer getInsetRight() {
        return (Integer)this.u.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setInsetTop(Integer value) {
        void var1_1;
        this.r.setValue((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setInsetLeft(Integer value) {
        void var1_1;
        this.s.setValue((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setInsetBottom(Integer value) {
        void var1_1;
        this.t.setValue((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setInsetRight(Integer value) {
        void var1_1;
        this.u.setValue((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setInsets(int top, int left, int bottom, int right) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.r.setValue((Object)((int)var1_1));
        this.s.setValue((Object)((int)var2_2));
        this.t.setValue((Object)((int)var3_3));
        this.u.setValue((Object)right);
    }

    public Effect getEffect() {
        return (Effect)((Object)this.e.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public void setEffect(Effect effect) {
        void var1_1;
        this.e.setValue((Object)var1_1);
    }

    public float getEffectOpacity() {
        return ((Float)this.f.getValue()).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setEffectOpacity(float effectOpacity) {
        void var1_1;
        this.f.setValue((Object)Float.valueOf((float)var1_1));
    }

    public Rendering getRendering() {
        return (Rendering)((Object)this.c.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public void setRendering(Rendering rendering) {
        void var1_1;
        this.c.setValue((Object)var1_1);
    }

    public Integer getMinimumCharactersToDisplay() {
        return (Integer)this.g.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setMinimumCharactersToDisplay(Integer minimumCharactersToDisplay) {
        void var1_1;
        this.g.setValue((Object)var1_1);
    }

    public boolean isJustified() {
        return (Boolean)this.d.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setJustified(boolean justified) {
        void var1_1;
        this.d.setValue((Object)((boolean)var1_1));
    }

    public double getAngle() {
        return (Double)this.h.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setAngle(double angle) {
        void var1_1;
        this.h.setValue((Object)((double)var1_1));
    }

    public Integer getDesiredWidth() {
        return (Integer)this.i.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setDesiredWidth(Integer desiredSize) {
        void var1_1;
        this.i.setValue((Object)var1_1);
    }

    public Integer getDesiredHeight() {
        return (Integer)this.j.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setDesiredHeight(Integer desiredSize) {
        void var1_1;
        this.j.setValue((Object)var1_1);
    }

    public static enum ContrastEnhancement {
        Off{

            @Override
            public final <Color> CPColor<Color> adjustLabelColor(CPColor<Color> foreground, CPColor<Color> background) {
                return foreground;
            }
        }
        ,
        Brightness{

            /*
             * WARNING - void declaration
             */
            @Override
            public final <Color> CPColor<Color> adjustLabelColor(CPColor<Color> foreground, CPColor<Color> background) {
                CPColor<Color> cPColor;
                float f2;
                float f3 = foreground.diff(background);
                if (f2 <= 0.5f) {
                    void var2_2;
                    double d2 = foreground.brightness();
                    CPColor<Color> cPColor2 = foreground.replaceBrightness(Math.min(1.0, d2 + (double)(0.5f - f3)));
                    cPColor = foreground.replaceBrightness(Math.max(0.0, d2 - (double)(0.5f - f3)));
                    float f4 = var2_2.luminance();
                    f3 = Math.abs(cPColor2.luminance() - f4);
                    if (f3 > (f4 = Math.abs(cPColor.luminance() - f4))) {
                        cPColor = cPColor2;
                    }
                    return cPColor;
                }
                return cPColor;
            }
        }
        ,
        BlackWhite{

            /*
             * WARNING - void declaration
             */
            @Override
            public final <Color> CPColor<Color> adjustLabelColor(CPColor<Color> foreground, CPColor<Color> background) {
                void var1_1;
                float f2;
                float f3 = foreground.diff(background);
                if (f2 <= 0.5f) {
                    double d2;
                    void var2_2;
                    double d3 = var2_2.lum();
                    if (d2 >= 186.0) {
                        return foreground.getFactory().getBlack();
                    }
                    return foreground.getFactory().getWhite();
                }
                return var1_1;
            }

            public final String toString() {
                return "Black&White";
            }
        }
        ,
        Complement{

            /*
             * WARNING - void declaration
             */
            @Override
            public final <Color> CPColor<Color> adjustLabelColor(CPColor<Color> foreground, CPColor<Color> background) {
                void var1_1;
                float f2;
                float f3 = foreground.diff(background);
                if (f2 <= 0.5f) {
                    void var2_2;
                    int n = foreground.getAlpha();
                    int n2 = foreground.getRed();
                    int n3 = foreground.getBlue();
                    int n4 = foreground.getBlue();
                    n2 = ~n2 & 0xFF;
                    n3 = ~n3 & 0xFF;
                    n4 = ~n4 & 0xFF;
                    CPColor<Color> cPColor = foreground.getFactory().createRGBAColor(n2, n4, n3, n);
                    float f4 = var2_2.luminance();
                    float f5 = Math.abs(foreground.luminance() - f4);
                    if (!(f5 > (f4 = Math.abs(cPColor.luminance() - f4)))) {
                        foreground = cPColor;
                    }
                    return foreground;
                }
                return var1_1;
            }
        };


        private ContrastEnhancement() {
        }

        public abstract <Color> CPColor<Color> adjustLabelColor(CPColor<Color> var1, CPColor<Color> var2);

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ContrastEnhancement(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }
    }

    public static enum Effect {
        Plain,
        Shadow,
        Glow,
        Outline,
        Emphasize;

    }

    public static enum Rendering {
        Truncate,
        Clip,
        WordWrap;

    }
}

