/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.palette;

import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.palette.AbstractPalette;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.Palette;
import com.macrofocus.palette.PaletteListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;

@JsType
public class FixedPalette<Color>
extends AbstractPalette<Color>
implements MutablePalette<Color> {
    protected List<CPColor<Color>> colors;
    private boolean a = false;

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public FixedPalette(CPColorFactory<Color> factory, int ... colors) {
        this((CPColorFactory<Color>)var1_1, false, (int[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public FixedPalette(CPColorFactory<Color> factory, boolean inverted, int ... colors) {
        this(false, FixedPalette.a(var1_1, (int[])var3_3));
        void var3_3;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public FixedPalette(CPColor<Color> ... colors) {
        this(false, Arrays.asList(var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public FixedPalette(boolean inverted, CPColor<Color> ... colors) {
        this((boolean)var1_1, Arrays.asList(var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public FixedPalette(List<CPColor<Color>> colors) {
        this(false, (List<CPColor<Color>>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FixedPalette(boolean inverted, List<CPColor<Color>> colors) {
        void var1_1;
        void var2_2;
        this.colors = colors != null ? new ArrayList<CPColor<Color>>(colors) : null;
        this.colorCount = var2_2 != null ? this.colors.size() : 0;
        this.a = var1_1;
    }

    private static <Color> List<CPColor<Color>> a(CPColorFactory<Color> cPColorFactory, int[] nArray) {
        ArrayList<CPColor<Color>> arrayList = new ArrayList<CPColor<Color>>(nArray.length);
        for (int n : nArray) {
            arrayList.add(cPColorFactory.createColor(n));
        }
        return arrayList;
    }

    @Override
    public boolean isInverted() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CPColor<Color> getColor(double fraction) {
        void var1_1;
        boolean bl = this.isInverted();
        switch (this.getCycle()) {
            case REFLECT: {
                bl = (int)fraction % 2 == 0;
            }
            case REPEAT: {
                double d2 = fraction;
                fraction = d2 - (double)((int)d2);
            }
        }
        if (fraction < this.getLowestFraction()) {
            FixedPalette fixedPalette = this;
            return fixedPalette.getColor(fixedPalette.getLowestFraction());
        }
        if (fraction > this.getHighestFraction()) {
            FixedPalette fixedPalette = this;
            return fixedPalette.getColor(fixedPalette.getHighestFraction());
        }
        int n = this.getEntry(!bl ? fraction : 1.0 - var1_1, this.colorCount, this.colors.size());
        return this.colors.get(n);
    }

    protected double getLowestFraction() {
        return 0.0;
    }

    protected double getHighestFraction() {
        return 1.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CPColor<Color> getColorAt(int index) {
        void var1_1;
        if (this.colorCount == this.colors.size()) {
            if (index < 0) {
                return this.getColorAt(0);
            }
            if (index > this.colorCount - 1) {
                FixedPalette fixedPalette = this;
                return fixedPalette.getColorAt(fixedPalette.colorCount - 1);
            }
            return this.colors.get(index);
        }
        FixedPalette fixedPalette = this;
        return fixedPalette.getColor((double)fixedPalette.colorCount / (double)var1_1);
    }

    @Override
    public int getColorCount() {
        return this.colorCount;
    }

    @Override
    public void addPaletteListener(PaletteListener listener) {
    }

    @Override
    public void removePaletteListener(PaletteListener listener) {
    }

    @Override
    public void setColorCount(int binCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCycle(Palette.Cycle cycle) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getColor(0.0) + "-" + this.getColor(1.0);
    }
}

