/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectEntityWithUniqueID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.Resource;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

public final class ProjectCalendar
extends ProjectCalendarWeek
implements ProjectEntityWithUniqueID {
    private ProjectFile m_projectFile;
    private Integer m_uniqueID = 0;
    private List<ProjectCalendarException> m_exceptions = new ArrayList<ProjectCalendarException>();
    private List<ProjectCalendarException> m_expandedExceptions = new ArrayList<ProjectCalendarException>();
    private boolean m_exceptionsSorted;
    private boolean m_weeksSorted;
    private Resource m_resource;
    private ArrayList<ProjectCalendar> m_derivedCalendars = new ArrayList();
    private Map<DateRange, Long> m_workingDateCache = new WeakHashMap<DateRange, Long>();
    private Map<Date, Date> m_startTimeCache = new WeakHashMap<Date, Date>();
    private Date m_getDateLastStartDate;
    private double m_getDateLastRemainingMinutes;
    private Date m_getDateLastResult;
    private ArrayList<ProjectCalendarWeek> m_workWeeks = new ArrayList();
    private Integer m_minutesPerDay;
    private Integer m_minutesPerWeek;
    private Integer m_minutesPerMonth;
    private Integer m_minutesPerYear;
    public static final String DEFAULT_BASE_CALENDAR_NAME = "Standard";
    private static final int MAX_NONWORKING_DAYS = 1000;

    public ProjectCalendar(ProjectFile file) {
        this.m_projectFile = file;
        if (file.getProjectConfig().getAutoCalendarUniqueID()) {
            this.setUniqueID(file.getProjectConfig().getNextCalendarUniqueID());
        }
    }

    public int getMinutesPerDay() {
        return this.m_minutesPerDay == null ? NumberHelper.getInt(this.getParentFile().getProjectProperties().getMinutesPerDay()) : this.m_minutesPerDay;
    }

    public int getMinutesPerWeek() {
        return this.m_minutesPerWeek == null ? NumberHelper.getInt(this.getParentFile().getProjectProperties().getMinutesPerWeek()) : this.m_minutesPerWeek;
    }

    public int getMinutesPerMonth() {
        return this.m_minutesPerMonth == null ? NumberHelper.getInt(this.getParentFile().getProjectProperties().getMinutesPerMonth()) : this.m_minutesPerMonth;
    }

    public int getMinutesPerYear() {
        return this.m_minutesPerYear == null ? NumberHelper.getInt(this.getParentFile().getProjectProperties().getMinutesPerYear()) : this.m_minutesPerYear;
    }

    public void setMinutesPerDay(Integer minutes) {
        this.m_minutesPerDay = minutes;
    }

    public void setMinutesPerWeek(Integer minutes) {
        this.m_minutesPerWeek = minutes;
    }

    public void setMinutesPerMonth(Integer minutes) {
        this.m_minutesPerMonth = minutes;
    }

    public void setMinutesPerYear(Integer minutes) {
        this.m_minutesPerYear = minutes;
    }

    public ProjectCalendarWeek addWorkWeek() {
        ProjectCalendarWeek week = new ProjectCalendarWeek();
        week.setParent(this);
        this.m_workWeeks.add(week);
        this.m_weeksSorted = false;
        this.clearWorkingDateCache();
        return week;
    }

    public void clearWorkWeeks() {
        this.m_workWeeks.clear();
        this.m_weeksSorted = false;
        this.clearWorkingDateCache();
    }

    public List<ProjectCalendarWeek> getWorkWeeks() {
        return this.m_workWeeks;
    }

    public ProjectCalendarException addCalendarException(Date fromDate, Date toDate) {
        ProjectCalendarException bce = new ProjectCalendarException(fromDate, toDate);
        this.m_exceptions.add(bce);
        this.m_expandedExceptions.clear();
        this.m_exceptionsSorted = false;
        this.clearWorkingDateCache();
        return bce;
    }

    public void clearCalendarExceptions() {
        this.m_exceptions.clear();
        this.m_expandedExceptions.clear();
        this.m_exceptionsSorted = false;
        this.clearWorkingDateCache();
    }

    public List<ProjectCalendarException> getCalendarExceptions() {
        this.sortExceptions();
        return this.m_exceptions;
    }

    @Override
    public ProjectCalendarHours addCalendarHours(Day day) {
        this.clearWorkingDateCache();
        return super.addCalendarHours(day);
    }

    @Override
    public void attachHoursToDay(ProjectCalendarHours hours) {
        this.clearWorkingDateCache();
        super.attachHoursToDay(hours);
    }

    @Override
    public void removeHoursFromDay(ProjectCalendarHours hours) {
        this.clearWorkingDateCache();
        super.removeHoursFromDay(hours);
    }

    public void setParent(ProjectCalendar calendar) {
        if (calendar != this) {
            if (this.getParent() != null) {
                this.getParent().removeDerivedCalendar(this);
            }
            super.setParent(calendar);
            if (calendar != null) {
                calendar.addDerivedCalendar(this);
            }
            this.clearWorkingDateCache();
        }
    }

    @Override
    public ProjectCalendar getParent() {
        return (ProjectCalendar)super.getParent();
    }

    public boolean isWorkingDay(Day day) {
        ProjectCalendar cal;
        DayType value = this.getWorkingDay(day);
        boolean result = value == DayType.DEFAULT ? ((cal = this.getParent()) != null ? cal.isWorkingDay(day) : day != Day.SATURDAY && day != Day.SUNDAY) : value == DayType.WORKING;
        return result;
    }

    public Duration getDuration(Date startDate, Date endDate) {
        Calendar cal = DateHelper.popCalendar(startDate);
        int days = this.getDaysInRange(startDate, endDate);
        int duration = 0;
        Day day = Day.getInstance(cal.get(7));
        while (days > 0) {
            if (this.isWorkingDate(cal.getTime(), day)) {
                ++duration;
            }
            --days;
            day = day.getNextDay();
            cal.set(6, cal.get(6) + 1);
        }
        DateHelper.pushCalendar(cal);
        return Duration.getInstance(duration, TimeUnit.DAYS);
    }

    public Date getStartTime(Date date) {
        Date result = this.m_startTimeCache.get(date);
        if (result == null) {
            ProjectCalendarDateRanges ranges = this.getRanges(date, null, null);
            result = ranges == null ? this.getParentFile().getProjectProperties().getDefaultStartTime() : ranges.getRange(0).getStart();
            result = DateHelper.getCanonicalTime(result);
            this.m_startTimeCache.put(new Date(date.getTime()), result);
        }
        return result;
    }

    public Date getFinishTime(Date date) {
        Date result = null;
        if (date != null) {
            ProjectCalendarDateRanges ranges = this.getRanges(date, null, null);
            if (ranges == null) {
                result = this.getParentFile().getProjectProperties().getDefaultEndTime();
                result = DateHelper.getCanonicalTime(result);
            } else {
                Date rangeStart = result = ranges.getRange(0).getStart();
                Date rangeFinish = ranges.getRange(ranges.getRangeCount() - 1).getEnd();
                Date startDay = DateHelper.getDayStartDate(rangeStart);
                Date finishDay = DateHelper.getDayStartDate(rangeFinish);
                result = DateHelper.getCanonicalTime(rangeFinish);
                if (startDay != null && finishDay != null && startDay.getTime() != finishDay.getTime()) {
                    result = DateHelper.addDays(result, 1);
                }
            }
        }
        return result;
    }

    public Date getDate(Date startDate, Duration duration, boolean returnNextWorkStart) {
        ProjectProperties properties = this.getParentFile().getProjectProperties();
        double remainingMinutes = NumberHelper.round(duration.convertUnits(TimeUnit.MINUTES, properties).getDuration(), 2.0);
        Date getDateLastStartDate = this.m_getDateLastStartDate;
        double getDateLastRemainingMinutes = this.m_getDateLastRemainingMinutes;
        this.m_getDateLastStartDate = startDate;
        this.m_getDateLastRemainingMinutes = remainingMinutes;
        if (this.m_getDateLastResult != null && DateHelper.compare(startDate, getDateLastStartDate) == 0 && remainingMinutes >= getDateLastRemainingMinutes) {
            startDate = this.m_getDateLastResult;
            remainingMinutes -= getDateLastRemainingMinutes;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        while (remainingMinutes > 0.0) {
            Date currentDate = cal.getTime();
            endCal.setTime(currentDate);
            endCal.add(6, 1);
            Date currentDateEnd = DateHelper.getDayStartDate(endCal.getTime());
            double currentDateWorkingMinutes = this.getWork(currentDate, currentDateEnd, TimeUnit.MINUTES).getDuration();
            if (remainingMinutes > currentDateWorkingMinutes) {
                Day day;
                remainingMinutes = NumberHelper.round(remainingMinutes - currentDateWorkingMinutes, 2.0);
                int nonWorkingDayCount = 0;
                do {
                    cal.add(6, 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(startDate);
                    cal.add(6, 1);
                    remainingMinutes = 0.0;
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                Date startTime = this.getStartTime(cal.getTime());
                DateHelper.setTime(cal, startTime);
                continue;
            }
            ProjectCalendarDateRanges ranges = this.getRanges(cal.getTime(), cal, null);
            Date endTime = null;
            Date currentDateStartTime = DateHelper.getCanonicalTime(currentDate);
            boolean firstRange = true;
            for (DateRange range : ranges) {
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canonicalRangeEnd = DateHelper.getCanonicalTime(rangeEnd);
                Date canonicalRangeStart = DateHelper.getCanonicalTime(rangeStart);
                Date rangeStartDay = DateHelper.getDayStartDate(rangeStart);
                Date rangeEndDay = DateHelper.getDayStartDate(rangeEnd);
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    canonicalRangeEnd = DateHelper.addDays(canonicalRangeEnd, 1);
                }
                if (firstRange && canonicalRangeEnd.getTime() < currentDateStartTime.getTime()) continue;
                if (firstRange && canonicalRangeStart.getTime() < currentDateStartTime.getTime()) {
                    canonicalRangeStart = currentDateStartTime;
                }
                firstRange = false;
                double rangeMinutes = canonicalRangeEnd.getTime() - canonicalRangeStart.getTime();
                if (remainingMinutes > (rangeMinutes /= 60000.0)) {
                    remainingMinutes = NumberHelper.round(remainingMinutes - rangeMinutes, 2.0);
                    continue;
                }
                if (Duration.durationValueEquals(remainingMinutes, rangeMinutes)) {
                    endTime = canonicalRangeEnd;
                    if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                        cal.add(6, 1);
                    }
                } else {
                    endTime = new Date((long)((double)canonicalRangeStart.getTime() + remainingMinutes * 60000.0));
                    returnNextWorkStart = false;
                }
                remainingMinutes = 0.0;
                break;
            }
            DateHelper.setTime(cal, endTime);
        }
        this.m_getDateLastResult = cal.getTime();
        if (returnNextWorkStart) {
            this.updateToNextWorkStart(cal);
        }
        return cal.getTime();
    }

    public Date getStartDate(Date finishDate, Duration duration) {
        ProjectProperties properties = this.getParentFile().getProjectProperties();
        double remainingMinutes = NumberHelper.round(duration.convertUnits(TimeUnit.MINUTES, properties).getDuration(), 2.0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(finishDate);
        Calendar startCal = Calendar.getInstance();
        while (remainingMinutes > 0.0) {
            Date currentDate = cal.getTime();
            startCal.setTime(currentDate);
            startCal.add(6, -1);
            Date currentDateEnd = DateHelper.getDayEndDate(startCal.getTime());
            double currentDateWorkingMinutes = this.getWork(currentDateEnd, currentDate, TimeUnit.MINUTES).getDuration();
            if (remainingMinutes > currentDateWorkingMinutes) {
                int count;
                remainingMinutes = NumberHelper.round(remainingMinutes - currentDateWorkingMinutes, 2.0);
                for (count = 0; count <= 7; ++count) {
                    cal.add(6, -1);
                    Day day = Day.getInstance(cal.get(7));
                    if (!this.isWorkingDate(cal.getTime(), day)) continue;
                }
                if (count > 7) {
                    return null;
                }
                Date finishTime = this.getFinishTime(cal.getTime());
                DateHelper.setTime(cal, finishTime);
                continue;
            }
            ProjectCalendarDateRanges ranges = this.getRanges(cal.getTime(), cal, null);
            Date startTime = null;
            Date currentDateFinishTime = DateHelper.getCanonicalTime(currentDate);
            boolean firstRange = true;
            for (int i = ranges.getRangeCount() - 1; i >= 0; --i) {
                DateRange range = ranges.getRange(i);
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canonicalRangeEnd = DateHelper.getCanonicalTime(rangeEnd);
                Date canonicalRangeStart = DateHelper.getCanonicalTime(rangeStart);
                Date rangeStartDay = DateHelper.getDayStartDate(rangeStart);
                Date rangeEndDay = DateHelper.getDayStartDate(rangeEnd);
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    canonicalRangeEnd = DateHelper.addDays(canonicalRangeEnd, 1);
                }
                if (firstRange && canonicalRangeStart.getTime() > currentDateFinishTime.getTime()) continue;
                if (firstRange && canonicalRangeEnd.getTime() > currentDateFinishTime.getTime()) {
                    canonicalRangeEnd = currentDateFinishTime;
                }
                firstRange = false;
                double rangeMinutes = canonicalRangeEnd.getTime() - canonicalRangeStart.getTime();
                if (remainingMinutes > (rangeMinutes /= 60000.0)) {
                    remainingMinutes = NumberHelper.round(remainingMinutes - rangeMinutes, 2.0);
                    continue;
                }
                startTime = Duration.durationValueEquals(remainingMinutes, rangeMinutes) ? canonicalRangeStart : new Date((long)((double)canonicalRangeEnd.getTime() - remainingMinutes * 60000.0));
                remainingMinutes = 0.0;
                break;
            }
            DateHelper.setTime(cal, startTime);
        }
        return cal.getTime();
    }

    private void updateToNextWorkStart(Calendar cal) {
        Date originalDate = cal.getTime();
        ProjectCalendarDateRanges ranges = this.getRanges(originalDate, cal, null);
        if (ranges != null) {
            Date calTime = DateHelper.getCanonicalTime(cal.getTime());
            Date startTime = null;
            for (DateRange range : ranges) {
                Date rangeStart = DateHelper.getCanonicalTime(range.getStart());
                Date rangeEnd = DateHelper.getCanonicalTime(range.getEnd());
                Date rangeStartDay = DateHelper.getDayStartDate(range.getStart());
                Date rangeEndDay = DateHelper.getDayStartDate(range.getEnd());
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    rangeEnd = DateHelper.addDays(rangeEnd, 1);
                }
                if (calTime.getTime() >= rangeEnd.getTime()) continue;
                if (calTime.getTime() > rangeStart.getTime()) {
                    startTime = calTime;
                    break;
                }
                startTime = rangeStart;
                break;
            }
            if (startTime == null) {
                Day day;
                int nonWorkingDayCount = 0;
                do {
                    cal.set(6, cal.get(6) + 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(originalDate);
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                startTime = this.getStartTime(cal.getTime());
            }
            DateHelper.setTime(cal, startTime);
        }
    }

    private void updateToPreviousWorkFinish(Calendar cal) {
        Date originalDate = cal.getTime();
        ProjectCalendarDateRanges ranges = this.getRanges(originalDate, cal, null);
        if (ranges != null) {
            Date calTime = DateHelper.getCanonicalTime(cal.getTime());
            Date finishTime = null;
            for (DateRange range : ranges) {
                Date rangeEnd = DateHelper.getCanonicalTime(range.getEnd());
                Date rangeStartDay = DateHelper.getDayStartDate(range.getStart());
                Date rangeEndDay = DateHelper.getDayStartDate(range.getEnd());
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    rangeEnd = DateHelper.addDays(rangeEnd, 1);
                }
                if (calTime.getTime() < rangeEnd.getTime()) continue;
                finishTime = rangeEnd;
                break;
            }
            if (finishTime == null) {
                Day day;
                int nonWorkingDayCount = 0;
                do {
                    cal.set(6, cal.get(6) - 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(originalDate);
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                finishTime = this.getFinishTime(cal.getTime());
            }
            DateHelper.setTime(cal, finishTime);
        }
    }

    public Date getNextWorkStart(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.updateToNextWorkStart(cal);
        return cal.getTime();
    }

    public Date getPreviousWorkFinish(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.updateToPreviousWorkFinish(cal);
        return cal.getTime();
    }

    public boolean isWorkingDate(Date date) {
        Calendar cal = DateHelper.popCalendar(date);
        Day day = Day.getInstance(cal.get(7));
        DateHelper.pushCalendar(cal);
        return this.isWorkingDate(date, day);
    }

    private boolean isWorkingDate(Date date, Day day) {
        ProjectCalendarDateRanges ranges = this.getRanges(date, null, day);
        return ranges.getRangeCount() != 0;
    }

    private int getDaysInRange(Date startDate, Date endDate) {
        int result;
        Calendar cal = DateHelper.popCalendar(endDate);
        int endDateYear = cal.get(1);
        int endDateDayOfYear = cal.get(6);
        cal.setTime(startDate);
        if (endDateYear == cal.get(1)) {
            result = endDateDayOfYear - cal.get(6) + 1;
        } else {
            result = 0;
            do {
                result += cal.getActualMaximum(6) - cal.get(6) + 1;
                cal.roll(1, 1);
                cal.set(6, 1);
            } while (cal.get(1) < endDateYear);
            result += endDateDayOfYear;
        }
        DateHelper.pushCalendar(cal);
        return result;
    }

    @Override
    public void setUniqueID(Integer uniqueID) {
        ProjectFile parent = this.getParentFile();
        if (this.m_uniqueID != null) {
            parent.getCalendars().unmapUniqueID(this.m_uniqueID);
        }
        parent.getCalendars().mapUniqueID(uniqueID, this);
        this.m_uniqueID = uniqueID;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public void setResource(Resource resource) {
        this.m_resource = resource;
        String name = this.m_resource.getName();
        if (name == null || name.length() == 0) {
            name = "Unnamed Resource";
        }
        this.setName(name);
    }

    public void remove() {
        this.getParentFile().removeCalendar(this);
    }

    public ProjectCalendarException getException(Date date) {
        ProjectCalendarException exception = null;
        this.populateExpandedExceptions();
        if (!this.m_expandedExceptions.isEmpty()) {
            this.sortExceptions();
            int low = 0;
            int high = this.m_expandedExceptions.size() - 1;
            long targetDate = date.getTime();
            while (low <= high) {
                int mid = low + high >>> 1;
                ProjectCalendarException midVal = this.m_expandedExceptions.get(mid);
                int cmp = 0 - DateHelper.compare(midVal.getFromDate(), midVal.getToDate(), targetDate);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                exception = midVal;
                break;
            }
        }
        if (exception == null && this.getParent() != null) {
            exception = this.getParent().getException(date);
        }
        return exception;
    }

    public ProjectCalendarWeek getWorkWeek(Date date) {
        ProjectCalendarWeek week = null;
        if (!this.m_workWeeks.isEmpty()) {
            this.sortWorkWeeks();
            int low = 0;
            int high = this.m_workWeeks.size() - 1;
            long targetDate = date.getTime();
            while (low <= high) {
                int mid = low + high >>> 1;
                ProjectCalendarWeek midVal = this.m_workWeeks.get(mid);
                int cmp = 0 - DateHelper.compare(midVal.getDateRange().getStart(), midVal.getDateRange().getEnd(), targetDate);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                week = midVal;
                break;
            }
        }
        if (week == null && this.getParent() != null) {
            week = this.getParent().getWorkWeek(date);
        }
        return week;
    }

    public Duration getWork(Date date, TimeUnit format) {
        ProjectCalendarDateRanges ranges = this.getRanges(date, null, null);
        long time = this.getTotalTime(ranges);
        return this.convertFormat(time, format);
    }

    public Duration getWork(Date startDate, Date endDate, TimeUnit format) {
        DateRange range = new DateRange(startDate, endDate);
        Long cachedResult = this.m_workingDateCache.get(range);
        long totalTime = 0L;
        if (cachedResult == null) {
            boolean invert = false;
            if (startDate.getTime() > endDate.getTime()) {
                invert = true;
                Date temp = startDate;
                startDate = endDate;
                endDate = temp;
            }
            Date canonicalStartDate = DateHelper.getDayStartDate(startDate);
            Date canonicalEndDate = DateHelper.getDayStartDate(endDate);
            if (canonicalStartDate.getTime() == canonicalEndDate.getTime()) {
                ProjectCalendarDateRanges ranges = this.getRanges(startDate, null, null);
                if (ranges.getRangeCount() != 0) {
                    totalTime = this.getTotalTime(ranges, startDate, endDate);
                }
            } else {
                ProjectCalendarDateRanges ranges;
                Date currentDate = startDate;
                Calendar cal = Calendar.getInstance();
                cal.setTime(startDate);
                Day day = Day.getInstance(cal.get(7));
                while (!this.isWorkingDate(currentDate, day) && currentDate.getTime() < canonicalEndDate.getTime()) {
                    cal.add(6, 1);
                    currentDate = cal.getTime();
                    day = day.getNextDay();
                }
                if (currentDate.getTime() < canonicalEndDate.getTime()) {
                    totalTime += this.getTotalTime(this.getRanges(currentDate, null, day), currentDate, true);
                    while (true) {
                        cal.add(6, 1);
                        currentDate = cal.getTime();
                        day = day.getNextDay();
                        if (currentDate.getTime() >= canonicalEndDate.getTime()) break;
                        ranges = this.getRanges(currentDate, null, day);
                        if (ranges.getRangeCount() == 0) continue;
                        totalTime += this.getTotalTime(ranges);
                    }
                }
                if ((ranges = this.getRanges(endDate, null, day)).getRangeCount() != 0) {
                    totalTime += this.getTotalTime(ranges, DateHelper.getDayStartDate(endDate), endDate);
                }
            }
            if (invert) {
                totalTime = -totalTime;
            }
            this.m_workingDateCache.put(range, totalTime);
        } else {
            totalTime = cachedResult;
        }
        return this.convertFormat(totalTime, format);
    }

    private Duration convertFormat(long totalTime, TimeUnit format) {
        double duration = totalTime;
        switch (format) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                duration /= 60000.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                duration /= 3600000.0;
                break;
            }
            case DAYS: {
                double minutesPerDay = this.getMinutesPerDay();
                if (minutesPerDay != 0.0) {
                    duration /= minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case WEEKS: {
                double minutesPerWeek = this.getMinutesPerWeek();
                if (minutesPerWeek != 0.0) {
                    duration /= minutesPerWeek * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case MONTHS: {
                double daysPerMonth = this.getParentFile().getProjectProperties().getDaysPerMonth().doubleValue();
                double minutesPerDay = this.getMinutesPerDay();
                if (daysPerMonth != 0.0 && minutesPerDay != 0.0) {
                    duration /= daysPerMonth * minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case ELAPSED_DAYS: {
                duration /= 8.64E7;
                break;
            }
            case ELAPSED_WEEKS: {
                duration /= 6.048E8;
                break;
            }
            case ELAPSED_MONTHS: {
                duration /= -1.702967296E9;
                break;
            }
            default: {
                throw new IllegalArgumentException("TimeUnit " + format + " not supported");
            }
        }
        return Duration.getInstance(duration, format);
    }

    private long getTotalTime(ProjectCalendarDateRanges exception, Date date, boolean after) {
        long currentTime = DateHelper.getCanonicalTime(date).getTime();
        long total = 0L;
        for (DateRange range : exception) {
            total += this.getTime(range.getStart(), range.getEnd(), currentTime, after);
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarDateRanges exception) {
        long total = 0L;
        for (DateRange range : exception) {
            total += this.getTime(range.getStart(), range.getEnd());
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarDateRanges hours, Date startDate, Date endDate) {
        long total = 0L;
        if (startDate.getTime() != endDate.getTime()) {
            Date start = DateHelper.getCanonicalTime(startDate);
            Date end = DateHelper.getCanonicalTime(endDate);
            for (DateRange range : hours) {
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canoncialRangeStart = DateHelper.getCanonicalTime(rangeStart);
                Date canonicalRangeEnd = DateHelper.getCanonicalTime(rangeEnd);
                Date startDay = DateHelper.getDayStartDate(rangeStart);
                Date finishDay = DateHelper.getDayStartDate(rangeEnd);
                if (startDay.getTime() != finishDay.getTime()) {
                    canonicalRangeEnd = DateHelper.addDays(canonicalRangeEnd, 1);
                }
                if (canoncialRangeStart.getTime() == canonicalRangeEnd.getTime() && rangeEnd.getTime() > rangeStart.getTime()) {
                    total += 86400000L;
                    continue;
                }
                total += this.getTime(start, end, canoncialRangeStart, canonicalRangeEnd);
            }
        }
        return total;
    }

    private long getTime(Date start, Date end, long target, boolean after) {
        long total = 0L;
        if (start != null && end != null) {
            int diff;
            Date startTime = DateHelper.getCanonicalTime(start);
            Date endTime = DateHelper.getCanonicalTime(end);
            Date startDay = DateHelper.getDayStartDate(start);
            Date finishDay = DateHelper.getDayStartDate(end);
            if (startDay.getTime() != finishDay.getTime()) {
                endTime = DateHelper.addDays(endTime, 1);
            }
            if ((diff = DateHelper.compare(startTime, endTime, target)) == 0) {
                total = after ? endTime.getTime() - target : target - startTime.getTime();
            } else if (after && diff < 0 || !after && diff > 0) {
                total = endTime.getTime() - startTime.getTime();
            }
        }
        return total;
    }

    private long getTime(Date start, Date end) {
        long total = 0L;
        if (start != null && end != null) {
            Date startTime = DateHelper.getCanonicalTime(start);
            Date endTime = DateHelper.getCanonicalTime(end);
            Date startDay = DateHelper.getDayStartDate(start);
            Date finishDay = DateHelper.getDayStartDate(end);
            if (startDay.getTime() != finishDay.getTime()) {
                endTime = DateHelper.addDays(endTime, 1);
            }
            total = endTime.getTime() - startTime.getTime();
        }
        return total;
    }

    private long getTime(Date start1, Date end1, Date start2, Date end2) {
        long end;
        long start;
        long total = 0L;
        if (start1 != null && end1 != null && start2 != null && end2 != null && (start = start1.getTime() < start2.getTime() ? start2.getTime() : start1.getTime()) < (end = end1.getTime() < end2.getTime() ? end1.getTime() : end2.getTime())) {
            total = end - start;
        }
        return total;
    }

    protected void addDerivedCalendar(ProjectCalendar calendar) {
        this.m_derivedCalendars.add(calendar);
    }

    protected void removeDerivedCalendar(ProjectCalendar calendar) {
        this.m_derivedCalendars.remove(calendar);
    }

    public List<ProjectCalendar> getDerivedCalendars() {
        return this.m_derivedCalendars;
    }

    @Override
    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[ProjectCalendar");
        pw.println("   ID=" + this.m_uniqueID);
        pw.println("   name=" + this.getName());
        pw.println("   baseCalendarName=" + (this.getParent() == null ? "" : this.getParent().getName()));
        pw.println("   resource=" + (this.m_resource == null ? "" : this.m_resource.getName()));
        for (Day day : Day.values()) {
            pw.println("   [Day " + day);
            pw.println("      type=" + this.getWorkingDay(day));
            pw.println("      hours=" + this.getHours(day));
            pw.println("   ]");
        }
        if (!this.m_exceptions.isEmpty()) {
            pw.println("   [Exceptions=");
            for (ProjectCalendarException ex : this.m_exceptions) {
                pw.println("      " + ex.toString());
            }
            pw.println("   ]");
        }
        if (!this.m_workWeeks.isEmpty()) {
            pw.println("   [WorkWeeks=");
            for (ProjectCalendarWeek week : this.m_workWeeks) {
                pw.println("      " + week.toString());
            }
            pw.println("   ]");
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }

    public ProjectCalendar(ProjectFile file, ProjectCalendar taskCalendar, ProjectCalendar resourceCalendar) {
        this.m_projectFile = file;
        this.setResource(resourceCalendar.getResource());
        block0: for (int i = 1; i <= 7; ++i) {
            Day day;
            this.setWorkingDay(day, taskCalendar.isWorkingDay(day = Day.getInstance(i)) && resourceCalendar.isWorkingDay(day));
            ProjectCalendarHours hours = this.addCalendarHours(day);
            int taskIndex = 0;
            int resourceIndex = 0;
            ProjectCalendarHours taskHours = taskCalendar.getHours(day);
            ProjectCalendarHours resourceHours = resourceCalendar.getHours(day);
            DateRange range1 = null;
            DateRange range2 = null;
            Date start = null;
            Date end = null;
            Date start1 = null;
            Date start2 = null;
            Date end1 = null;
            Date end2 = null;
            while (taskHours.getRangeCount() > taskIndex) {
                range1 = taskHours.getRange(taskIndex);
                if (resourceHours.getRangeCount() <= resourceIndex) continue block0;
                range2 = resourceHours.getRange(resourceIndex);
                start1 = range1.getStart();
                start2 = range2.getStart();
                end1 = range1.getEnd();
                end2 = range2.getEnd();
                start = start1.compareTo(start2) > 0 ? start1 : start2;
                if (end1.compareTo(end2) < 0) {
                    end = end1;
                    ++taskIndex;
                } else {
                    end = end2;
                    ++resourceIndex;
                }
                if (end == null || end.compareTo(start) <= 0) continue;
                hours.addRange(new DateRange(start, end));
            }
        }
        this.m_exceptions.addAll(taskCalendar.getCalendarExceptions());
        this.m_exceptions.addAll(resourceCalendar.getCalendarExceptions());
        this.m_expandedExceptions.clear();
        this.m_exceptionsSorted = false;
        this.m_workWeeks.addAll(taskCalendar.getWorkWeeks());
        this.m_workWeeks.addAll(resourceCalendar.getWorkWeeks());
        this.m_weeksSorted = false;
    }

    public void copy(ProjectCalendar cal) {
        this.setName(cal.getName());
        this.setParent(cal.getParent());
        System.arraycopy(cal.getDays(), 0, this.getDays(), 0, this.getDays().length);
        for (ProjectCalendarException ex : cal.m_exceptions) {
            ProjectCalendarException copyException = this.addCalendarException(ex.getFromDate(), ex.getToDate());
            for (DateRange range : ex) {
                copyException.addRange(new DateRange(range.getStart(), range.getEnd()));
            }
        }
        for (ProjectCalendarHours hours : this.getHours()) {
            if (hours == null) continue;
            ProjectCalendarHours copyHours = cal.addCalendarHours(hours.getDay());
            for (DateRange range : hours) {
                copyHours.addRange(new DateRange(range.getStart(), range.getEnd()));
            }
        }
    }

    private void clearWorkingDateCache() {
        this.m_workingDateCache.clear();
        this.m_startTimeCache.clear();
        this.m_getDateLastResult = null;
        for (ProjectCalendar calendar : this.m_derivedCalendars) {
            calendar.clearWorkingDateCache();
        }
    }

    private ProjectCalendarDateRanges getRanges(Date date, Calendar cal, Day day) {
        ProjectCalendarDateRanges ranges = this.getException(date);
        if (ranges == null) {
            ProjectCalendarWeek week = this.getWorkWeek(date);
            if (week == null) {
                week = this;
            }
            if (day == null) {
                if (cal == null) {
                    cal = Calendar.getInstance();
                    cal.setTime(date);
                }
                day = Day.getInstance(cal.get(7));
            }
            ranges = week.getHours(day);
        }
        return ranges;
    }

    private void sortExceptions() {
        if (!this.m_exceptionsSorted) {
            Collections.sort(this.m_exceptions);
            this.m_exceptionsSorted = true;
        }
    }

    private void populateExpandedExceptions() {
        if (!this.m_exceptions.isEmpty() && this.m_expandedExceptions.isEmpty()) {
            for (ProjectCalendarException exception : this.m_exceptions) {
                RecurringData recurring = exception.getRecurring();
                if (recurring == null) {
                    this.m_expandedExceptions.add(exception);
                    continue;
                }
                for (Date date : recurring.getDates()) {
                    Date startDate = DateHelper.getDayStartDate(date);
                    Date endDate = DateHelper.getDayEndDate(date);
                    ProjectCalendarException newException = new ProjectCalendarException(startDate, endDate);
                    int rangeCount = exception.getRangeCount();
                    for (int rangeIndex = 0; rangeIndex < rangeCount; ++rangeIndex) {
                        newException.addRange(exception.getRange(rangeIndex));
                    }
                    this.m_expandedExceptions.add(newException);
                }
            }
            Collections.sort(this.m_expandedExceptions);
        }
    }

    private void sortWorkWeeks() {
        if (!this.m_weeksSorted) {
            Collections.sort(this.m_workWeeks);
            this.m_weeksSorted = true;
        }
    }

    public final ProjectFile getParentFile() {
        return this.m_projectFile;
    }
}

