/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectEntityWithUniqueID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.ResourceRequestType;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedCostContainer;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkContainer;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.common.AssignmentFieldLists;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.FieldListener;

public final class ResourceAssignment
extends ProjectEntity
implements ProjectEntityWithUniqueID,
FieldContainer {
    private Object[] m_array = new Object[AssignmentField.MAX_VALUE];
    private boolean m_eventsEnabled = true;
    private TimephasedWorkContainer m_timephasedWork;
    private List<TimephasedCost> m_timephasedCost;
    private TimephasedWorkContainer m_timephasedActualWork;
    private List<TimephasedCost> m_timephasedActualCost;
    private TimephasedWorkContainer m_timephasedOvertimeWork;
    private TimephasedWorkContainer m_timephasedActualOvertimeWork;
    private List<FieldListener> m_listeners;
    private TimephasedWorkContainer[] m_timephasedBaselineWork = new TimephasedWorkContainer[11];
    private TimephasedCostContainer[] m_timephasedBaselineCost = new TimephasedCostContainer[11];
    private Task m_task;
    private ResourceAssignmentWorkgroupFields m_workgroup;
    public static final Double DEFAULT_UNITS = 100.0;

    public ResourceAssignment(ProjectFile file, Task task) {
        super(file);
        if (file.getProjectConfig().getAutoAssignmentUniqueID()) {
            this.setUniqueID(file.getProjectConfig().getNextAssignmentUniqueID());
        }
        this.m_task = task;
    }

    public ResourceAssignmentWorkgroupFields addWorkgroupAssignment() throws MPXJException {
        if (this.m_workgroup != null) {
            throw new MPXJException("Maximum number of records of this type exist");
        }
        this.m_workgroup = new ResourceAssignmentWorkgroupFields();
        return this.m_workgroup;
    }

    @Override
    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(AssignmentField.UNIQUE_ID);
    }

    @Override
    public void setUniqueID(Integer uniqueID) {
        this.set((FieldType)AssignmentField.UNIQUE_ID, uniqueID);
    }

    public Number getUnits() {
        return (Number)this.getCachedValue(AssignmentField.ASSIGNMENT_UNITS);
    }

    public void setUnits(Number val) {
        this.set((FieldType)AssignmentField.ASSIGNMENT_UNITS, val);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(AssignmentField.WORK);
    }

    public void setWork(Duration dur) {
        this.set((FieldType)AssignmentField.WORK, dur);
    }

    public Date getBaselineStart() {
        return (Date)this.getCachedValue(AssignmentField.BASELINE_START);
    }

    public void setBaselineStart(Date start) {
        this.set((FieldType)AssignmentField.BASELINE_START, start);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(AssignmentField.ACTUAL_START);
    }

    public void setActualStart(Date start) {
        this.set((FieldType)AssignmentField.ACTUAL_START, start);
    }

    public Date getBaselineFinish() {
        return (Date)this.getCachedValue(AssignmentField.BASELINE_FINISH);
    }

    public void setBaselineFinish(Date finish) {
        this.set((FieldType)AssignmentField.BASELINE_FINISH, finish);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(AssignmentField.ACTUAL_FINISH);
    }

    public void setActualFinish(Date finish) {
        this.set((FieldType)AssignmentField.ACTUAL_FINISH, finish);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(AssignmentField.BASELINE_WORK);
    }

    public void setBaselineWork(Duration val) {
        this.set((FieldType)AssignmentField.BASELINE_WORK, val);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(AssignmentField.ACTUAL_WORK);
    }

    public void setActualWork(Duration val) {
        this.set((FieldType)AssignmentField.ACTUAL_WORK, val);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(AssignmentField.OVERTIME_WORK);
    }

    public void setOvertimeWork(Duration overtimeWork) {
        this.set((FieldType)AssignmentField.OVERTIME_WORK, overtimeWork);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(AssignmentField.COST);
    }

    public void setCost(Number cost) {
        this.set((FieldType)AssignmentField.COST, cost);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(AssignmentField.BASELINE_COST);
    }

    public void setBaselineCost(Number val) {
        this.set((FieldType)AssignmentField.BASELINE_COST, val);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(AssignmentField.ACTUAL_COST);
    }

    public void setActualCost(Number actualCost) {
        this.set((FieldType)AssignmentField.ACTUAL_COST, actualCost);
    }

    public Date getStart() {
        Date result = (Date)this.getCachedValue(AssignmentField.START);
        if (result == null) {
            result = this.getTask().getStart();
        }
        return result;
    }

    public void setStart(Date val) {
        this.set((FieldType)AssignmentField.START, val);
    }

    public Date getFinish() {
        Date result = (Date)this.getCachedValue(AssignmentField.FINISH);
        if (result == null) {
            result = this.getTask().getFinish();
        }
        return result;
    }

    public void setFinish(Date val) {
        this.set((FieldType)AssignmentField.FINISH, val);
    }

    public Duration getDelay() {
        return (Duration)this.getCachedValue(AssignmentField.ASSIGNMENT_DELAY);
    }

    public void setDelay(Duration dur) {
        this.set((FieldType)AssignmentField.ASSIGNMENT_DELAY, dur);
    }

    public Integer getResourceUniqueID() {
        return (Integer)this.getCachedValue(AssignmentField.RESOURCE_UNIQUE_ID);
    }

    public void setResourceUniqueID(Integer val) {
        this.set((FieldType)AssignmentField.RESOURCE_UNIQUE_ID, val);
    }

    public ResourceAssignmentWorkgroupFields getWorkgroupAssignment() {
        return this.m_workgroup;
    }

    public Task getTask() {
        if (this.m_task == null) {
            this.m_task = this.getParentFile().getTaskByUniqueID(this.getTaskUniqueID());
        }
        return this.m_task;
    }

    public Resource getResource() {
        return this.getParentFile().getResourceByUniqueID(this.getResourceUniqueID());
    }

    public WorkContour getWorkContour() {
        return (WorkContour)this.getCachedValue(AssignmentField.WORK_CONTOUR);
    }

    public void setWorkContour(WorkContour workContour) {
        this.set((FieldType)AssignmentField.WORK_CONTOUR, workContour);
    }

    public void remove() {
        this.getParentFile().getResourceAssignments().remove(this);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(AssignmentField.REMAINING_WORK);
    }

    public void setRemainingWork(Duration remainingWork) {
        this.set((FieldType)AssignmentField.REMAINING_WORK, remainingWork);
    }

    public Duration getLevelingDelay() {
        return (Duration)this.getCachedValue(AssignmentField.LEVELING_DELAY);
    }

    public void setLevelingDelay(Duration levelingDelay) {
        this.set((FieldType)AssignmentField.LEVELING_DELAY, levelingDelay);
    }

    public List<TimephasedWork> getTimephasedActualWork() {
        return this.m_timephasedActualWork == null ? null : this.m_timephasedActualWork.getData();
    }

    public void setTimephasedActualWork(TimephasedWorkContainer data) {
        this.m_timephasedActualWork = data;
    }

    public List<TimephasedWork> getTimephasedWork() {
        return this.m_timephasedWork == null ? null : this.m_timephasedWork.getData();
    }

    public void setTimephasedWork(TimephasedWorkContainer data) {
        this.m_timephasedWork = data;
    }

    public List<TimephasedWork> getTimephasedOvertimeWork() {
        if (this.m_timephasedOvertimeWork == null && this.m_timephasedWork != null && this.getOvertimeWork() != null) {
            double perDayFactor = this.getRemainingOvertimeWork().getDuration() / (this.getRemainingWork().getDuration() - this.getRemainingOvertimeWork().getDuration());
            double totalFactor = this.getRemainingOvertimeWork().getDuration() / this.getRemainingWork().getDuration();
            perDayFactor = Double.isNaN(perDayFactor) ? 0.0 : perDayFactor;
            totalFactor = Double.isNaN(totalFactor) ? 0.0 : totalFactor;
            this.m_timephasedOvertimeWork = this.m_timephasedWork.applyFactor(perDayFactor, totalFactor);
        }
        return this.m_timephasedOvertimeWork == null ? null : this.m_timephasedOvertimeWork.getData();
    }

    public void setTimephasedActualOvertimeWork(TimephasedWorkContainer data) {
        this.m_timephasedActualOvertimeWork = data;
    }

    public List<TimephasedWork> getTimephasedActualOvertimeWork() {
        return this.m_timephasedActualOvertimeWork == null ? null : this.m_timephasedActualOvertimeWork.getData();
    }

    public List<TimephasedCost> getTimephasedCost() {
        if (this.m_timephasedCost == null) {
            ResourceType type;
            Resource r = this.getResource();
            ResourceType resourceType = type = r != null ? r.getType() : ResourceType.WORK;
            if (type != ResourceType.COST) {
                if (this.m_timephasedWork != null && this.m_timephasedWork.hasData()) {
                    this.m_timephasedCost = this.hasMultipleCostRates() ? this.getTimephasedCostMultipleRates(this.getTimephasedWork(), this.getTimephasedOvertimeWork()) : this.getTimephasedCostSingleRate(this.getTimephasedWork(), this.getTimephasedOvertimeWork());
                }
            } else {
                this.m_timephasedCost = this.getTimephasedCostFixedAmount();
            }
        }
        return this.m_timephasedCost;
    }

    public List<TimephasedCost> getTimephasedActualCost() {
        if (this.m_timephasedActualCost == null) {
            ResourceType type;
            Resource r = this.getResource();
            ResourceType resourceType = type = r != null ? r.getType() : ResourceType.WORK;
            if (type != ResourceType.COST) {
                if (this.m_timephasedActualWork != null && this.m_timephasedActualWork.hasData()) {
                    this.m_timephasedActualCost = this.hasMultipleCostRates() ? this.getTimephasedCostMultipleRates(this.getTimephasedActualWork(), this.getTimephasedActualOvertimeWork()) : this.getTimephasedCostSingleRate(this.getTimephasedActualWork(), this.getTimephasedActualOvertimeWork());
                }
            } else {
                this.m_timephasedActualCost = this.getTimephasedActualCostFixedAmount();
            }
        }
        return this.m_timephasedActualCost;
    }

    private List<TimephasedCost> getTimephasedCostSingleRate(List<TimephasedWork> standardWorkList, List<TimephasedWork> overtimeWorkList) {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        if (standardWorkList == null) {
            return result;
        }
        Iterator<Object> overtimeIterator = overtimeWorkList == null ? Collections.emptyList().iterator() : overtimeWorkList.iterator();
        for (TimephasedWork standardWork : standardWorkList) {
            Duration totalOvertimeWork;
            Duration overtimeWorkPerDay;
            Duration totalStandardWork;
            CostRateTableEntry rate = this.getCostRateTableEntry(standardWork.getStart());
            double standardRateValue = rate.getStandardRate().getAmount();
            TimeUnit standardRateUnits = rate.getStandardRate().getUnits();
            double overtimeRateValue = 0.0;
            TimeUnit overtimeRateUnits = standardRateUnits;
            if (rate.getOvertimeRate() != null) {
                overtimeRateValue = rate.getOvertimeRate().getAmount();
                overtimeRateUnits = rate.getOvertimeRate().getUnits();
            }
            TimephasedWork overtimeWork = overtimeIterator.hasNext() ? (TimephasedWork)overtimeIterator.next() : null;
            Duration standardWorkPerDay = (Duration)standardWork.getAmountPerDay();
            if (standardWorkPerDay.getUnits() != standardRateUnits) {
                standardWorkPerDay = standardWorkPerDay.convertUnits(standardRateUnits, this.getParentFile().getProjectProperties());
            }
            if ((totalStandardWork = (Duration)standardWork.getTotalAmount()).getUnits() != standardRateUnits) {
                totalStandardWork = totalStandardWork.convertUnits(standardRateUnits, this.getParentFile().getProjectProperties());
            }
            if (overtimeWork == null || ((Duration)overtimeWork.getTotalAmount()).getDuration() == 0.0) {
                overtimeWorkPerDay = Duration.getInstance(0, standardWorkPerDay.getUnits());
                totalOvertimeWork = Duration.getInstance(0, standardWorkPerDay.getUnits());
            } else {
                overtimeWorkPerDay = (Duration)overtimeWork.getAmountPerDay();
                if (overtimeWorkPerDay.getUnits() != overtimeRateUnits) {
                    overtimeWorkPerDay = overtimeWorkPerDay.convertUnits(overtimeRateUnits, this.getParentFile().getProjectProperties());
                }
                if ((totalOvertimeWork = (Duration)overtimeWork.getTotalAmount()).getUnits() != overtimeRateUnits) {
                    totalOvertimeWork = totalOvertimeWork.convertUnits(overtimeRateUnits, this.getParentFile().getProjectProperties());
                }
            }
            double costPerDay = standardWorkPerDay.getDuration() * standardRateValue + overtimeWorkPerDay.getDuration() * overtimeRateValue;
            double totalCost = totalStandardWork.getDuration() * standardRateValue + totalOvertimeWork.getDuration() * overtimeRateValue;
            if (overtimeWork == null || overtimeWork.getFinish().equals(standardWork.getFinish())) {
                TimephasedCost cost = new TimephasedCost();
                cost.setStart(standardWork.getStart());
                cost.setFinish(standardWork.getFinish());
                cost.setModified(standardWork.getModified());
                cost.setAmountPerDay(costPerDay);
                cost.setTotalAmount(totalCost);
                result.add(cost);
                continue;
            }
            result.addAll(this.splitCostProrated(this.getCalendar(), totalCost, costPerDay, standardWork.getStart()));
        }
        return result;
    }

    private List<TimephasedCost> getTimephasedCostMultipleRates(List<TimephasedWork> standardWorkList, List<TimephasedWork> overtimeWorkList) {
        ArrayList<TimephasedWork> standardWorkResult = new ArrayList<TimephasedWork>();
        ArrayList<TimephasedWork> overtimeWorkResult = new ArrayList<TimephasedWork>();
        CostRateTable table = this.getCostRateTable();
        ProjectCalendar calendar = this.getCalendar();
        Iterator<TimephasedWork> iter = overtimeWorkList.iterator();
        for (TimephasedWork standardWork : standardWorkList) {
            int finishIndex;
            TimephasedWork overtimeWork = iter.hasNext() ? iter.next() : null;
            int startIndex = this.getCostRateTableEntryIndex(standardWork.getStart());
            if (startIndex == (finishIndex = this.getCostRateTableEntryIndex(standardWork.getFinish()))) {
                standardWorkResult.add(standardWork);
                if (overtimeWork == null) continue;
                overtimeWorkResult.add(overtimeWork);
                continue;
            }
            standardWorkResult.addAll(this.splitWork(table, calendar, standardWork, startIndex));
            if (overtimeWork == null) continue;
            overtimeWorkResult.addAll(this.splitWork(table, calendar, overtimeWork, startIndex));
        }
        return this.getTimephasedCostSingleRate(standardWorkResult, overtimeWorkResult);
    }

    private List<TimephasedCost> getTimephasedCostFixedAmount() {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        ProjectCalendar cal = this.getCalendar();
        double remainingCost = this.getRemainingCost().doubleValue();
        if (remainingCost > 0.0) {
            AccrueType accrueAt = this.getResource().getAccrueAt();
            if (accrueAt == AccrueType.START) {
                result.add(this.splitCostStart(cal, remainingCost, this.getStart()));
            } else if (accrueAt == AccrueType.END) {
                result.add(this.splitCostEnd(cal, remainingCost, this.getFinish()));
            } else {
                double numWorkingDays = cal.getWork(this.getStart(), this.getFinish(), TimeUnit.DAYS).getDuration();
                double standardAmountPerDay = this.getCost().doubleValue() / numWorkingDays;
                if (this.getActualCost().intValue() > 0) {
                    int numActualDaysUsed = (int)Math.ceil(this.getActualCost().doubleValue() / standardAmountPerDay);
                    Date actualWorkFinish = cal.getDate(this.getStart(), Duration.getInstance(numActualDaysUsed, TimeUnit.DAYS), false);
                    double partialDayActualAmount = this.getActualCost().doubleValue() % standardAmountPerDay;
                    if (partialDayActualAmount > 0.0) {
                        double dayAmount = standardAmountPerDay < remainingCost ? standardAmountPerDay - partialDayActualAmount : remainingCost;
                        result.add(this.splitCostEnd(cal, dayAmount, actualWorkFinish));
                        remainingCost -= dayAmount;
                    }
                    if (remainingCost > 0.0) {
                        result.addAll(this.splitCostProrated(cal, remainingCost, standardAmountPerDay, cal.getNextWorkStart(actualWorkFinish)));
                    }
                } else {
                    result.addAll(this.splitCostProrated(cal, remainingCost, standardAmountPerDay, this.getStart()));
                }
            }
        }
        return result;
    }

    private List<TimephasedCost> getTimephasedActualCostFixedAmount() {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        double actualCost = this.getActualCost().doubleValue();
        if (actualCost > 0.0) {
            AccrueType accrueAt = this.getResource().getAccrueAt();
            if (accrueAt == AccrueType.START) {
                result.add(this.splitCostStart(this.getCalendar(), actualCost, this.getActualStart()));
            } else if (accrueAt == AccrueType.END) {
                result.add(this.splitCostEnd(this.getCalendar(), actualCost, this.getActualFinish()));
            } else {
                double numWorkingDays = this.getCalendar().getWork(this.getStart(), this.getFinish(), TimeUnit.DAYS).getDuration();
                double standardAmountPerDay = this.getCost().doubleValue() / numWorkingDays;
                result.addAll(this.splitCostProrated(this.getCalendar(), actualCost, standardAmountPerDay, this.getActualStart()));
            }
        }
        return result;
    }

    private TimephasedCost splitCostStart(ProjectCalendar calendar, double totalAmount, Date start) {
        TimephasedCost cost = new TimephasedCost();
        cost.setStart(start);
        cost.setFinish(calendar.getDate(start, Duration.getInstance(1, TimeUnit.DAYS), false));
        cost.setAmountPerDay(totalAmount);
        cost.setTotalAmount(totalAmount);
        return cost;
    }

    private TimephasedCost splitCostEnd(ProjectCalendar calendar, double totalAmount, Date finish) {
        TimephasedCost cost = new TimephasedCost();
        cost.setStart(calendar.getStartDate(finish, Duration.getInstance(1, TimeUnit.DAYS)));
        cost.setFinish(finish);
        cost.setAmountPerDay(totalAmount);
        cost.setTotalAmount(totalAmount);
        return cost;
    }

    private List<TimephasedCost> splitCostProrated(ProjectCalendar calendar, double totalAmount, double standardAmountPerDay, Date start) {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        double numStandardAmountDays = Math.floor(totalAmount / standardAmountPerDay);
        double amountForLastDay = totalAmount % standardAmountPerDay;
        if (numStandardAmountDays > 0.0) {
            Date finishStandardBlock = calendar.getDate(start, Duration.getInstance(numStandardAmountDays, TimeUnit.DAYS), false);
            TimephasedCost standardBlock = new TimephasedCost();
            standardBlock.setAmountPerDay(standardAmountPerDay);
            standardBlock.setStart(start);
            standardBlock.setFinish(finishStandardBlock);
            standardBlock.setTotalAmount(numStandardAmountDays * standardAmountPerDay);
            result.add(standardBlock);
            start = calendar.getNextWorkStart(finishStandardBlock);
        }
        if (amountForLastDay > 0.0) {
            TimephasedCost nextBlock = new TimephasedCost();
            nextBlock.setAmountPerDay(amountForLastDay);
            nextBlock.setTotalAmount(amountForLastDay);
            nextBlock.setStart(start);
            nextBlock.setFinish(calendar.getDate(start, Duration.getInstance(1, TimeUnit.DAYS), false));
            result.add(nextBlock);
        }
        return result;
    }

    private List<TimephasedWork> splitWork(CostRateTable table, ProjectCalendar calendar, TimephasedWork work, int rateIndex) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        work.setTotalAmount(Duration.getInstance(0, ((Duration)work.getAmountPerDay()).getUnits()));
        while (true) {
            CostRateTableEntry rate;
            Date splitDate;
            if ((splitDate = (rate = (CostRateTableEntry)table.get(rateIndex)).getEndDate()).getTime() >= work.getFinish().getTime()) break;
            Date currentPeriodEnd = calendar.getPreviousWorkFinish(splitDate);
            TimephasedWork currentPeriod = new TimephasedWork(work);
            currentPeriod.setFinish(currentPeriodEnd);
            result.add(currentPeriod);
            Date nextPeriodStart = calendar.getNextWorkStart(splitDate);
            work.setStart(nextPeriodStart);
            ++rateIndex;
        }
        result.add(work);
        return result;
    }

    private boolean hasMultipleCostRates() {
        boolean result = false;
        CostRateTable table = this.getCostRateTable();
        if (table != null && table.size() > 1) {
            CostRateTableEntry finishEntry;
            CostRateTableEntry startEntry = table.getEntryByDate(this.getStart());
            result = startEntry != (finishEntry = table.getEntryByDate(this.getFinish()));
        }
        return result;
    }

    private CostRateTableEntry getCostRateTableEntry(Date date) {
        CostRateTableEntry result;
        CostRateTable table = this.getCostRateTable();
        if (table == null) {
            Resource resource = this.getResource();
            result = new CostRateTableEntry(resource.getStandardRate(), TimeUnit.HOURS, resource.getOvertimeRate(), TimeUnit.HOURS, resource.getCostPerUse(), DateHelper.START_DATE_NA, DateHelper.END_DATE_NA);
        } else {
            result = table.size() == 1 ? (CostRateTableEntry)table.get(0) : table.getEntryByDate(date);
        }
        return result;
    }

    private int getCostRateTableEntryIndex(Date date) {
        int result = -1;
        CostRateTable table = this.getCostRateTable();
        if (table != null) {
            result = table.size() == 1 ? 0 : table.getIndexByDate(date);
        }
        return result;
    }

    public boolean getHasTimephasedData() {
        return this.m_timephasedWork != null && this.m_timephasedWork.hasData() || this.m_timephasedActualWork != null && this.m_timephasedActualWork.hasData();
    }

    public void setTimephasedBaselineWork(int index, TimephasedWorkContainer data) {
        this.m_timephasedBaselineWork[index] = data;
    }

    public void setTimephasedBaselineCost(int index, TimephasedCostContainer data) {
        this.m_timephasedBaselineCost[index] = data;
    }

    public List<TimephasedWork> getTimephasedBaselineWork(int index) {
        return this.m_timephasedBaselineWork[index] == null ? null : this.m_timephasedBaselineWork[index].getData();
    }

    public List<TimephasedCost> getTimephasedBaselineCost(int index) {
        return this.m_timephasedBaselineCost[index] == null ? null : this.m_timephasedBaselineCost[index].getData();
    }

    public ProjectCalendar getCalendar() {
        ProjectCalendar calendar = null;
        Resource resource = this.getResource();
        if (resource != null) {
            calendar = resource.getResourceCalendar();
        }
        Task task = this.getTask();
        if (calendar == null || task.getIgnoreResourceCalendar()) {
            calendar = task.getEffectiveCalendar();
        }
        return calendar;
    }

    public TimeUnit getVariableRateUnits() {
        return (TimeUnit)this.getCachedValue(AssignmentField.VARIABLE_RATE_UNITS);
    }

    public void setVariableRateUnits(TimeUnit variableRateUnits) {
        this.set((FieldType)AssignmentField.VARIABLE_RATE_UNITS, variableRateUnits);
    }

    public void setTaskUniqueID(Integer id) {
        this.set((FieldType)AssignmentField.TASK_UNIQUE_ID, id);
    }

    public Integer getTaskUniqueID() {
        return (Integer)this.getCachedValue(AssignmentField.TASK_UNIQUE_ID);
    }

    public Number getBudgetCost() {
        return (Number)this.getCachedValue(AssignmentField.BUDGET_COST);
    }

    public void setBudgetCost(Number cost) {
        this.set((FieldType)AssignmentField.BUDGET_COST, cost);
    }

    public Duration getBudgetWork() {
        return (Duration)this.getCachedValue(AssignmentField.BUDGET_WORK);
    }

    public void setBudgetWork(Duration work) {
        this.set((FieldType)AssignmentField.BUDGET_WORK, work);
    }

    public Number getBaselineBudgetCost() {
        return (Number)this.getCachedValue(AssignmentField.BASELINE_BUDGET_COST);
    }

    public void setBaselineBudgetCost(Number cost) {
        this.set((FieldType)AssignmentField.BASELINE_BUDGET_COST, cost);
    }

    public Duration getBaselineBudgetWork() {
        return (Duration)this.getCachedValue(AssignmentField.BASELINE_BUDGET_WORK);
    }

    public void setBaselineBudgetWork(Duration work) {
        this.set((FieldType)AssignmentField.BASELINE_BUDGET_WORK, work);
    }

    public void setBaselineCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.BASELINE_COSTS, baselineNumber), value);
    }

    public void setBaselineWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.BASELINE_WORKS, baselineNumber), value);
    }

    public Duration getBaselineWork(int baselineNumber) {
        return (Duration)this.getCachedValue(this.selectField(AssignmentFieldLists.BASELINE_WORKS, baselineNumber));
    }

    public Number getBaselineCost(int baselineNumber) {
        return (Number)this.getCachedValue(this.selectField(AssignmentFieldLists.BASELINE_COSTS, baselineNumber));
    }

    public void setBaselineStart(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.BASELINE_STARTS, baselineNumber), value);
    }

    public Date getBaselineStart(int baselineNumber) {
        return (Date)this.getCachedValue(this.selectField(AssignmentFieldLists.BASELINE_STARTS, baselineNumber));
    }

    public void setBaselineFinish(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.BASELINE_FINISHES, baselineNumber), value);
    }

    public Date getBaselineFinish(int baselineNumber) {
        return (Date)this.getCachedValue(this.selectField(AssignmentFieldLists.BASELINE_FINISHES, baselineNumber));
    }

    public void setBaselineBudgetCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.BASELINE_BUDGET_COSTS, baselineNumber), value);
    }

    public void setBaselineBudgetWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.BASELINE_BUDGET_WORKS, baselineNumber), value);
    }

    public Duration getBaselineBudgetWork(int baselineNumber) {
        return (Duration)this.getCachedValue(this.selectField(AssignmentFieldLists.BASELINE_BUDGET_WORKS, baselineNumber));
    }

    public Number getBaselineBudgetCost(int baselineNumber) {
        return (Number)this.getCachedValue(this.selectField(AssignmentFieldLists.BASELINE_BUDGET_COSTS, baselineNumber));
    }

    public void setText(int index, String value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.CUSTOM_TEXT, index), value);
    }

    public String getText(int index) {
        return (String)this.getCachedValue(this.selectField(AssignmentFieldLists.CUSTOM_TEXT, index));
    }

    public void setStart(int index, Date value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.CUSTOM_START, index), value);
    }

    public Date getStart(int index) {
        return (Date)this.getCachedValue(this.selectField(AssignmentFieldLists.CUSTOM_START, index));
    }

    public void setFinish(int index, Date value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.CUSTOM_FINISH, index), value);
    }

    public Date getFinish(int index) {
        return (Date)this.getCachedValue(this.selectField(AssignmentFieldLists.CUSTOM_FINISH, index));
    }

    public void setDate(int index, Date value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.CUSTOM_DATE, index), value);
    }

    public Date getDate(int index) {
        return (Date)this.getCachedValue(this.selectField(AssignmentFieldLists.CUSTOM_DATE, index));
    }

    public void setNumber(int index, Number value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.CUSTOM_NUMBER, index), value);
    }

    public Number getNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(AssignmentFieldLists.CUSTOM_NUMBER, index));
    }

    public void setDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.CUSTOM_DURATION, index), value);
    }

    public Duration getDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(AssignmentFieldLists.CUSTOM_DURATION, index));
    }

    public void setCost(int index, Number value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.CUSTOM_COST, index), value);
    }

    public Number getCost(int index) {
        return (Number)this.getCachedValue(this.selectField(AssignmentFieldLists.CUSTOM_COST, index));
    }

    public void setFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.CUSTOM_FLAG, index), value);
    }

    public boolean getFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(AssignmentFieldLists.CUSTOM_FLAG, index)));
    }

    public void setEnterpriseCost(int index, Number value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.ENTERPRISE_COST, index), value);
    }

    public Number getEnterpriseCost(int index) {
        return (Number)this.getCachedValue(this.selectField(AssignmentFieldLists.ENTERPRISE_COST, index));
    }

    public void setEnterpriseDate(int index, Date value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.ENTERPRISE_DATE, index), value);
    }

    public Date getEnterpriseDate(int index) {
        return (Date)this.getCachedValue(this.selectField(AssignmentFieldLists.ENTERPRISE_DATE, index));
    }

    public void setEnterpriseDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.ENTERPRISE_DURATION, index), value);
    }

    public Duration getEnterpriseDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(AssignmentFieldLists.ENTERPRISE_DURATION, index));
    }

    public void setEnterpriseFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.ENTERPRISE_FLAG, index), value);
    }

    public boolean getEnterpriseFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(AssignmentFieldLists.ENTERPRISE_FLAG, index)));
    }

    public void setEnterpriseNumber(int index, Number value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.ENTERPRISE_NUMBER, index), value);
    }

    public Number getEnterpriseNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(AssignmentFieldLists.ENTERPRISE_NUMBER, index));
    }

    public void setEnterpriseText(int index, String value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.ENTERPRISE_TEXT, index), value);
    }

    public String getEnterpriseText(int index) {
        return (String)this.getCachedValue(this.selectField(AssignmentFieldLists.ENTERPRISE_TEXT, index));
    }

    public byte[] getEnterpriseCustomField(int index) {
        return (byte[])this.getCachedValue(this.selectField(AssignmentFieldLists.ENTERPRISE_CUSTOM_FIELD, index));
    }

    public void setEnterpriseCustomField(int index, byte[] value) {
        this.set((FieldType)this.selectField(AssignmentFieldLists.ENTERPRISE_CUSTOM_FIELD, index), value);
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(AssignmentField.REGULAR_WORK);
    }

    public void setRegularWork(Duration dur) {
        this.set((FieldType)AssignmentField.REGULAR_WORK, dur);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(AssignmentField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration dur) {
        this.set((FieldType)AssignmentField.ACTUAL_OVERTIME_WORK, dur);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(AssignmentField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration dur) {
        this.set((FieldType)AssignmentField.REMAINING_OVERTIME_WORK, dur);
    }

    public Number getOvertimeCost() {
        Number cost = (Number)this.getCachedValue(AssignmentField.OVERTIME_COST);
        if (cost == null) {
            Number actual = this.getActualOvertimeCost();
            Number remaining = this.getRemainingOvertimeCost();
            if (actual != null && remaining != null) {
                cost = NumberHelper.getDouble(actual.doubleValue() + remaining.doubleValue());
                this.set((FieldType)AssignmentField.OVERTIME_COST, cost);
            }
        }
        return cost;
    }

    public void setOvertimeCost(Number cost) {
        this.set((FieldType)AssignmentField.OVERTIME_COST, cost);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(AssignmentField.REMAINING_COST);
    }

    public void setRemainingCost(Number cost) {
        this.set((FieldType)AssignmentField.REMAINING_COST, cost);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(AssignmentField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number cost) {
        this.set((FieldType)AssignmentField.ACTUAL_OVERTIME_COST, cost);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(AssignmentField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number cost) {
        this.set((FieldType)AssignmentField.REMAINING_OVERTIME_COST, cost);
    }

    public void setBCWP(Number val) {
        this.set((FieldType)AssignmentField.BCWP, val);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(AssignmentField.BCWP);
    }

    public void setBCWS(Number val) {
        this.set((FieldType)AssignmentField.BCWS, val);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(AssignmentField.BCWS);
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(AssignmentField.ACWP);
    }

    public void setACWP(Number acwp) {
        this.set((FieldType)AssignmentField.ACWP, acwp);
    }

    public void setSV(Number val) {
        this.set((FieldType)AssignmentField.SV, val);
    }

    public Number getSV() {
        Number variance = (Number)this.getCachedValue(AssignmentField.SV);
        if (variance == null) {
            Number bcwp = this.getBCWP();
            Number bcws = this.getBCWS();
            if (bcwp != null && bcws != null) {
                variance = NumberHelper.getDouble(bcwp.doubleValue() - bcws.doubleValue());
                this.set((FieldType)AssignmentField.SV, variance);
            }
        }
        return variance;
    }

    public void setCV(Number val) {
        this.set((FieldType)AssignmentField.CV, val);
    }

    public Number getCV() {
        Number variance = (Number)this.getCachedValue(AssignmentField.CV);
        if (variance == null) {
            variance = NumberHelper.getDouble(this.getBCWP()) - NumberHelper.getDouble(this.getACWP());
            this.set((FieldType)AssignmentField.CV, variance);
        }
        return variance;
    }

    public void setCostVariance(Number val) {
        this.set((FieldType)AssignmentField.COST_VARIANCE, val);
    }

    public Number getCostVariance() {
        Number variance = (Number)this.getCachedValue(AssignmentField.COST_VARIANCE);
        if (variance == null) {
            Number cost = this.getCost();
            Number baselineCost = this.getBaselineCost();
            if (cost != null && baselineCost != null) {
                variance = NumberHelper.getDouble(cost.doubleValue() - baselineCost.doubleValue());
                this.set((FieldType)AssignmentField.COST_VARIANCE, variance);
            }
        }
        return variance;
    }

    public void setPercentageWorkComplete(Number val) {
        this.set((FieldType)AssignmentField.PERCENT_WORK_COMPLETE, val);
    }

    public Number getPercentageWorkComplete() {
        Number pct = (Number)this.getCachedValue(AssignmentField.PERCENT_WORK_COMPLETE);
        if (pct == null) {
            Duration actualWork = this.getActualWork();
            Duration work = this.getWork();
            if (actualWork != null && work != null && work.getDuration() != 0.0) {
                pct = actualWork.getDuration() * 100.0 / work.convertUnits(actualWork.getUnits(), this.getParentFile().getProjectProperties()).getDuration();
                this.set((FieldType)AssignmentField.PERCENT_WORK_COMPLETE, pct);
            }
        }
        return pct;
    }

    public void setNotes(String notes) {
        this.set((FieldType)AssignmentField.NOTES, notes == null ? null : new Notes(notes));
    }

    public String getNotes() {
        Object notes = this.getCachedValue(AssignmentField.NOTES);
        return notes == null ? "" : notes.toString();
    }

    public void setNotesObject(Notes notes) {
        this.set((FieldType)AssignmentField.NOTES, notes);
    }

    public Notes getNotesObject() {
        return (Notes)this.getCachedValue(AssignmentField.NOTES);
    }

    public void setConfirmed(boolean val) {
        this.set((FieldType)AssignmentField.CONFIRMED, val);
    }

    public boolean getConfirmed() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(AssignmentField.CONFIRMED));
    }

    public void setUpdateNeeded(boolean val) {
        this.set((FieldType)AssignmentField.UPDATE_NEEDED, val);
    }

    public boolean getUpdateNeeded() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(AssignmentField.UPDATE_NEEDED));
    }

    public void setLinkedFields(boolean flag) {
        this.set((FieldType)AssignmentField.LINKED_FIELDS, flag);
    }

    public boolean getLinkedFields() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(AssignmentField.LINKED_FIELDS));
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK_ADDRESS);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlink(String text) {
        this.set((FieldType)AssignmentField.HYPERLINK, text);
    }

    public void setHyperlinkAddress(String text) {
        this.set((FieldType)AssignmentField.HYPERLINK_ADDRESS, text);
    }

    public void setHyperlinkSubAddress(String text) {
        this.set((FieldType)AssignmentField.HYPERLINK_SUBADDRESS, text);
    }

    public void setWorkVariance(Duration val) {
        this.set((FieldType)AssignmentField.WORK_VARIANCE, val);
    }

    public Duration getWorkVariance() {
        Duration variance = (Duration)this.getCachedValue(AssignmentField.WORK_VARIANCE);
        if (variance == null) {
            Duration work = this.getWork();
            Duration baselineWork = this.getBaselineWork();
            if (work != null && baselineWork != null) {
                variance = Duration.getInstance(work.getDuration() - baselineWork.convertUnits(work.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), work.getUnits());
                this.set((FieldType)AssignmentField.WORK_VARIANCE, variance);
            }
        }
        return variance;
    }

    public void setStartVariance(Duration val) {
        this.set((FieldType)AssignmentField.START_VARIANCE, val);
    }

    public Duration getStartVariance() {
        Duration variance = (Duration)this.getCachedValue(AssignmentField.START_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectProperties().getDefaultDurationUnits();
            variance = DateHelper.getVariance(this.getTask(), this.getBaselineStart(), this.getStart(), format);
            this.set((FieldType)AssignmentField.START_VARIANCE, variance);
        }
        return variance;
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)AssignmentField.FINISH_VARIANCE, duration);
    }

    public Duration getFinishVariance() {
        Duration variance = (Duration)this.getCachedValue(AssignmentField.FINISH_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectProperties().getDefaultDurationUnits();
            variance = DateHelper.getVariance(this.getTask(), this.getBaselineFinish(), this.getFinish(), format);
            this.set((FieldType)AssignmentField.FINISH_VARIANCE, variance);
        }
        return variance;
    }

    public Date getCreateDate() {
        return (Date)this.getCachedValue(AssignmentField.CREATED);
    }

    public void setCreateDate(Date val) {
        this.set((FieldType)AssignmentField.CREATED, val);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(AssignmentField.GUID);
    }

    public void setGUID(UUID value) {
        this.set((FieldType)AssignmentField.GUID, value);
    }

    public void setResponsePending(boolean val) {
        this.set((FieldType)AssignmentField.RESPONSE_PENDING, val);
    }

    public boolean getResponsePending() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(AssignmentField.RESPONSE_PENDING));
    }

    public void setTeamStatusPending(boolean val) {
        this.set((FieldType)AssignmentField.TEAM_STATUS_PENDING, val);
    }

    public boolean getTeamStatusPending() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(AssignmentField.TEAM_STATUS_PENDING));
    }

    public void setVAC(Number value) {
        this.set((FieldType)AssignmentField.VAC, value);
    }

    public Number getVAC() {
        return (Number)this.getCachedValue(AssignmentField.VAC);
    }

    public void setCostRateTableIndex(int index) {
        this.set((FieldType)AssignmentField.COST_RATE_TABLE, index);
    }

    public int getCostRateTableIndex() {
        int value = NumberHelper.getInt((Integer)this.getCachedValue(AssignmentField.COST_RATE_TABLE));
        return value < 0 || value >= 5 ? 0 : value;
    }

    public CostRateTable getCostRateTable() {
        return this.getResource() == null ? null : this.getResource().getCostRateTable(this.getCostRateTableIndex());
    }

    public String getHyperlinkScreenTip() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK_SCREEN_TIP);
    }

    public void setHyperlinkScreenTip(String text) {
        this.set((FieldType)AssignmentField.HYPERLINK_SCREEN_TIP, text);
    }

    public ResourceRequestType getResourceRequestType() {
        return (ResourceRequestType)this.getCachedValue(AssignmentField.RESOURCE_REQUEST_TYPE);
    }

    public void setResourceRequestType(ResourceRequestType type) {
        this.set((FieldType)AssignmentField.RESOURCE_REQUEST_TYPE, type);
    }

    public Date getStop() {
        return (Date)this.getCachedValue(AssignmentField.STOP);
    }

    public void setStop(Date stop) {
        this.set((FieldType)AssignmentField.STOP, stop);
    }

    public Date getResume() {
        return (Date)this.getCachedValue(AssignmentField.RESUME);
    }

    public void setResume(Date resume) {
        this.set((FieldType)AssignmentField.RESUME, resume);
    }

    private AssignmentField selectField(AssignmentField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    public String toString() {
        return "[Resource Assignment task=" + this.getTask().getName() + " resource=" + (this.getResource() == null ? "Unassigned" : this.getResource().getName()) + " start=" + this.getStart() + " finish=" + this.getFinish() + " duration=" + this.getWork() + " workContour=" + this.getWorkContour() + "]";
    }

    @Override
    public void set(FieldType field, Object value) {
        if (field != null) {
            int index = field.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((AssignmentField)field, this.m_array[index], value);
            }
            this.m_array[index] = value;
        }
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    private void fireFieldChangeEvent(AssignmentField field, Object oldValue, Object newValue) {
        switch (field) {
            case START: 
            case BASELINE_START: {
                this.m_array[AssignmentField.START_VARIANCE.getValue()] = null;
                break;
            }
            case FINISH: 
            case BASELINE_FINISH: {
                this.m_array[AssignmentField.FINISH_VARIANCE.getValue()] = null;
                break;
            }
            case BCWP: 
            case ACWP: {
                this.m_array[AssignmentField.CV.getValue()] = null;
                this.m_array[AssignmentField.SV.getValue()] = null;
                break;
            }
            case COST: 
            case BASELINE_COST: {
                this.m_array[AssignmentField.COST_VARIANCE.getValue()] = null;
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.m_array[AssignmentField.WORK_VARIANCE.getValue()] = null;
                break;
            }
            case ACTUAL_OVERTIME_COST: 
            case REMAINING_OVERTIME_COST: {
                this.m_array[AssignmentField.OVERTIME_COST.getValue()] = null;
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener listener : this.m_listeners) {
                listener.fieldChange(this, field, oldValue, newValue);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return field == null ? null : this.m_array[field.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType field) {
        Object result = null;
        if (field != null) {
            int fieldValue = field.getValue();
            result = this.m_array[fieldValue];
        }
        return result;
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }
}

