/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaDatabaseFileReader;
import net.sf.mpxj.asta.AstaTextFileReader;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.reader.AbstractProjectStreamReader;

public final class AstaFileReader
extends AbstractProjectStreamReader {
    private static final String SQLITE_TEXT = "SQLite format";

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream is = new BufferedInputStream(inputStream);
            is.mark(100);
            byte[] buffer = new byte[SQLITE_TEXT.length()];
            is.read(buffer);
            is.reset();
            String actualText = new String(buffer);
            AbstractProjectReader reader = SQLITE_TEXT.equals(actualText) ? new AstaDatabaseFileReader() : new AstaTextFileReader();
            this.addListenersToReader(reader);
            return reader.read(is);
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to read file", ex);
        }
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Arrays.asList(this.read(inputStream));
    }
}

