/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.MPPUtility;

class CustomFieldAliasReader {
    private final CustomFieldContainer m_fields;
    private final byte[] m_data;

    public CustomFieldAliasReader(CustomFieldContainer fields, byte[] data) {
        this.m_fields = fields;
        this.m_data = data;
    }

    public void process() {
        if (this.m_data != null) {
            int offset = 0;
            int length = MPPUtility.getInt(this.m_data, offset);
            int numberOfAliases = MPPUtility.getInt(this.m_data, offset += 8);
            offset += 4;
            for (int index = 0; index < numberOfAliases && offset < length; ++index) {
                int fieldID = MPPUtility.getInt(this.m_data, offset);
                int aliasOffset = MPPUtility.getInt(this.m_data, offset += 4) + 4;
                offset += 4;
                if (aliasOffset >= this.m_data.length) continue;
                String alias = MPPUtility.getUnicodeString(this.m_data, aliasOffset);
                this.m_fields.getCustomField(FieldTypeHelper.getInstance(fieldID)).setAlias(alias);
            }
        }
    }
}

