/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Date;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.GraphicalIndicator;
import net.sf.mpxj.GraphicalIndicatorCriteria;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

public final class GraphicalIndicatorReader {
    private byte[] m_data;
    private int m_headerOffset;
    private int m_dataOffset;
    private CustomFieldContainer m_container;
    private ProjectProperties m_properties;

    public void process(CustomFieldContainer indicators, ProjectProperties properties, Props props) {
        this.m_container = indicators;
        this.m_properties = properties;
        this.m_data = props.getByteArray(Props.TASK_FIELD_ATTRIBUTES);
        if (this.m_data != null) {
            int columnsCount = MPPUtility.getInt(this.m_data, 4);
            this.m_headerOffset = 8;
            for (int loop = 0; loop < columnsCount; ++loop) {
                this.processColumns();
            }
        }
    }

    private void processColumns() {
        int fieldID = MPPUtility.getInt(this.m_data, this.m_headerOffset);
        this.m_headerOffset += 4;
        this.m_dataOffset = MPPUtility.getInt(this.m_data, this.m_headerOffset);
        this.m_headerOffset += 4;
        FieldType type = FieldTypeHelper.getInstance(fieldID);
        if (type.getDataType() != null) {
            this.processKnownType(type);
        }
    }

    private void processKnownType(FieldType type) {
        GraphicalIndicator indicator = this.m_container.getCustomField(type).getGraphicalIndicator();
        indicator.setFieldType(type);
        byte flags = this.m_data[this.m_dataOffset];
        indicator.setProjectSummaryInheritsFromSummaryRows((flags & 8) != 0);
        indicator.setSummaryRowsInheritFromNonSummaryRows((flags & 4) != 0);
        indicator.setDisplayGraphicalIndicators((flags & 2) != 0);
        indicator.setShowDataValuesInToolTips((flags & 1) != 0);
        this.m_dataOffset += 20;
        int nonSummaryRowOffset = MPPUtility.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int summaryRowOffset = MPPUtility.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int projectSummaryOffset = MPPUtility.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int dataSize = MPPUtility.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int maxNonSummaryRowOffset = this.m_dataOffset + summaryRowOffset;
        int maxSummaryRowOffset = this.m_dataOffset + projectSummaryOffset;
        int maxProjectSummaryOffset = this.m_dataOffset + dataSize;
        this.m_dataOffset += nonSummaryRowOffset;
        while (this.m_dataOffset + 2 < maxNonSummaryRowOffset) {
            indicator.addNonSummaryRowCriteria(this.processCriteria(type));
        }
        while (this.m_dataOffset + 2 < maxSummaryRowOffset) {
            indicator.addSummaryRowCriteria(this.processCriteria(type));
        }
        while (this.m_dataOffset + 2 < maxProjectSummaryOffset) {
            indicator.addProjectSummaryCriteria(this.processCriteria(type));
        }
    }

    private GraphicalIndicatorCriteria processCriteria(FieldType type) {
        GraphicalIndicatorCriteria criteria = new GraphicalIndicatorCriteria(this.m_properties);
        criteria.setLeftValue(type);
        int indicatorType = MPPUtility.getInt(this.m_data, this.m_dataOffset);
        this.m_dataOffset += 4;
        criteria.setIndicator(indicatorType);
        if (this.m_dataOffset + 4 < this.m_data.length) {
            int operatorValue = MPPUtility.getInt(this.m_data, this.m_dataOffset);
            this.m_dataOffset += 4;
            TestOperator operator = operatorValue == 0 ? TestOperator.IS_ANY_VALUE : TestOperator.getInstance(operatorValue - 999);
            criteria.setOperator(operator);
            if (operator != TestOperator.IS_ANY_VALUE) {
                this.processOperandValue(0, type, criteria);
                if (operator == TestOperator.IS_WITHIN || operator == TestOperator.IS_NOT_WITHIN) {
                    this.processOperandValue(1, type, criteria);
                }
            }
        }
        return criteria;
    }

    private void processOperandValue(int index, FieldType type, GraphicalIndicatorCriteria criteria) {
        boolean valueFlag = MPPUtility.getInt(this.m_data, this.m_dataOffset) == 1;
        this.m_dataOffset += 4;
        if (!valueFlag) {
            int fieldID = MPPUtility.getInt(this.m_data, this.m_dataOffset);
            criteria.setRightValue(index, FieldTypeHelper.getInstance(fieldID));
            this.m_dataOffset += 4;
        } else {
            this.m_dataOffset += 2;
            switch (type.getDataType()) {
                case DURATION: {
                    Duration value = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(this.m_data, this.m_dataOffset), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(this.m_data, this.m_dataOffset + 4)));
                    this.m_dataOffset += 6;
                    criteria.setRightValue(index, value);
                    break;
                }
                case NUMERIC: {
                    Double value = MPPUtility.getDouble(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += 8;
                    criteria.setRightValue(index, value);
                    break;
                }
                case CURRENCY: {
                    Double value = MPPUtility.getDouble(this.m_data, this.m_dataOffset) / 100.0;
                    this.m_dataOffset += 8;
                    criteria.setRightValue(index, value);
                    break;
                }
                case STRING: {
                    String value = MPPUtility.getUnicodeString(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += (value.length() + 1) * 2;
                    criteria.setRightValue(index, value);
                    break;
                }
                case BOOLEAN: {
                    int value = MPPUtility.getShort(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += 2;
                    criteria.setRightValue(index, value == 1 ? Boolean.TRUE : Boolean.FALSE);
                    break;
                }
                case DATE: {
                    Date value = MPPUtility.getTimestamp(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += 4;
                    criteria.setRightValue(index, value);
                    break;
                }
            }
        }
    }
}

