/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.util.Map;
import net.sf.mpxj.synchro.CommentaryReader;
import net.sf.mpxj.synchro.StreamReader;
import net.sf.mpxj.synchro.Synchro;
import net.sf.mpxj.synchro.TableReader;
import net.sf.mpxj.synchro.UserFieldReader;

class ResourceReader
extends TableReader {
    public ResourceReader(StreamReader stream) {
        super(stream);
    }

    @Override
    protected void readRow(StreamReader stream, Map<String, Object> map) throws IOException {
        int unknown3BlockSize = stream.getVersion().atLeast(Synchro.VERSION_6_0_0) ? 56 : 64;
        map.put("NAME", stream.readString());
        map.put("DESCRIPTION", stream.readString());
        Integer supplyReferenceFlag = stream.readInteger();
        map.put("SUPPLY_REFERENCE_FLAG", supplyReferenceFlag);
        if (supplyReferenceFlag != 0) {
            map.put("SUPPLY_REFERENCE", stream.readString());
        }
        map.put("UNKNOWN1", stream.readBytes(48));
        map.put("RESOURCES", stream.readTable(ResourceReader.class));
        map.put("UNKNOWN2", stream.readBytes(20));
        map.put("URL", stream.readString());
        map.put("USER_FIELDS", stream.readTableConditional(UserFieldReader.class));
        map.put("ID", stream.readString());
        map.put("EMAIL", stream.readString());
        map.put("UNKNOWN3", stream.readUnknownTable(unknown3BlockSize, 1880862653));
        map.put("UNKNOWN4", stream.readBytes(30));
        map.put("COMMENTARY", stream.readTableConditional(CommentaryReader.class));
        this.skipToRowEnd(4);
        map.put("UNIQUE_ID", stream.readInteger());
    }

    @Override
    protected int rowMagicNumber() {
        return 1470651441;
    }
}

