/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.swing;

import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentState;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.SwingSDIDocumentBasedApplication;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.logging.Logging;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import javax.swing.JComponent;
import javax.swing.JFrame;

class OpenRecentUICommand<D extends Document, V extends View<JComponent, D>>
extends AbstractUICommand {
    private SwingSDIDocumentBasedApplication<D, V> application;
    private final DocumentState url;

    public OpenRecentUICommand(SwingSDIDocumentBasedApplication<D, V> application, DocumentState url) {
        super(url.getName());
        this.application = application;
        this.url = url;
    }

    public void execute(Object source) {
        if (this.url != null) {
            CPWindow<JFrame, JComponent> window = this.application.createWindow();
            try {
                Document document = this.application.openRemoteDocument(this.url.getName(), this.url.getUrl(), null);
                this.application.setup(window, this.application.createView((JFrame)window.getNativeWindow(), document));
            }
            catch (OpenDocumentException e) {
                Logging.getInstance().process((Throwable)e);
            }
            try {
                File file = Paths.get(new URL(this.url.getUrl()).toURI()).toFile();
                this.application.getFileManager().setFile((Object)((JFrame)window.getNativeWindow()), (Object)file);
            }
            catch (FileSystemNotFoundException file) {
            }
            catch (URISyntaxException e) {
                Logging.getInstance().process((Throwable)e);
            }
            catch (MalformedURLException e) {
                Logging.getInstance().process((Throwable)e);
            }
        }
    }
}

