/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.swing;

import com.macrofocus.application.document.AbstractDocumentBasedApplication;
import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentBasedApplication;
import com.macrofocus.application.document.DocumentBasedApplicationState;
import com.macrofocus.application.document.DocumentOpener;
import com.macrofocus.application.document.DocumentState;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.CPDesktop;
import com.macrofocus.application.document.swing.CloseUICommand;
import com.macrofocus.application.document.swing.ExitUICommand;
import com.macrofocus.application.document.swing.LocalDocumentOpener;
import com.macrofocus.application.document.swing.NewUICommand;
import com.macrofocus.application.document.swing.OpenRecentUICommand;
import com.macrofocus.application.document.swing.OpenUICommand;
import com.macrofocus.application.document.swing.OpenURLUICommand;
import com.macrofocus.application.document.swing.SaveAsUICommand;
import com.macrofocus.application.document.swing.SaveUICommand;
import com.macrofocus.application.document.swing.SwingDragDropHere;
import com.macrofocus.application.file.CPFileChooser;
import com.macrofocus.application.file.CPFileManager;
import com.macrofocus.application.file.DefaultFileManager;
import com.macrofocus.application.file.SwingFileChooser;
import com.macrofocus.application.menu.CPMenu;
import com.macrofocus.application.menu.CPMenuBar;
import com.macrofocus.application.menu.SwingMenu;
import com.macrofocus.application.menu.SwingMenuBar;
import com.macrofocus.application.root.CPDragDropHere;
import com.macrofocus.application.status.CPStatusBar;
import com.macrofocus.application.status.SwingStatusBar;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.application.window.CPWindowManager;
import com.macrofocus.application.window.SwingMFIWindowManager;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.command.FutureCommand;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.common.properties.Property;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Taskbar;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;

public abstract class SwingSDIDocumentBasedApplication<D extends Document, V extends View<JComponent, D>>
extends AbstractDocumentBasedApplication<JFrame, JComponent, File, D, V> {
    private static final boolean BACKGROUND_LOADING = true;
    private DocumentBasedApplicationState<JFrame, JComponent, D, V> state;
    private CPWindowManager<JFrame, V, JComponent> windowManager;
    private CPFileManager<JFrame, File> fileManager;
    protected boolean allowNewDocument = true;
    protected boolean startWithNewDocument = true;
    protected boolean exitOnClose = false;
    protected boolean openFileAutomatic = true;
    private boolean initialized = false;
    private boolean started = false;
    private List<DocumentOpener<D, JFrame, JComponent>> startDocuments = new ArrayList<DocumentOpener<D, JFrame, JComponent>>();
    private CPFileChooser<JFrame, File> fileChooser;
    private final CPDragDropHere.Listener listener = files -> {
        for (final File file : files) {
            DocumentOpener documentOpener = new DocumentOpener<D, JFrame, JComponent>(){

                public D openDocument(CPWindow<JFrame, JComponent> window) throws OpenDocumentException {
                    return SwingSDIDocumentBasedApplication.this.openLocalDocument(file, null, (JFrame)window.getNativeWindow());
                }
            };
            CPWindow<JFrame, JComponent> newWindow = this.createWindow();
            this.openAndShowDocument(newWindow, documentOpener, file);
        }
    };

    public String[] getRecent() {
        return null;
    }

    public DocumentBasedApplicationState<JFrame, JComponent, D, V> getApplicationState() {
        return this.state;
    }

    public void init() {
        block14: {
            assert (!this.initialized);
            this.windowManager = new SwingMFIWindowManager(this);
            this.fileManager = new DefaultFileManager();
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.application.name", this.getName());
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", this.getName());
            System.setProperty("http.agent", this.getName());
            this.state = new DocumentBasedApplicationState(this.getRecent());
            CPDesktop desktop = CPDesktop.getInstance();
            if (desktop != null) {
                try {
                    if (desktop.isSupported(Desktop.Action.APP_OPEN_FILE)) {
                        desktop.setOpenFileHandler(e -> {
                            for (final File file : e.getFiles()) {
                                try {
                                    LocalDocumentOpener documentOpener = new LocalDocumentOpener<D, JFrame, JComponent>(){

                                        @Override
                                        public File getFile() {
                                            return file;
                                        }

                                        public D openDocument(CPWindow<JFrame, JComponent> window) throws OpenDocumentException {
                                            return SwingSDIDocumentBasedApplication.this.openLocalDocument(file, null, (JFrame)window.getNativeWindow());
                                        }
                                    };
                                    if (!this.initialized) {
                                        this.startDocuments.add(documentOpener);
                                        continue;
                                    }
                                    CPWindow<JFrame, JComponent> newWindow = this.createWindow();
                                    this.openAndShowDocument(newWindow, documentOpener, file);
                                }
                                catch (Throwable e1) {
                                    Logging.getInstance().process(e1);
                                }
                            }
                        });
                    }
                    if (desktop.isSupported(Desktop.Action.APP_OPEN_URI)) {
                        desktop.setOpenURIHandler(e -> {
                            CPWindow<JFrame, JComponent> window = this.createWindow();
                            try {
                                final URL url = e.getURI().toURL();
                                if (!this.initialized) {
                                    this.startDocuments.add(new DocumentOpener<D, JFrame, JComponent>(){

                                        public D openDocument(CPWindow<JFrame, JComponent> window) throws OpenDocumentException {
                                            return SwingSDIDocumentBasedApplication.this.openRemoteDocument(url.getFile(), url.toExternalForm(), null);
                                        }
                                    });
                                } else {
                                    this.setup(window, this.createView((JFrame)window.getNativeWindow(), this.openRemoteDocument(url.getFile(), url.toExternalForm(), null)));
                                }
                            }
                            catch (Throwable e1) {
                                Logging.getInstance().process(e1);
                            }
                        });
                    }
                    if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
                        desktop.setAboutHandler(e -> this.showAbout((CPWindow<JFrame, JComponent>)this.windowManager.getActiveWindow()));
                    }
                    if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
                        desktop.setQuitHandler((e, response) -> this.stop());
                    }
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
            try {
                if (!Taskbar.isTaskbarSupported()) break block14;
                try {
                    if (this.getApplicationIcon() != null) {
                        Taskbar.getTaskbar().setIconImage(this.getApplicationIcon());
                    }
                }
                catch (SecurityException e2) {
                    Logging.getInstance().process((Throwable)e2);
                }
                catch (UnsupportedOperationException e2) {}
            }
            catch (NoClassDefFoundError e3) {
                e3.printStackTrace();
            }
        }
        this.initialized = true;
    }

    public CPFileChooser<JFrame, File> getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new SwingFileChooser();
        }
        return this.fileChooser;
    }

    public void showAbout(CPWindow<JFrame, JComponent> window) {
    }

    public void start(final String fileUrl) {
        CPWindow window;
        block11: {
            assert (this.initialized);
            assert (!this.started);
            boolean windowExist = this.windowManager.getWindowCount() == 0;
            CPWindow firstWindow = window = this.windowManager.createWindow();
            if (fileUrl != null) {
                try {
                    if (fileUrl.startsWith("http")) {
                        this.startDocuments.add(new DocumentOpener<D, JFrame, JComponent>(){

                            public D openDocument(CPWindow<JFrame, JComponent> window) throws OpenDocumentException {
                                return SwingSDIDocumentBasedApplication.this.openRemoteDocument(fileUrl, fileUrl, null);
                            }
                        });
                    } else {
                        final File file = new File(fileUrl);
                        this.startDocuments.add(new LocalDocumentOpener<D, JFrame, JComponent>(){

                            @Override
                            public File getFile() {
                                return file;
                            }

                            public D openDocument(CPWindow<JFrame, JComponent> window) throws OpenDocumentException {
                                return SwingSDIDocumentBasedApplication.this.openLocalDocument(file, null, (JFrame)window.getNativeWindow());
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    Logging.getInstance().process(e);
                }
            }
            if (this.startDocuments.isEmpty() && this.openFileAutomatic) {
                try {
                    if (!windowExist) break block11;
                    for (File directory : this.getInstallLocations()) {
                        File[] files = directory.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith("." + SwingSDIDocumentBasedApplication.this.getOpenFileTypes()[0].getExtensions()[0]);
                            }
                        });
                        if (files == null || files.length != 1) continue;
                        final File file = files[0];
                        this.startDocuments.add(new LocalDocumentOpener<D, JFrame, JComponent>(){

                            @Override
                            public File getFile() {
                                return file;
                            }

                            public D openDocument(CPWindow<JFrame, JComponent> window) throws OpenDocumentException {
                                return SwingSDIDocumentBasedApplication.this.openLocalDocument(file, null, (JFrame)window.getNativeWindow());
                            }
                        });
                        break;
                    }
                }
                catch (Throwable e) {
                    Logging.getInstance().process(e);
                }
            }
        }
        this.runAsyncBackground(new Command(){
            CPWindow<JFrame, JComponent> w;
            {
                this.w = window;
            }

            public void execute() {
                boolean success = false;
                if (SwingSDIDocumentBasedApplication.this.startDocuments.isEmpty()) {
                    try {
                        success = SwingSDIDocumentBasedApplication.invokeAndWait(new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                SwingSDIDocumentBasedApplication.this.start(w);
                                return Boolean.TRUE;
                            }
                        });
                    }
                    catch (Exception e) {
                        Logging.getInstance().process((Throwable)e);
                    }
                } else {
                    for (final DocumentOpener documentOpener : SwingSDIDocumentBasedApplication.this.startDocuments) {
                        CPWindow<JFrame, JComponent> newWindow = null;
                        if (this.w != null) {
                            newWindow = this.w;
                        } else {
                            try {
                                newWindow = SwingSDIDocumentBasedApplication.invokeAndWait(new Callable<CPWindow<JFrame, JComponent>>(){

                                    @Override
                                    public CPWindow<JFrame, JComponent> call() throws Exception {
                                        return SwingSDIDocumentBasedApplication.this.windowManager.createWindow();
                                    }
                                });
                            }
                            catch (Exception e) {
                                Logging.getInstance().process((Throwable)e);
                            }
                        }
                        try {
                            final Document document = documentOpener.openDocument(newWindow);
                            final CPWindow<JFrame, JComponent> nw = newWindow;
                            SwingSDIDocumentBasedApplication.invokeAndWait(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    if (documentOpener instanceof LocalDocumentOpener) {
                                        SwingSDIDocumentBasedApplication.this.fileManager.setFile((Object)((JFrame)nw.getNativeWindow()), (Object)((LocalDocumentOpener)documentOpener).getFile());
                                    }
                                    SwingSDIDocumentBasedApplication.this.setup((CPWindow<JFrame, JComponent>)nw, SwingSDIDocumentBasedApplication.this.createView((JFrame)nw.getNativeWindow(), document));
                                    return null;
                                }
                            });
                            if (this.w != null) {
                                this.w = null;
                            }
                            success = true;
                        }
                        catch (Throwable e) {
                            Logging.getInstance().process(e);
                            if (newWindow == this.w) continue;
                            SwingSDIDocumentBasedApplication.this.windowManager.closeWindow(newWindow);
                        }
                    }
                }
                if (!success) {
                    SwingSDIDocumentBasedApplication.this.start(this.w);
                }
                SwingSDIDocumentBasedApplication.this.started = true;
            }
        });
    }

    private Iterable<File> getInstallLocations() {
        File dir;
        String exeDir;
        File dir2;
        String appDir;
        File dir3;
        LinkedHashSet<File> directories = new LinkedHashSet<File>();
        Path currentRelativePath = Paths.get("", new String[0]);
        directories.add(currentRelativePath.toFile());
        String userDir = System.getProperty("user.dir");
        if (userDir != null && (dir3 = new File(userDir)).exists()) {
            directories.add(dir3);
        }
        if ((appDir = System.getProperty("install4j.appDir")) != null && (dir2 = new File(appDir)).exists()) {
            directories.add(dir2);
        }
        if ((exeDir = System.getProperty("install4j.exeDir")) != null && (dir = new File(exeDir)).exists()) {
            directories.add(dir);
        }
        return directories;
    }

    protected final void start(CPWindow<JFrame, JComponent> firstWindow) {
        if (this.startWithNewDocument) {
            this.setup(firstWindow, this.createView((JFrame)firstWindow.getNativeWindow(), this.newDocument()));
        } else {
            this.setup(firstWindow, this.createView((JFrame)firstWindow.getNativeWindow(), null));
        }
    }

    public void stop() {
        this.getApplicationState().triggerClossing();
        System.exit(0);
    }

    public CPWindow<JFrame, JComponent> createWindow() {
        return this.windowManager.createWindow();
    }

    public void showDocument(CPWindow<JFrame, JComponent> window, D document) {
        CPWindow<JFrame, JComponent> newWindow = this.createWindow();
        View view = this.createView((JFrame)newWindow.getNativeWindow(), (Document)document);
        this.setup(newWindow, view);
    }

    public void openAndShowDocument(CPWindow<JFrame, JComponent> window, final DocumentOpener<D, JFrame, JComponent> documentOpener, final File file) {
        final CPWindow<JFrame, JComponent> newWindow = this.createWindow();
        this.runAsyncBackground(new Command(){

            public void execute() {
                try {
                    final Document document = documentOpener.openDocument(newWindow);
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (file != null) {
                                SwingSDIDocumentBasedApplication.this.fileManager.setFile((Object)((JFrame)newWindow.getNativeWindow()), (Object)file);
                            }
                            SwingSDIDocumentBasedApplication.this.setup((CPWindow<JFrame, JComponent>)newWindow, SwingSDIDocumentBasedApplication.this.createView((JFrame)newWindow.getNativeWindow(), document));
                        }
                    });
                }
                catch (Throwable t) {
                    Logging.getInstance().process(t);
                    try {
                        SwingSDIDocumentBasedApplication.this.windowManager.closeWindow(newWindow);
                    }
                    catch (Exception e) {
                        Logging.getInstance().process((Throwable)e);
                    }
                }
            }
        });
    }

    public void configureWindow(JFrame window) {
        window.setIconImage(this.getApplicationIcon());
    }

    public void closeWindow(CPWindow<JFrame, JComponent> window) {
        View view = this.getApplicationState().getView(window);
        if (view != null) {
            this.closeView(view);
        }
    }

    protected Image getApplicationIcon() {
        return null;
    }

    public void setup(CPWindow<JFrame, JComponent> window, V view) {
        this.state.remove(window);
        this.state.remove(view);
        this.state.add(window, view);
        Object title = this.getName();
        if (view.getDocument() != null) {
            title = (String)title + " - " + view.getDocument().getDocumentState().getName();
        }
        ((JFrame)window.getNativeWindow()).setTitle((String)title);
        view.customizeWindow(window);
        JMenuBar menuBar = this.createMenuBar(window, view);
        CPStatusBar<JComponent> statusBar = this.createStatusBar(window, view);
        window.setMenuBar((Object)menuBar);
        window.setStatusBar(statusBar);
        if (view.getDocument() != null) {
            window.setContent((Object)((JComponent)view.getNativeComponent()));
            SwingDragDropHere dragDropHere = new SwingDragDropHere((JComponent)window.getNativeComponent());
            dragDropHere.addListener(this.listener);
        } else {
            SwingDragDropHere dragDropHere = new SwingDragDropHere((JComponent)window.getNativeComponent());
            this.customizeEmptyView(dragDropHere, window);
            dragDropHere.addListener(this.listener);
            window.setContent((Object)dragDropHere.getNativeComponent());
        }
        this.windowManager.assign((Object)((JComponent)window.getNativeComponent()), window, view.getDocument() == null);
    }

    protected void customizeEmptyView(SwingDragDropHere dragDropHere, CPWindow<JFrame, JComponent> window) {
    }

    protected JMenuBar createMenuBar(CPWindow<JFrame, JComponent> window, V view) {
        SwingMenuBar cpMenuBar = new SwingMenuBar();
        JMenuBar menuBar = cpMenuBar.getNativeComponent();
        SwingMenu fileMenu = cpMenuBar.addMenu((Property)view.getProperties().getProperty((Object)"menu.file.label"));
        if (this.allowNewDocument) {
            fileMenu.addAction((UICommand)new NewUICommand(this, (View)view));
        }
        fileMenu.addEllipsisAction((UICommand)new OpenUICommand(this, (View)view, window));
        fileMenu.addEllipsisAction((UICommand)new OpenURLUICommand(this, (View)view, window));
        view.customizeFileOpen((CPMenu)fileMenu);
        SwingMenu reopenMenu = fileMenu.addMenu((Property)view.getProperties().getProperty((Object)"menu.openrecent.label"));
        this.restoreReopen(reopenMenu);
        UICommand reloadCommand = this.getReloadCommand((View)view);
        if (reloadCommand != null) {
            fileMenu.addAction(reloadCommand);
        }
        fileMenu.addSeparator();
        if (this.getSaveFileTypes() != null) {
            fileMenu.addSeparator();
            SaveAsUICommand saveAsUICommand = new SaveAsUICommand(this, (JFrame)window.getNativeWindow(), view);
            fileMenu.addAction((UICommand)new SaveUICommand(this, (JFrame)window.getNativeWindow(), view, saveAsUICommand));
            fileMenu.addEllipsisAction((UICommand)saveAsUICommand);
        }
        view.customizeFileSave((CPMenu)fileMenu);
        fileMenu.addSeparator();
        fileMenu.addAction((UICommand)new CloseUICommand<V>(this, view));
        fileMenu.addAction((UICommand)new ExitUICommand(this, (View)view));
        view.customizeMenuBar((CPMenuBar)cpMenuBar);
        return menuBar;
    }

    private void restoreReopen(SwingMenu reopenMenu) {
        this.populateReopen(reopenMenu);
    }

    private void populateReopen(SwingMenu reopenMenu) {
        reopenMenu.removeAll();
        for (DocumentState documentState : this.getApplicationState().getRecent()) {
            reopenMenu.addAction((UICommand)new OpenRecentUICommand(this, documentState));
        }
    }

    private void saveReopen(SwingMenu reopenMenu) {
    }

    protected CPStatusBar<JComponent> createStatusBar(CPWindow<JFrame, JComponent> window, V view) {
        SwingStatusBar statusBar = new SwingStatusBar();
        view.customizeStatusBar((CPStatusBar)statusBar);
        return statusBar;
    }

    public void runAsyncUIThread(final Command command) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    command.execute();
                }
                catch (Throwable e) {
                    Logging.getInstance().process(e);
                }
            }
        });
    }

    public void runAsyncBackground(final Command command) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    command.execute();
                }
                catch (Throwable e) {
                    Logging.getInstance().process(e);
                }
            }
        }).start();
    }

    public <C extends Command, R> void runAsyncBackground(final C command, final DocumentBasedApplication.Callback<C, R> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    command.execute();
                    callback.execute((Object)command);
                }
                catch (Throwable e) {
                    Logging.getInstance().process(e);
                }
            }
        }).start();
    }

    public <C extends FutureCommand<R>, R> Future<R> runAsyncFuture(final FutureCommand<R> command) {
        Callable callable = new Callable<R>(){

            @Override
            public R call() throws Exception {
                return command.execute();
            }
        };
        final FutureTask future = new FutureTask(callable);
        new Thread(future).start();
        return new Future<R>(){

            public R get() throws Exception {
                return future.get();
            }
        };
    }

    public static <T> FutureTask<T> invokeLater(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        SwingUtilities.invokeLater(task);
        return task;
    }

    public static <T> T invokeAndWait(Callable<T> callable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Throwable t = e.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof InvocationTargetException) {
                    throw (InvocationTargetException)t;
                }
                throw new InvocationTargetException(t);
            }
        }
        try {
            return SwingSDIDocumentBasedApplication.invokeLater(callable).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof InvocationTargetException) {
                throw (InvocationTargetException)t;
            }
            throw new InvocationTargetException(t);
        }
    }

    public static <V> V getFromEDT(Callable<V> callable) throws InterruptedException, ExecutionException {
        FutureTask<V> f = new FutureTask<V>(callable);
        if (SwingUtilities.isEventDispatchThread()) {
            f.run();
        } else {
            SwingUtilities.invokeLater(f);
        }
        return f.get();
    }

    public void closeView(V view) {
        super.closeView(view);
        CPWindow window = this.getApplicationState().getWindow(view);
        this.getApplicationState().remove(window);
        this.getApplicationState().remove(view);
        this.getFileManager().removeWindow((Object)((JFrame)window.getNativeWindow()));
        if (!this.getApplicationState().isEmpty()) {
            if (window != null) {
                this.windowManager.closeWindow(window);
            } else {
                this.stop();
            }
        } else if (this.exitOnClose || view.getDocument() == null) {
            this.windowManager.closeWindow(window);
            this.stop();
        } else {
            this.setup((CPWindow<JFrame, JComponent>)window, this.createView((JFrame)window.getNativeWindow(), null));
        }
    }

    public void openFileChooser(CPWindow<JFrame, JComponent> window) {
        CPFileChooser<JFrame, File> fileChooser = this.getFileChooser();
        fileChooser.setTitle("Open File");
        fileChooser.setFileTypes(this.getOpenFileTypes());
        final File file = (File)fileChooser.showOpenDialog((Object)((JFrame)window.getNativeWindow()));
        if (file != null) {
            try {
                DocumentOpener documentOpener = new DocumentOpener<D, JFrame, JComponent>(){

                    public D openDocument(CPWindow<JFrame, JComponent> window) throws OpenDocumentException {
                        Document document = SwingSDIDocumentBasedApplication.this.openLocalDocument(file, null, (JFrame)window.getNativeWindow());
                        return document;
                    }
                };
                this.openAndShowDocument(window, documentOpener, file);
            }
            catch (Throwable e) {
                Logging.getInstance().process(e);
            }
        }
    }

    public CPWindowManager<JFrame, V, JComponent> getWindowManager() {
        return this.windowManager;
    }

    public CPFileManager<JFrame, File> getFileManager() {
        return this.fileManager;
    }
}

