/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class VerticalFlowLayout
implements LayoutManager,
Serializable {
    int _halign;
    int _valign;
    int _hgap;
    int _vgap;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;

    public VerticalFlowLayout() {
        this(1, 1, 5, 5);
    }

    public VerticalFlowLayout(int halign, int valign) {
        this(halign, valign, 5, 5);
    }

    public VerticalFlowLayout(int halign, int valign, int hgap, int vgap) {
        this._hgap = hgap;
        this._vgap = vgap;
        this.setAlignment(halign, valign);
    }

    public void setAlignment(int halign, int valign) {
        this._halign = halign;
        this._valign = valign;
    }

    public void setHgap(int hgap) {
        this._hgap = hgap;
    }

    public void setVgap(int vgap) {
        this._vgap = vgap;
    }

    public int getHalignment() {
        return this._halign;
    }

    public int getValignment() {
        return this._valign;
    }

    public int getHgap() {
        return this._hgap;
    }

    public int getVgap() {
        return this._vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int ii = 0; ii < nmembers; ++ii) {
                Component m = target.getComponent(ii);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                dim.width = Math.max(dim.width, d.width);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.height += this._vgap;
                }
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this._hgap * 2;
            dim.height += insets.top + insets.bottom + this._vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int ii = 0; ii < nmembers; ++ii) {
                Component m = target.getComponent(ii);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                dim.width = Math.max(dim.width, d.width);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.height += this._vgap;
                }
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this._hgap * 2;
            dim.height += insets.top + insets.bottom + this._vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxheight = target.getHeight() - (insets.top + insets.bottom + this._vgap * 2);
            int nmembers = target.getComponentCount();
            int y = 0;
            Dimension preferredSize = this.preferredLayoutSize(target);
            Dimension targetSize = target.getSize();
            switch (this._valign) {
                case 0: {
                    y = insets.top;
                    break;
                }
                case 1: {
                    y = (targetSize.height - preferredSize.height) / 2;
                    break;
                }
                case 2: {
                    y = targetSize.height - preferredSize.height - insets.bottom;
                }
            }
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (y + d.height > maxheight) break;
                if (y > 0) {
                    y += this._vgap;
                }
                int x = 0;
                switch (this._halign) {
                    case 3: {
                        x = insets.left;
                        break;
                    }
                    case 1: {
                        x = (targetSize.width - d.width) / 2;
                        break;
                    }
                    case 4: {
                        x = targetSize.width - d.width - insets.right;
                    }
                }
                m.setLocation(x, y);
                y = (int)((double)y + d.getHeight());
            }
        }
    }

    public String toString() {
        String halign = "";
        switch (this._halign) {
            case 0: {
                halign = "top";
                break;
            }
            case 1: {
                halign = "center";
                break;
            }
            case 2: {
                halign = "bottom";
            }
        }
        String valign = "";
        switch (this._valign) {
            case 0: {
                valign = "top";
                break;
            }
            case 1: {
                valign = "center";
                break;
            }
            case 2: {
                valign = "bottom";
            }
        }
        return this.getClass().getName() + "[hgap=" + this._hgap + ",vgap=" + this._vgap + ",halign=" + halign + ",valign=" + valign + "]";
    }
}

