/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.logging;

import com.macrofocus.util.logging.SwingLoggingOutput;
import de.javasoft.syntheticaaddons.DetailsDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;

public class DetailsDialogLoggingOutput
implements SwingLoggingOutput {
    private final Component parentComponent;

    public DetailsDialogLoggingOutput(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public boolean process(Throwable t) {
        return this.process(this.parentComponent, t);
    }

    public boolean process(Component parentComponent, Throwable t) {
        t.printStackTrace();
        try {
            Window window = DetailsDialogLoggingOutput.getWindowForComponent(parentComponent);
            DetailsDialog optionPane = new DetailsDialog(window, true);
            optionPane.setType(2);
            optionPane.setTitle("Error");
            String message = t.getMessage();
            if (message != null && message.contains("\n")) {
                message = message.substring(0, message.indexOf("\n"));
            }
            if (message == null) {
                message = t.toString();
            }
            optionPane.setMessage(message != null ? message : "");
            StringBuffer details = new StringBuffer();
            details.append(t.toString());
            details.append("\n");
            StackTraceElement[] trace = t.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                details.append("\tat " + trace[i] + "\n");
            }
            Throwable ourCause = t.getCause();
            if (ourCause != null) {
                this.printStackTraceAsCause(ourCause, details, trace);
            }
            optionPane.setDetails(details.toString());
            try {
                optionPane.showDialog();
            }
            catch (HeadlessException headlessException) {
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private void printStackTraceAsCause(Throwable t, StringBuffer details, StackTraceElement[] causedTrace) {
        Throwable ourCause;
        StackTraceElement[] trace = t.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        details.append("Caused by " + t + "\n");
        for (int i = 0; i <= m; ++i) {
            details.append("\tat " + trace[i] + "\n");
        }
        if (framesInCommon != 0) {
            details.append("\t... " + framesInCommon + " more\n");
        }
        if ((ourCause = t.getCause()) != null) {
            this.printStackTraceAsCause(ourCause, details, trace);
        }
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return null;
        }
        return !(parentComponent instanceof Frame) && !(parentComponent instanceof Dialog) ? DetailsDialogLoggingOutput.getWindowForComponent(parentComponent.getParent()) : (Window)parentComponent;
    }
}

