/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.window;

import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.SwingSDIDocumentBasedApplication;
import com.macrofocus.application.window.AbstractWindowManager;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.application.window.SwingSDIWindowManager;
import com.macrofocus.application.window.SwingWindow;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class SwingMFIWindowManager<V extends View<JComponent, ?>>
extends AbstractWindowManager<JFrame, V, JComponent> {
    private boolean singleNewWindow = true;
    private final SwingSDIDocumentBasedApplication application;
    private final List<SwingWindow> windows;
    private CPWindow<JFrame, JComponent> newWindow;

    public SwingMFIWindowManager(SwingSDIDocumentBasedApplication application) {
        this.application = application;
        this.windows = new ArrayList<SwingWindow>();
        this.newWindow = null;
    }

    public int getWindowCount() {
        return this.windows.size();
    }

    public CPWindow<JFrame, JComponent> createWindow() {
        if (this.singleNewWindow && this.newWindow != null) {
            CPWindow<JFrame, JComponent> window = this.newWindow;
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(1) && SwingSDIWindowManager.isFrameMinimized(window)) {
                ((JFrame)window.getNativeWindow()).setState(0);
            }
            ((JFrame)window.getNativeWindow()).toFront();
            ((JFrame)window.getNativeWindow()).requestFocus();
            return window;
        }
        SwingWindow window = new SwingWindow();
        this.configureWindow(window);
        window.getNativeWindow().setSize(1000, 720);
        window.getNativeWindow().setLocationRelativeTo(null);
        window.getNativeWindow().setLocationByPlatform(true);
        window.getNativeWindow().setVisible(true);
        window.getNativeWindow().toFront();
        window.getNativeWindow().requestFocus();
        this.windows.add(window);
        this.newWindow = window;
        return window;
    }

    protected void configureWindow(final SwingWindow window) {
        window.getNativeWindow().setDefaultCloseOperation(0);
        window.getNativeWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingMFIWindowManager.this.application.closeWindow(window);
            }
        });
        this.application.configureWindow(window.getNativeWindow());
    }

    public CPWindow<JFrame, JComponent> getNewWindow() {
        return this.newWindow;
    }

    public void closeWindow(CPWindow<JFrame, JComponent> window) {
        ((JFrame)window.getNativeWindow()).getContentPane().removeAll();
        if (this.newWindow == window) {
            this.newWindow = null;
        }
        this.windows.remove(window);
        window.dispose();
    }

    public void assign(JComponent component, CPWindow<JFrame, JComponent> window, boolean newView) {
        if (newView) {
            this.newWindow = window;
        } else if (this.newWindow == window) {
            this.newWindow = null;
        }
    }

    public CPWindow<JFrame, JComponent> getActiveWindow() {
        Window activeWindow = FocusManager.getCurrentManager().getActiveWindow();
        if (activeWindow != null) {
            for (SwingWindow window : this.windows) {
                if (activeWindow != window.getNativeWindow()) continue;
                return window;
            }
        }
        return null;
    }
}

