/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.resources.properties;

import com.macrofocus.resources.properties.AbstractPropertyPropertiesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;

public class ResourceBundlePropertiesModel
extends AbstractPropertyPropertiesModel {
    private Hashtable hashtable;

    public ResourceBundlePropertiesModel() {
        this.hashtable = new Hashtable();
    }

    public ResourceBundlePropertiesModel(ResourceBundle resourceBundle) {
        Enumeration<String> elements = resourceBundle.getKeys();
        this.hashtable = new Hashtable();
        while (elements.hasMoreElements()) {
            String key = elements.nextElement();
            Object value = resourceBundle.getObject(key);
            this.hashtable.put(key, value);
        }
    }

    public ResourceBundlePropertiesModel(String[] keys, Object[] values) {
        this.hashtable = new Hashtable();
        int count = Math.min(keys.length, values.length);
        for (int i = 0; i < count; ++i) {
            this.hashtable.put(keys[i], values[i]);
        }
    }

    @Override
    public void reload() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAvailable(String key) {
        return this.hashtable.get(key) != null;
    }

    @Override
    public boolean isAvailable(Class cl, String name, String property) {
        return name != null && this.hashtable.get(cl.getName() + "." + name + "." + property) != null || this.hashtable.get(cl.getName() + "." + property) != null;
    }

    @Override
    public Object getValue(String key) {
        Object value = this.hashtable.get(key);
        return value;
    }

    @Override
    public Object getValue(String key, Object defaultValue) {
        if (this.hashtable.containsKey(key)) {
            Object value = this.hashtable.get(key);
            if (value == null) {
                throw new RuntimeException("Cannot find value for " + key);
            }
            return value;
        }
        return defaultValue;
    }

    @Override
    public Color getColor(String key) {
        return (Color)this.getValue(key);
    }

    @Override
    public Object getValue(Class cl, String name, String property) {
        Object value = null;
        if (name != null && this.hashtable.get(cl.getName() + "." + name + "." + property) != null) {
            value = this.hashtable.get(cl.getName() + "." + name + "." + property);
        } else if (this.hashtable.get(cl.getName() + "." + property) != null) {
            value = this.hashtable.get(cl.getName() + "." + property);
        }
        if (value == null) {
            throw new RuntimeException("Cannot find value for " + cl.getName() + "." + name + "." + property);
        }
        return value;
    }

    @Override
    public Object getValue(Class cl, String property) {
        Object value = this.hashtable.get(cl.getName() + "." + property);
        if (value == null) {
            throw new RuntimeException("Cannot find value for " + cl.getName() + "." + property);
        }
        return value;
    }

    @Override
    public void setValue(Class cl, String name, String property, Object value) {
        String key = cl.getName() + "." + name + "." + property;
        if (this.hashtable.containsKey(key)) {
            Object oldValue = this.hashtable.get(key);
            if (!value.equals(oldValue)) {
                this.hashtable.put(key, value);
                this.notifyPropertiesChanged(new PropertiesEvent(this, key, value, oldValue));
            }
        } else {
            this.hashtable.put(key, value);
            this.notifyPropertiesChanged(new PropertiesEvent(this, key, value, null));
        }
    }

    @Override
    public void setValue(Class cl, String name, Object value) {
        String key = cl.getName() + "." + name;
        if (this.hashtable.containsKey(key)) {
            Object oldValue = this.hashtable.get(key);
            if (!value.equals(oldValue)) {
                this.hashtable.put(key, value);
                this.notifyPropertiesChanged(new PropertiesEvent(this, key, value, oldValue));
            }
        } else {
            this.hashtable.put(key, value);
            this.notifyPropertiesChanged(new PropertiesEvent(this, key, value, null));
        }
    }

    @Override
    public void setValue(String key, Object value) {
        if (this.hashtable.containsKey(key)) {
            Object oldValue = this.hashtable.get(key);
            if (value != null || oldValue != null || !value.equals(oldValue)) {
                if (value == null) {
                    this.hashtable.remove(key);
                } else {
                    this.hashtable.put(key, value);
                }
                this.notifyPropertiesChanged(new PropertiesEvent(this, key, value, oldValue));
            }
        } else {
            if (value != null) {
                this.hashtable.put(key, value);
            }
            this.notifyPropertiesChanged(new PropertiesEvent(this, key, value, null));
        }
        this.notifyPropertiesChanged(new PropertiesEvent(this));
    }

    @Override
    public void setValues(PropertiesModel propertiesModel) {
        this.hashtable.putAll(propertiesModel.getMap());
        this.notifyPropertiesChanged(new PropertiesEvent(this));
    }

    @Override
    public void setValues(Hashtable hashtable) {
        this.hashtable.putAll(hashtable);
        this.notifyPropertiesChanged(new PropertiesEvent(this));
    }

    @Override
    public void resetValues(PropertiesModel propertiesModel) {
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(propertiesModel.getMap());
        this.hashtable = hashtable;
        this.notifyPropertiesChanged(new PropertiesEvent(this));
    }

    @Override
    public Map getMap() {
        return this.hashtable;
    }

    public String toString() {
        return this.getClass().getName() + "[hashtable=" + this.hashtable + "]";
    }
}

